/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.ChartText;
import com.klg.jclass.chart.ErrorDialog;
import com.klg.jclass.chart.Extents;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartBundle;
import com.klg.jclass.chart.JCChartDateFormat;
import com.klg.jclass.chart.JCValueLabel;
import com.klg.jclass.util.JCNumberUtil;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;

class AnnotationHandler
implements Serializable {
    Vector valueLabels = new Vector();
    Vector userValueLabels = new Vector();
    Extents extents = new Extents();
    int realPlacement = 1;
    int anchor = 16;
    JCAxis parent = null;
    private transient JCChartDateFormat dateFormatter = null;

    AnnotationHandler(JCAxis jCAxis) {
        this.parent = jCAxis;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void calcAnchor() {
        this.realPlacement = this.parent.placement.value;
        if (this.realPlacement == 0) {
            this.realPlacement = 1;
        }
        boolean bl = false;
        if (this.parent.otherAxis != null) {
            boolean bl2 = bl = this.parent.otherAxis.origin.value - this.parent.otherAxis.min.value > this.parent.otherAxis.max.value - this.parent.otherAxis.origin.value;
        }
        if (this.parent.vertical) {
            this.anchor = this.realPlacement == 2 || this.realPlacement == 5 && bl ? 1 : 2;
            if (this.parent.otherAxis == null || !this.parent.otherAxis.reversed) return;
            switch (this.anchor) {
                case 1: {
                    this.anchor = 2;
                    return;
                }
                case 2: {
                    this.anchor = 1;
                    return;
                }
                default: {
                    return;
                }
            }
        }
        this.anchor = this.realPlacement == 2 || this.realPlacement == 5 && bl ? 16 : 32;
        if (this.parent.otherAxis == null || !this.parent.otherAxis.reversed) return;
        switch (this.anchor) {
            case 16: {
                this.anchor = 32;
                break;
            }
            case 32: {
                this.anchor = 16;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void calcAnnotationExtents() {
        this.extents.ortho = 0;
        this.extents.minor = 0;
        this.extents.major = 0;
        if (!this.parent.visible) {
            return;
        }
        int n2 = this.firstVisibleLabel();
        int n3 = this.lastVisibleLabel();
        if (n2 >= 0 && n2 < this.valueLabels.size() && n3 >= 0 && n3 < this.valueLabels.size()) {
            JCValueLabel jCValueLabel = (JCValueLabel)this.valueLabels.elementAt(n2);
            JCValueLabel jCValueLabel2 = (JCValueLabel)this.valueLabels.elementAt(n3);
            jCValueLabel.label.recalc();
            jCValueLabel2.label.recalc();
            if (this.parent.vertical) {
                this.extents.minor = jCValueLabel2.label.getHeight() / 2 + 1;
                this.extents.major = jCValueLabel.label.getHeight() / 2 + 1;
            } else {
                this.extents.minor = jCValueLabel.label.getWidth() / 2 + 1;
                this.extents.major = jCValueLabel2.label.getWidth() / 2 + 1;
            }
            int n4 = n2;
            while (n4 <= n3) {
                int n5;
                JCValueLabel jCValueLabel3 = (JCValueLabel)this.valueLabels.elementAt(n4);
                jCValueLabel3.label.recalc();
                int n6 = n5 = this.parent.vertical ? jCValueLabel3.label.getWidth() : jCValueLabel3.label.getHeight();
                if ((n5 += this.parent.tickLength / 2 + 1) > this.extents.ortho) {
                    this.extents.ortho = n5;
                }
                ++n4;
            }
        }
        if (this.parent.reversed) {
            int n7 = this.extents.minor;
            this.extents.minor = this.extents.major;
            this.extents.major = n7;
        }
        if (!this.parent.title.visible) return;
        if (this.parent.vertical) {
            switch (this.parent.title.placement.value) {
                case 17: 
                case 18: {
                    this.extents.minor += this.parent.title.getHeight() + 1;
                    this.extents.ortho = Math.max(this.parent.title.getWidth() + 1, this.extents.ortho);
                    return;
                }
                case 33: 
                case 34: {
                    this.extents.major += this.parent.title.getHeight() + 1;
                    this.extents.ortho = Math.max(this.parent.title.getWidth() + 1, this.extents.ortho);
                    return;
                }
                case 1: 
                case 2: {
                    this.extents.ortho += this.parent.title.getWidth() + 1;
                    return;
                }
                default: {
                    return;
                }
            }
        }
        switch (this.parent.title.placement.value) {
            case 16: 
            case 32: {
                this.extents.ortho += this.parent.title.getHeight() + 1;
            }
        }
    }

    void checkAnnotations() {
        if (this.valueLabels == null) {
            return;
        }
        if (this.valueLabels.size() < 1) {
            return;
        }
        if (this.parent.annotationMethod == 0) {
            this.checkValueAnnotations();
        } else if (this.parent.annotationMethod == 2) {
            this.checkTimeAnnotations();
        } else {
            this.checkUserProvidedAnnotations();
        }
    }

    private boolean checkLocation(JCValueLabel jCValueLabel) {
        if (jCValueLabel == null) {
            return false;
        }
        ChartText chartText = jCValueLabel.getChartText();
        if (this.parent.vertical) {
            int n2 = chartText.getTop() + chartText.getHeight() / 2;
            return n2 >= this.parent.getTop() && n2 <= this.parent.getTop() + this.parent.getHeight();
        }
        int n3 = chartText.getLeft() + chartText.getWidth() / 2;
        return n3 >= this.parent.getLeft() && n3 <= this.parent.getLeft() + this.parent.getWidth();
    }

    private void checkTimeAnnotations() {
        double d2 = this.parent.max.value - this.parent.min.value;
        int n2 = this.valueLabels.size();
        int n3 = this.firstVisibleLabel();
        int n4 = this.lastVisibleLabel();
        Dimension dimension = new Dimension(0, 0);
        this.timeLabelExtents(dimension);
        int n5 = this.parent.vertical ? this.parent.getHeight() : this.parent.getWidth();
        int n6 = 0;
        if (n2 >= 2) {
            JCValueLabel jCValueLabel = (JCValueLabel)this.valueLabels.elementAt(0);
            JCValueLabel jCValueLabel2 = (JCValueLabel)this.valueLabels.elementAt(1);
            n6 = (int)JCNumberUtil.precCorrect(0, (double)n5 * (Math.abs(jCValueLabel2.value - jCValueLabel.value) / d2));
            n6 = Math.max(n6, 1);
        } else {
            n6 = 1;
        }
        int n7 = this.parent.vertical ? dimension.height : dimension.width;
        int n8 = (n7 + this.parent.gap * 2) / n6;
        boolean bl = n8 >= 1;
        ++n8;
        if (n3 >= 0) {
            int n9 = n3;
            while (n9 <= n4) {
                JCValueLabel jCValueLabel = (JCValueLabel)this.valueLabels.elementAt(n9);
                ChartText chartText = jCValueLabel.getChartText();
                chartText.visible = this.checkLocation(jCValueLabel);
                if (chartText.visible && bl) {
                    jCValueLabel.getChartText().visible = (n9 - n3) % n8 == 0;
                }
                ++n9;
            }
        }
    }

    private void checkUserProvidedAnnotations() {
        ChartText chartText;
        JCValueLabel jCValueLabel;
        if (this.valueLabels == null) {
            return;
        }
        if (this.valueLabels.size() < 1) {
            return;
        }
        int n2 = 0;
        Rectangle rectangle = null;
        while (n2 < this.valueLabels.size()) {
            jCValueLabel = (JCValueLabel)this.valueLabels.elementAt(n2);
            chartText = jCValueLabel.getChartText();
            if (!(jCValueLabel.value < this.parent.min.value)) {
                chartText.visible = true;
                rectangle = new Rectangle(chartText.getLeft(), chartText.getTop(), chartText.getWidth() + this.parent.gap, chartText.getHeight() + this.parent.gap);
                break;
            }
            chartText.visible = false;
            ++n2;
        }
        if (rectangle == null || n2 >= this.valueLabels.size()) {
            return;
        }
        ++n2;
        while (n2 < this.valueLabels.size()) {
            jCValueLabel = (JCValueLabel)this.valueLabels.elementAt(n2);
            chartText = jCValueLabel.getChartText();
            if (jCValueLabel.value > this.parent.max.value) {
                chartText.visible = false;
            } else {
                Rectangle rectangle2 = new Rectangle(chartText.getLeft(), chartText.getTop(), chartText.getWidth() + this.parent.gap, chartText.getHeight() + this.parent.gap);
                if (rectangle2.intersects(rectangle)) {
                    chartText.visible = false;
                } else {
                    chartText.visible = true;
                    rectangle = rectangle2;
                }
            }
            ++n2;
        }
    }

    private void checkValueAnnotations() {
        int n2 = this.parent.toPixel(this.parent.min.value);
        int n3 = this.parent.toPixel(this.parent.max.value);
        int n4 = JCNumberUtil.abs(n3 - n2);
        int n5 = this.valueLabels.size();
        if (n5 > n4) {
            n5 = n4;
            this.valueLabels = new Vector();
            int n6 = this.parent.precision.value;
            int n7 = 0;
            while (n7 < n5) {
                double d2 = this.parent.toData(n2 + n7);
                d2 = JCNumberUtil.precCorrect(n6, d2);
                JCValueLabel jCValueLabel = new JCValueLabel(this.parent, d2, n6);
                this.valueLabels.addElement(jCValueLabel);
                ++n7;
            }
            this.layout();
        }
    }

    Date dataToTime(double d2, long l2) {
        Date date = this.parent.timeBase;
        if (l2 < 86400000L) {
            return new Date(date.getTime() + (long)(d2 * (double)l2));
        }
        Date date2 = new Date(date.getTime());
        boolean bl = l2 >= 604800000L && l2 < 2678400000L;
        long l3 = (long)d2;
        double d3 = d2 - (double)l3;
        long l4 = bl ? l3 * 7L : l3;
        this.getDateFormatter().addToUnit(date2, l2, (int)l4);
        try {
            if (d2 < 0.0 && date2.after(date)) {
                return null;
            }
            if (d2 > 0.0 && date2.before(date)) {
                return null;
            }
        }
        catch (Exception exception) {
            return null;
        }
        if (10.0 + d3 != 10.0) {
            Date date3 = new Date(date.getTime());
            if (d2 < 0.0) {
                --l3;
                d3 = -d3;
            } else {
                ++l3;
            }
            l4 = bl ? l3 * 7L : l3;
            this.getDateFormatter().addToUnit(date3, l2, (int)l4);
            Date date4 = date2;
            date2 = new Date(date4.getTime() + (long)(d3 * (double)(date3.getTime() - date4.getTime())));
        }
        return date2;
    }

    void draw(Graphics graphics) {
        int n2 = this.firstVisibleLabel();
        int n3 = this.lastVisibleLabel();
        if (n2 < 0 || n2 > this.valueLabels.size() || n3 < 0 || n3 > this.valueLabels.size()) {
            return;
        }
        int n4 = n2;
        while (n4 <= n3) {
            try {
                JCValueLabel jCValueLabel = (JCValueLabel)this.valueLabels.elementAt(n4);
                jCValueLabel.label.draw(graphics);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
            }
            ++n4;
        }
    }

    int firstVisibleLabel() {
        int n2 = 0;
        while (n2 < this.valueLabels.size()) {
            JCValueLabel jCValueLabel = (JCValueLabel)this.valueLabels.elementAt(n2);
            if (jCValueLabel.getChartText().visible) break;
            ++n2;
        }
        return n2;
    }

    JCChartDateFormat getDateFormatter() {
        if (this.dateFormatter == null) {
            this.dateFormatter = new JCChartDateFormat();
        }
        return this.dateFormatter;
    }

    int lastVisibleLabel() {
        int n2 = this.valueLabels.size() - 1;
        while (n2 >= 0) {
            JCValueLabel jCValueLabel = (JCValueLabel)this.valueLabels.elementAt(n2);
            if (jCValueLabel.getChartText().visible) break;
            --n2;
        }
        return n2;
    }

    void layout() {
        int n2 = 0;
        while (n2 < this.valueLabels.size()) {
            JCValueLabel jCValueLabel = (JCValueLabel)this.valueLabels.elementAt(n2);
            if (!this.parent.isLogarithmic() || !(jCValueLabel.value <= 0.0)) {
                int n3 = this.parent.toPixel(jCValueLabel.value);
                this.layout(jCValueLabel.label, n3);
            }
            ++n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void layout(ChartText chartText, int n2) {
        chartText.recalc();
        if (this.parent.vertical) {
            switch (this.anchor) {
                case 2: {
                    chartText.setLocation(this.parent.getLeft() + this.parent.getWidth() - chartText.getWidth() - this.parent.tickLength / 2 - 1, n2 - chartText.getHeight() / 2);
                    return;
                }
                case 1: {
                    chartText.setLocation(this.parent.getLeft() + this.parent.tickLength / 2 + 1, n2 - chartText.getHeight() / 2);
                    return;
                }
                default: {
                    return;
                }
            }
        }
        switch (this.anchor) {
            case 16: {
                chartText.setLocation(n2 - chartText.getWidth() / 2, this.parent.getTop() + this.parent.getHeight() - chartText.getHeight() - this.parent.tickLength / 2 - 1);
                return;
            }
            default: {
                chartText.setLocation(n2 - chartText.getWidth() / 2, this.parent.getTop() + this.parent.tickLength / 2 + 1);
                return;
            }
        }
    }

    void makeAnnotations() {
        block14: {
            block16: {
                block15: {
                    block13: {
                        if (this.parent.annotationMethod != 1) break block13;
                        this.sortValueLabels();
                        this.makeValueLabels();
                        break block14;
                    }
                    if (this.parent.annotationMethod != 2) break block15;
                    this.makeTimeLabels();
                    break block14;
                }
                if (this.parent.annotationMethod != 3) break block16;
                ChartDataView chartDataView = ((JCChart)this.parent.chartArea.getParent()).findData(this.parent);
                if (chartDataView == null) break block14;
                ChartDataViewSeries chartDataViewSeries = null;
                try {
                    chartDataViewSeries = chartDataView.getSeries(0);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                if (chartDataViewSeries != null) {
                    this.valueLabels = new Vector();
                    int n2 = 0;
                    while (n2 < chartDataView.getPointLabels().size() && n2 < chartDataViewSeries.maxXIndex()) {
                        String string = (String)chartDataView.getPointLabels().get(n2);
                        if (string != null) {
                            JCValueLabel jCValueLabel = new JCValueLabel(chartDataViewSeries.getX(n2), string, this.parent);
                            jCValueLabel.label.setRotation(this.parent.annotationRotation);
                            jCValueLabel.setParent(this.parent);
                            this.valueLabels.addElement(jCValueLabel);
                        }
                        ++n2;
                    }
                }
                break block14;
            }
            if (this.parent.annotationMethod == 0) {
                this.valueLabels = new Vector();
                int n3 = this.parent.precision.value;
                if (this.parent.logarithmic) {
                    int n4 = JCNumberUtil.intLog10(this.parent.min.value);
                    int n5 = JCNumberUtil.intLog10(this.parent.max.value);
                    int n6 = n5 - n4 + 1;
                    boolean bl = false;
                    if (this.parent.logIncrement > 1) {
                        bl = n6 % this.parent.logIncrement != 0;
                        n6 /= this.parent.logIncrement;
                        if (bl) {
                            ++n6;
                        }
                    }
                    int n7 = n4;
                    int n8 = 0;
                    while (n7 <= n5) {
                        JCValueLabel jCValueLabel = new JCValueLabel(this.parent, n7, n3);
                        this.valueLabels.addElement(jCValueLabel);
                        n7 += this.parent.logIncrement;
                        ++n8;
                    }
                } else {
                    double d2 = this.parent.numSpacing.value;
                    double d3 = JCNumberUtil.calcError(n3);
                    if ((d2 = JCNumberUtil.precCorrect(n3, d2)) < d3) {
                        return;
                    }
                    double d4 = this.parent.firstInc(d2);
                    while (d4 <= this.parent.max.value + d3) {
                        JCValueLabel jCValueLabel = new JCValueLabel(this.parent, d4, n3);
                        this.valueLabels.addElement(jCValueLabel);
                        d4 += d2;
                    }
                }
            }
        }
    }

    private void makeTimeLabels() {
        this.valueLabels = new Vector();
        if (this.parent.timeBase == null) {
            this.parent.timeBase = new Date();
        }
        long l2 = this.parent.timeUnit;
        double d2 = (this.parent.max.value - this.parent.min.value) * (double)l2;
        if (this.parent.getTimeFormatIsDefault() || this.parent.getTimeFormat() == null || this.parent.getTimeFormat().equals("")) {
            this.getDateFormatter();
            this.parent.setTimeFormat(JCChartDateFormat.getDefaultTimeFormat(d2), false);
            this.parent.setTimeFormatIsDefault(true, false);
        }
        String string = this.parent.getTimeFormat();
        int n2 = this.parent.annotationRotation;
        String string2 = this.getDateFormatter().getLargestTimeLabel(string);
        boolean bl = this.parent.getNumberLocalization();
        this.parent.setNumberLocalization(false);
        JCValueLabel jCValueLabel = new JCValueLabel(0.0, string2, this.parent);
        if (bl) {
            this.parent.setNumberLocalization(true);
        }
        jCValueLabel.label.setRotation(n2);
        jCValueLabel.setParent(this.parent);
        Dimension dimension = jCValueLabel.label.calcSize();
        Dimension dimension2 = n2 == 0 || n2 == 2 ? new Dimension(dimension.width, dimension.height) : new Dimension(dimension.height, dimension.width);
        int n3 = this.parent.vertical ? this.parent.getHeight() / (dimension2.height + this.parent.gap * 2) : this.parent.getWidth() / (dimension2.width + this.parent.gap * 2);
        n3 = Math.max(n3, 2);
        long l3 = (long)(d2 / (double)n3);
        l3 = this.getDateFormatter().niceInc(l3 / 2L, string);
        n3 = (int)(d2 / (double)l3) + 2;
        this.parent.timeBase.setTime(JCNumberUtil.clamp(this.parent.timeBase.getTime(), JCChartDateFormat.getMinTime().getTime(), JCChartDateFormat.getMaxTime().getTime()));
        Date date = new Date(this.parent.timeBase.getTime());
        this.getDateFormatter().roundTime(date, l3, false);
        long l4 = this.parent.timeBase.getTime() - date.getTime();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(this.parent.timeBase);
        int n4 = gregorianCalendar.get(1);
        int n5 = gregorianCalendar.get(2);
        int n6 = gregorianCalendar.get(5);
        int n7 = gregorianCalendar.get(16);
        gregorianCalendar.setTime(date);
        int n8 = gregorianCalendar.get(2);
        int n9 = gregorianCalendar.get(16);
        if (gregorianCalendar.isLeapYear(n4) && (n5 >= 2 || n5 == 1 && n6 == 29) && n8 <= 1) {
            l4 -= 86400000L;
        }
        if (n9 < n7) {
            l4 += 3600000L;
        } else if (n9 > n7) {
            l4 -= 3600000L;
        }
        if (l4 < 0L) {
            l4 += 3600000L;
        }
        this.getDateFormatter();
        long l5 = JCChartDateFormat.timeIncUnits(l3);
        double d3 = (double)l3 / (double)l5;
        date = this.dataToTime(this.parent.min.value, l2);
        double d4 = this.timeToData(date, l5);
        long l6 = (long)(d4 / d3);
        d4 = d3 * (double)l6;
        long l7 = JCChartDateFormat.getMinTime().getTime();
        long l8 = JCChartDateFormat.getMaxTime().getTime();
        long l9 = l7;
        long l10 = l8;
        Date date2 = null;
        try {
            date2 = this.dataToTime(this.parent.min.value, l2);
            this.getDateFormatter().roundTime(date2, l3, false);
            l9 = date2 == null ? l7 : date2.getTime();
        }
        catch (Exception exception) {}
        try {
            date2 = this.dataToTime(this.parent.max.value, l2);
            this.getDateFormatter().roundTime(date2, l3, true);
            l10 = date2 == null ? l8 : date2.getTime();
        }
        catch (Exception exception) {}
        boolean bl2 = false;
        Date date3 = new Date();
        int n10 = 0;
        while (n10 < n3) {
            block25: {
                String string3;
                try {
                    date = this.dataToTime(d4, l5);
                    if (date == null) break block25;
                    long l11 = date.getTime() - l4;
                    gregorianCalendar.setTime(date);
                    int n11 = gregorianCalendar.get(5);
                    int n12 = gregorianCalendar.get(1);
                    int n13 = gregorianCalendar.get(2);
                    int n14 = gregorianCalendar.get(16);
                    if (l5 == 2678400000L && n6 != n11 && n6 > n11) {
                        l11 += (long)(n6 - n11) * 86400000L;
                    }
                    date3.setTime(l11);
                    gregorianCalendar.setTime(date3);
                    int n15 = gregorianCalendar.get(16);
                    if (n15 < n14) {
                        l11 += 3600000L;
                    } else if (n15 > n14) {
                        l11 -= 3600000L;
                    }
                    if (gregorianCalendar.isLeapYear(n12)) {
                        date3.setTime(l11);
                        gregorianCalendar.setTime(date3);
                        int n16 = gregorianCalendar.get(2);
                        if ((n13 >= 2 || n13 == 1 && n11 == 29) && n16 <= 1) {
                            l11 -= 86400000L;
                        }
                    }
                    if (l7 > l11 || l8 < l11) {
                        bl2 = true;
                        --n3;
                        --n10;
                        break block25;
                    }
                    if (l9 > l11 || l10 < l11) {
                        --n3;
                        --n10;
                        break block25;
                    }
                    date.setTime(l11);
                    string3 = this.getDateFormatter().timeLabel(string, date);
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.out);
                    string3 = new String(JCChartBundle.string("com.klg.jclass.chart.Key31"));
                }
                double d5 = this.timeToData(date, l2);
                this.parent.setNumberLocalization(false);
                JCValueLabel jCValueLabel2 = new JCValueLabel(d5, string3, this.parent);
                if (bl) {
                    this.parent.setNumberLocalization(true);
                }
                jCValueLabel2.label.setRotation(n2);
                jCValueLabel2.setParent(this.parent);
                this.valueLabels.addElement(jCValueLabel2);
            }
            ++n10;
            d4 += d3;
        }
        if (bl2) {
            ErrorDialog.raise(this.parent, JCChartBundle.string("com.klg.jclass.chart.Key118"));
        }
    }

    private void makeValueLabels() {
        this.valueLabels = new Vector();
        try {
            int n2 = 0;
            while (n2 < this.userValueLabels.size()) {
                JCValueLabel jCValueLabel = (JCValueLabel)this.userValueLabels.elementAt(n2);
                JCValueLabel jCValueLabel2 = new JCValueLabel(jCValueLabel.value, jCValueLabel.label.text, this.parent);
                jCValueLabel2.label.setRotation(this.parent.annotationRotation);
                jCValueLabel2.label.setBackground(jCValueLabel.label.background);
                jCValueLabel2.label.setForeground(jCValueLabel.label.foreground);
                jCValueLabel2.label.setFont(jCValueLabel.label.font);
                jCValueLabel2.setParent(this.parent);
                this.valueLabels.insertElementAt(jCValueLabel2, n2);
                ++n2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    void setValueLabelParent(JCChart jCChart) {
        JCValueLabel jCValueLabel;
        int n2;
        if (this.valueLabels != null) {
            n2 = 0;
            while (n2 < this.valueLabels.size()) {
                jCValueLabel = (JCValueLabel)this.valueLabels.elementAt(n2);
                jCValueLabel.getChartText().setParentChart(jCChart);
                ++n2;
            }
        }
        if (this.userValueLabels != null) {
            n2 = 0;
            while (n2 < this.userValueLabels.size()) {
                jCValueLabel = (JCValueLabel)this.userValueLabels.elementAt(n2);
                jCValueLabel.getChartText().setParentChart(jCChart);
                ++n2;
            }
        }
    }

    void sortValueLabels() {
        Vector vector = this.userValueLabels;
        this.userValueLabels = new Vector();
        try {
            int n2 = 0;
            while (n2 < vector.size()) {
                JCValueLabel jCValueLabel = (JCValueLabel)vector.elementAt(n2);
                int n3 = 0;
                while (n3 < this.userValueLabels.size()) {
                    JCValueLabel jCValueLabel2 = (JCValueLabel)this.userValueLabels.elementAt(n3);
                    if (jCValueLabel.value < jCValueLabel2.value) break;
                    ++n3;
                }
                this.userValueLabels.insertElementAt(jCValueLabel, n3);
                ++n2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    private void timeLabelExtents(Dimension dimension) {
        Serializable serializable;
        Serializable serializable2 = null;
        boolean bl = this.parent.annotationRotation == 1 || this.parent.annotationRotation == 3;
        int n2 = 0;
        dimension.height = 0;
        dimension.width = 0;
        int n3 = 0;
        while (n3 < this.valueLabels.size()) {
            serializable = (JCValueLabel)this.valueLabels.elementAt(n3);
            int n4 = ((JCValueLabel)serializable).getChartText().getText().length();
            if (n4 > n2) {
                n2 = n4;
                serializable2 = serializable;
            }
            ++n3;
        }
        if (serializable2 == null) {
            return;
        }
        serializable = serializable2.getChartText().calcSize();
        if (bl) {
            dimension.width = ((Dimension)serializable).height;
            dimension.height = ((Dimension)serializable).width;
        } else {
            dimension.width = ((Dimension)serializable).width;
            dimension.height = ((Dimension)serializable).height;
        }
    }

    double timeToData(Date date, long l2) {
        double d2;
        double d3 = l2;
        if (date == null) {
            return 0.0;
        }
        long l3 = this.parent.timeBase.getTime();
        Date date2 = JCChartDateFormat.getMinTime();
        Date date3 = JCChartDateFormat.getMaxTime();
        if (date.before(date2)) {
            return (double)(date2.getTime() - l3) / d3;
        }
        if (date.after(date3)) {
            return (double)(date3.getTime() - l3) / d3;
        }
        double d4 = d2 = (double)(date.getTime() - l3) / d3;
        if (l2 < 86400000L) {
            return d2;
        }
        double d5 = d2 - 2.0;
        double d6 = d2 + 2.0;
        Date date4 = this.dataToTime(d5, l2);
        Date date5 = this.dataToTime(d6, l2);
        if (date4 == null || date4.after(date)) {
            d5 = (double)(date2.getTime() - l3) / d3;
            date4 = this.dataToTime(d5, l2);
        }
        if (date5 == null || date5.before(date)) {
            d6 = (double)(date3.getTime() - l3) / d3;
            date5 = this.dataToTime(d6, l2);
        }
        while (d6 - d5 > 1.0E-6) {
            d2 = (d5 + d6) / 2.0;
            Date date6 = this.dataToTime(d2, l2);
            if (date6 == null) {
                return d4;
            }
            if (date6.before(date) || date4 == null) {
                d5 = d2;
                date4 = date6;
                continue;
            }
            if (date6.after(date) || date5 == null) {
                d6 = d2;
                date5 = date6;
                continue;
            }
            return d2;
        }
        return d2;
    }
}

