/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.beans;

import com.klg.jclass.beans.AbstractBeanEditor;
import com.klg.jclass.util.swing.JCFontChooser;
import com.klg.jclass.util.swing.JCFontChooserPane;
import com.klg.jclass.util.swing.JCFontEvent;
import com.klg.jclass.util.swing.JCFontListener;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class FontChooserEditor
extends AbstractBeanEditor
implements JCFontListener {
    public static final String FONT_CHOOSER_HELP = "Font Chooser";
    protected Font font;
    protected boolean underline;
    protected JCFontChooserPane fontChooser;

    public FontChooserEditor() {
        super("com.klg.jclass.beans.resources.LocaleInfo", FONT_CHOOSER_HELP, "Font Editor");
    }

    public void fontChanged(JCFontEvent jCFontEvent) {
        if (jCFontEvent.getSource() == this.fontChooser) {
            this.font = this.fontChooser.getSelectedFont();
            this.underline = this.fontChooser.isUnderline();
            this.support.firePropertyChange(null, null, null);
        }
    }

    public void fontChanging(JCFontEvent jCFontEvent) {
    }

    public Component getEditorComponent() {
        JPanel jPanel = new JPanel();
        BoxLayout boxLayout = new BoxLayout(jPanel, 1);
        jPanel.setLayout(boxLayout);
        this.fontChooser = new JCFontChooserPane();
        this.fontChooser.addJCFontListener(this);
        jPanel.add(this.fontChooser);
        return jPanel;
    }

    public String getJavaInitializationString() {
        if (this.font == null) {
            return "null";
        }
        if (this.underline) {
            return "com.klg.jclass.util.swing.JCFontChooser.setUnderline(new java.awt.Font(\"" + this.font.getFontName() + "\", " + this.font.getStyle() + ", " + this.font.getSize() + ")," + this.fontChooser.isUnderline() + ")";
        }
        return "new java.awt.Font(\"" + this.font.getFontName() + "\", " + (this.font.getStyle() & 0xFFFFFFFB) + ", " + this.font.getSize() + ")";
    }

    public Object getValue() {
        return JCFontChooser.setUnderline(this.font, this.fontChooser.isUnderline());
    }

    protected String getValueAsText() {
        return null;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.getContentPane().add(new FontChooserEditor());
        jFrame.pack();
        jFrame.show();
    }

    public void setValue(Object object) {
        if (object == null) {
            this.font = null;
        } else {
            Font font = (Font)object;
            this.font = new Font(font.getAttributes());
            this.fontChooser.setSelectedFont(this.font);
            this.underline = this.fontChooser.isUnderline();
        }
    }
}

