/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.beans;

import com.klg.jclass.util.swing.JCSwingTypeConverter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import javax.swing.JColorChooser;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorStringEditor
implements PropertyEditor,
ChangeListener {
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected String target = "";
    protected JColorChooser colorChooser = null;

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public String getAsText() {
        return this.target;
    }

    public Component getCustomEditor() {
        if (this.colorChooser == null) {
            this.colorChooser = new JColorChooser();
            Color color = JCSwingTypeConverter.toColor(this.target);
            if (color != null) {
                this.colorChooser.setColor(color);
            }
            this.colorChooser.getSelectionModel().addChangeListener(this);
        }
        return this.colorChooser;
    }

    public String getJavaInitializationString() {
        return "\"" + this.target + "\"";
    }

    public String[] getTags() {
        return null;
    }

    public Object getValue() {
        return this.target;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        Color color = graphics.getColor();
        graphics.setColor(JCSwingTypeConverter.toColor(this.target));
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(color);
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void setAsText(String string) {
        this.target = string;
        if (this.support != null) {
            this.support.firePropertyChange("", null, this.getValue());
        }
    }

    public void setValue(Object object) {
        this.target = (String)object;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        String string;
        Object object = changeEvent.getSource();
        if (object == this.colorChooser.getSelectionModel() && !this.target.equals(string = JCSwingTypeConverter.fromColor(this.colorChooser.getSelectionModel().getSelectedColor()))) {
            this.target = string;
            this.support.firePropertyChange("", null, null);
        }
    }

    public boolean supportsCustomEditor() {
        return true;
    }
}

