/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.beans;

import com.klg.jclass.beans.JCBeanInfo;
import com.klg.jclass.util.swing.JCIconCreator;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ColorEditorPanel
extends JPanel
implements ActionListener {
    public static final String COLOR_INHERIT = "inherit";
    public static final String COLOR_BLACK = "black";
    public static final String COLOR_BLUE = "blue";
    public static final String COLOR_CYAN = "cyan";
    public static final String COLOR_DARKGRAY = "darkGray";
    public static final String COLOR_GRAY = "gray";
    public static final String COLOR_GREEN = "green";
    public static final String COLOR_LIGHTGRAY = "lightGray";
    public static final String COLOR_MAGENTA = "magenta";
    public static final String COLOR_ORANGE = "orange";
    public static final String COLOR_PINK = "pink";
    public static final String COLOR_RED = "red";
    public static final String COLOR_WHITE = "white";
    public static final String COLOR_YELLOW = "yellow";
    private String inherit_string = "";
    private JButton colorButton = null;
    private JPanel colorLabel = null;
    private JTextField colorField = null;
    private JColorChooser colorChooser = null;
    private JDialog colorChooserDialog = null;
    protected PropertyChangeSupport listeners = null;
    private static String[] rainbow = new String[]{"rrrr gggg bbbb", "rrrr gggg bbbb", "rrrr gggg bbbb", "rrrr gggg bbbb", "rrrr gggg bbbb", "rrrr gggg bbbb", "rrrr gggg bbbb", "rrrr gggg bbbb", "              ", "              ", "              ", "  ..  ..  ..  ", "  ..  ..  ..  "};

    public ColorEditorPanel() {
        this((Color)null);
    }

    public ColorEditorPanel(Color color) {
        Color color2 = color != null ? color : this.getBackground();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.colorField = new JTextField("", 15);
        this.colorField.addActionListener(this);
        this.add((Component)this.colorField, gridBagConstraints);
        this.colorLabel = new JPanel();
        this.colorLabel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.add((Component)this.colorLabel, gridBagConstraints);
        this.colorButton = new JButton(new ImageIcon(ColorEditorPanel.rainbowImage(this)));
        this.colorButton.addActionListener(this);
        this.add((Component)this.colorButton, gridBagConstraints);
        JCBeanInfo.getLocaleManager().add("com.klg.jclass.beans.resources.LocaleInfo");
        this.inherit_string = JCBeanInfo.getLocaleManager().getString(COLOR_INHERIT);
        this.setValue(color);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.colorField) {
            String string = this.colorField.getText();
            Color color = ColorEditorPanel.toColor(string);
            if (color == null || string.equalsIgnoreCase("null") || string.indexOf(this.inherit_string) >= 0) {
                this.colorField.setText(this.inherit_string);
                this.colorLabel.setBackground(null);
                if (this.listeners != null) {
                    this.listeners.firePropertyChange("", null, null);
                }
            } else {
                this.colorLabel.setBackground(color);
                if (this.listeners != null) {
                    this.listeners.firePropertyChange("", null, this.getValue());
                }
            }
            this.colorLabel.paintImmediately(new Rectangle(this.colorLabel.getWidth(), this.colorLabel.getHeight()));
        } else if (actionEvent.getSource() == this.colorButton) {
            if (this.colorChooserDialog == null) {
                this.colorChooserDialog = (JDialog)this.getCustomEditor();
            }
            if (this.colorChooser != null) {
                this.colorChooser.setColor((Color)this.getValue());
            }
            this.colorChooserDialog.show();
        } else if (actionEvent.getSource() instanceof JButton && actionEvent.getActionCommand().compareTo("OK") == 0) {
            Color color = this.colorChooser.getColor();
            this.colorField.setText(this.getColorName(color));
            this.colorLabel.setBackground(color);
            this.colorLabel.paintImmediately(new Rectangle(this.colorLabel.getWidth(), this.colorLabel.getHeight()));
            if (this.listeners != null) {
                this.listeners.firePropertyChange("", null, this.getValue());
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            this.listeners = new PropertyChangeSupport(this);
        }
        this.listeners.addPropertyChangeListener(propertyChangeListener);
    }

    private String getColorName(Color color) {
        if (color == null) {
            return this.inherit_string;
        }
        if (color.equals(Color.black)) {
            return JCBeanInfo.getLocaleManager().getString(COLOR_BLACK);
        }
        if (color.equals(Color.blue)) {
            return JCBeanInfo.getLocaleManager().getString(COLOR_BLUE);
        }
        if (color.equals(Color.cyan)) {
            return JCBeanInfo.getLocaleManager().getString(COLOR_CYAN);
        }
        if (color.equals(Color.darkGray)) {
            return JCBeanInfo.getLocaleManager().getString(COLOR_DARKGRAY);
        }
        if (color.equals(Color.gray)) {
            return JCBeanInfo.getLocaleManager().getString(COLOR_GRAY);
        }
        if (color.equals(Color.green)) {
            return JCBeanInfo.getLocaleManager().getString(COLOR_GREEN);
        }
        if (color.equals(Color.lightGray)) {
            return JCBeanInfo.getLocaleManager().getString(COLOR_LIGHTGRAY);
        }
        if (color.equals(Color.magenta)) {
            return JCBeanInfo.getLocaleManager().getString(COLOR_MAGENTA);
        }
        if (color.equals(Color.orange)) {
            return JCBeanInfo.getLocaleManager().getString(COLOR_ORANGE);
        }
        if (color.equals(Color.pink)) {
            return JCBeanInfo.getLocaleManager().getString(COLOR_PINK);
        }
        if (color.equals(Color.red)) {
            return JCBeanInfo.getLocaleManager().getString(COLOR_RED);
        }
        if (color.equals(Color.white)) {
            return JCBeanInfo.getLocaleManager().getString(COLOR_WHITE);
        }
        if (color.equals(Color.yellow)) {
            return JCBeanInfo.getLocaleManager().getString(COLOR_YELLOW);
        }
        return color.getRed() + "-" + color.getGreen() + "-" + color.getBlue();
    }

    public Component getCustomEditor() {
        if (this.colorChooser == null) {
            this.colorChooser = new JColorChooser();
            this.colorChooser.setColor((Color)this.getValue());
        }
        if (this.colorChooserDialog == null) {
            this.colorChooserDialog = JColorChooser.createDialog(this.colorButton, "Choose Color", true, this.colorChooser, this, this);
        }
        return this.colorChooserDialog;
    }

    public Object getValue() {
        return this.colorLabel.getBackground();
    }

    private static Image rainbowImage(Component component) {
        JCIconCreator jCIconCreator = new JCIconCreator(rainbow[0].length(), rainbow.length);
        jCIconCreator.setColor('.', new Color(0));
        jCIconCreator.setColor('r', new Color(0xFF0000));
        jCIconCreator.setColor('g', new Color(65280));
        jCIconCreator.setColor('b', new Color(255));
        jCIconCreator.setPixels(rainbow);
        return jCIconCreator.getIcon().getImage();
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removePropertyChangeListener(propertyChangeListener);
    }

    public void setValue(Object object) {
        String string;
        Color color;
        if (object == null) {
            this.colorField.setText(this.inherit_string);
            this.colorLabel.setBackground(null);
            this.colorLabel.paintImmediately(new Rectangle(this.colorLabel.getWidth(), this.colorLabel.getHeight()));
        } else if (object instanceof Color) {
            Color color2 = (Color)object;
            String string2 = this.getColorName(color2);
            this.colorField.setText(string2);
            this.colorLabel.setBackground(color2);
            this.colorLabel.paintImmediately(new Rectangle(this.colorLabel.getWidth(), this.colorLabel.getHeight()));
        } else if (object instanceof String && (color = ColorEditorPanel.toColor(string = (String)object)) != null) {
            this.colorField.setText(string);
            this.colorLabel.setBackground(color);
            this.colorLabel.paintImmediately(new Rectangle(this.colorLabel.getWidth(), this.colorLabel.getHeight()));
        }
    }

    private static Color toColor(String string) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = stringTokenizer.nextToken("-");
        if (string2 == null) {
            return null;
        }
        if ((string2 = string2.trim()).equalsIgnoreCase(JCBeanInfo.getLocaleManager().getString(COLOR_BLACK))) {
            return Color.black;
        }
        if (string2.equalsIgnoreCase(JCBeanInfo.getLocaleManager().getString(COLOR_BLUE))) {
            return Color.blue;
        }
        if (string2.equalsIgnoreCase(JCBeanInfo.getLocaleManager().getString(COLOR_CYAN))) {
            return Color.cyan;
        }
        if (string2.equalsIgnoreCase(JCBeanInfo.getLocaleManager().getString(COLOR_DARKGRAY))) {
            return Color.darkGray;
        }
        if (string2.equalsIgnoreCase(JCBeanInfo.getLocaleManager().getString(COLOR_GRAY))) {
            return Color.gray;
        }
        if (string2.equalsIgnoreCase(JCBeanInfo.getLocaleManager().getString(COLOR_GREEN))) {
            return Color.green;
        }
        if (string2.equalsIgnoreCase(JCBeanInfo.getLocaleManager().getString(COLOR_LIGHTGRAY))) {
            return Color.lightGray;
        }
        if (string2.equalsIgnoreCase(JCBeanInfo.getLocaleManager().getString(COLOR_MAGENTA))) {
            return Color.magenta;
        }
        if (string2.equalsIgnoreCase(JCBeanInfo.getLocaleManager().getString(COLOR_ORANGE))) {
            return Color.orange;
        }
        if (string2.equalsIgnoreCase(JCBeanInfo.getLocaleManager().getString(COLOR_PINK))) {
            return Color.pink;
        }
        if (string2.equalsIgnoreCase(JCBeanInfo.getLocaleManager().getString(COLOR_RED))) {
            return Color.red;
        }
        if (string2.equalsIgnoreCase(JCBeanInfo.getLocaleManager().getString(COLOR_WHITE))) {
            return Color.white;
        }
        if (string2.equalsIgnoreCase(JCBeanInfo.getLocaleManager().getString(COLOR_YELLOW))) {
            return Color.yellow;
        }
        try {
            if (string2.startsWith("#")) {
                if (string2.length() >= 13) {
                    return new Color(Integer.valueOf(string2.substring(1, 5), 16) / 256, Integer.valueOf(string2.substring(5, 9), 16) / 256, Integer.valueOf(string2.substring(9, 13), 16) / 256);
                }
                if (string2.length() >= 7) {
                    return new Color(Integer.valueOf(string2.substring(1, 3), 16), Integer.valueOf(string2.substring(3, 5), 16), Integer.valueOf(string2.substring(5, 7), 16));
                }
                return new Color(Integer.valueOf(string2.substring(1), 16));
            }
            int n2 = Integer.parseInt(string2);
            int n3 = Integer.parseInt(stringTokenizer.nextToken("-"));
            int n4 = Integer.parseInt(stringTokenizer.nextToken("-"));
            return new Color(n2, n3, n4);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

