/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.beans;

import com.klg.jclass.beans.ColorEditorPanel;
import com.klg.jclass.beans.JCBeanInfo;
import com.klg.jclass.util.swing.JCAlignLayout;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.border.TitledBorder;

public class BorderEditorPanel
extends JPanel
implements ActionListener,
ItemListener,
FocusListener,
PropertyChangeListener {
    protected JComboBox borderCB = null;
    protected JPanel subPanel = null;
    protected JLabel matteColorLabel = null;
    protected ColorEditorPanel lineColorEditor = null;
    protected ColorEditorPanel matteColorEditor = null;
    protected ColorEditorPanel shadowColorEditor = null;
    protected ColorEditorPanel highlightColorEditor = null;
    protected JTextField topTF = null;
    protected JTextField leftTF = null;
    protected JTextField bottomTF = null;
    protected JTextField rightTF = null;
    protected ButtonGroup bevelGroup = null;
    protected JRadioButton bevelLoweredRB = null;
    protected JRadioButton bevelRaisedRB = null;
    protected JTextField thickTF = null;
    protected JTextField titledTF = null;
    static final int EMPTY = 0;
    static final int BEVEL = 1;
    static final int ETCHED = 2;
    static final int LINE = 3;
    static final int SOFTBEVEL = 4;
    static final int TITLED = 5;
    static final int MATTE = 6;
    public static final String BORDER_EMPTY = "Empty";
    public static final String BORDER_BEVEL = "Bevel";
    public static final String BORDER_ETCHED = "Etched";
    public static final String BORDER_LINE = "Line";
    public static final String BORDER_SOFT_BEVEL = "Soft Bevel";
    public static final String BORDER_TITLED = "Titled";
    public static final String BORDER_PROP_TITLE = "Border Properties";
    public static final String BORDER_LOWERED = "Lowered";
    public static final String BORDER_RAISED = "Raised";
    public static final String BORDER_HIGH_COLOR = "Highlight Color";
    public static final String BORDER_SHAD_COLOR = "Shadow Color";
    public static final String BORDER_LINE_COLOR = "Line Color";
    public static final String BORDER_LINE_THICKNESS = "Line Thickness";
    public static final String BORDER_TOP_MARGIN = "Top Margin";
    public static final String BORDER_LEFT_MARGIN = "Left Margin";
    public static final String BORDER_BOTTOM_MARGIN = "Bottom Margin";
    public static final String BORDER_RIGHT_MARGIN = "Right Margin";
    public static final String BORDER_MATTE_COLOR = "Matte Color";
    public static final String BORDER_TITLE_TEXT = "Title Text";
    static int[] border_values;
    static String[] border_i18n_names;
    static String[] border_cards;
    int currentBorderType = 0;
    Border currentBorder = BorderFactory.createEmptyBorder();
    protected PropertyChangeSupport listeners = null;

    static {
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        border_values = nArray;
        border_i18n_names = null;
        border_cards = new String[]{"Matte", BORDER_BEVEL, BORDER_BEVEL, BORDER_LINE, BORDER_BEVEL, BORDER_TITLED, "Matte"};
    }

    public BorderEditorPanel() {
        this.init();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        this.changeBorder();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            this.listeners = new PropertyChangeSupport(this);
        }
        this.listeners.addPropertyChangeListener(propertyChangeListener);
    }

    private void cardChanging() {
        switch (this.currentBorderType) {
            case 0: {
                this.matteColorLabel.setVisible(false);
                this.matteColorEditor.setVisible(false);
                break;
            }
            case 6: {
                this.matteColorLabel.setVisible(true);
                this.matteColorEditor.setVisible(true);
                break;
            }
        }
    }

    public void changeBorder() {
        switch (this.currentBorderType) {
            case 0: {
                Insets insets = this.getBorderInsets();
                this.currentBorder = BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right);
                break;
            }
            case 1: {
                Color color = (Color)this.highlightColorEditor.getValue();
                Color color2 = (Color)this.shadowColorEditor.getValue();
                int n2 = this.getBevelType();
                if (n2 < 0) {
                    n2 = 1;
                }
                if (color == null || color2 == null) {
                    this.currentBorder = BorderFactory.createBevelBorder(n2);
                    break;
                }
                this.currentBorder = BorderFactory.createBevelBorder(n2, color, color2);
                break;
            }
            case 2: {
                Color color = (Color)this.highlightColorEditor.getValue();
                Color color3 = (Color)this.shadowColorEditor.getValue();
                int n3 = this.getBevelType();
                if (n3 >= 0) {
                    this.currentBorder = new EtchedBorder(n3, color, color3);
                    break;
                }
                this.currentBorder = BorderFactory.createEtchedBorder(color, color3);
                break;
            }
            case 3: {
                Color color = (Color)this.lineColorEditor.getValue();
                int n4 = 0;
                try {
                    n4 = Integer.valueOf(this.thickTF.getText());
                }
                catch (NumberFormatException numberFormatException) {}
                this.currentBorder = BorderFactory.createLineBorder(color, n4);
                break;
            }
            case 6: {
                Color color = (Color)this.matteColorEditor.getValue();
                Insets insets = this.getBorderInsets();
                this.currentBorder = BorderFactory.createMatteBorder(insets.top, insets.left, insets.bottom, insets.right, color);
                break;
            }
            case 4: {
                Color color = (Color)this.highlightColorEditor.getValue();
                Color color4 = (Color)this.shadowColorEditor.getValue();
                int n5 = this.getBevelType();
                if (n5 < 0) {
                    n5 = 1;
                }
                this.currentBorder = new SoftBevelBorder(n5, color, color4);
                break;
            }
            case 5: {
                this.currentBorder = BorderFactory.createTitledBorder(this.titledTF.getText());
                break;
            }
            default: {
                this.currentBorder = BorderFactory.createEmptyBorder();
            }
        }
        if (this.listeners != null) {
            this.listeners.firePropertyChange("", null, this.currentBorder);
        }
    }

    private JPanel createBevelCard() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2));
        jPanel2.setBorder(BorderFactory.createLineBorder(this.getForeground(), 1));
        this.bevelGroup = new ButtonGroup();
        this.bevelLoweredRB = new JRadioButton(JCBeanInfo.getLocaleManager().getString(BORDER_LOWERED));
        this.bevelRaisedRB = new JRadioButton(JCBeanInfo.getLocaleManager().getString(BORDER_RAISED));
        this.bevelLoweredRB.addActionListener(this);
        this.bevelRaisedRB.addActionListener(this);
        this.bevelGroup.add(this.bevelLoweredRB);
        this.bevelGroup.add(this.bevelRaisedRB);
        jPanel2.add(this.bevelLoweredRB);
        jPanel2.add(this.bevelRaisedRB);
        jPanel.add("North", jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new JCAlignLayout());
        JLabel jLabel = new JLabel(JCBeanInfo.getLocaleManager().getString(BORDER_HIGH_COLOR));
        JLabel jLabel2 = new JLabel(JCBeanInfo.getLocaleManager().getString(BORDER_SHAD_COLOR));
        this.highlightColorEditor = new ColorEditorPanel(null);
        this.highlightColorEditor.addPropertyChangeListener(this);
        this.shadowColorEditor = new ColorEditorPanel(null);
        this.shadowColorEditor.addPropertyChangeListener(this);
        jPanel3.add(jLabel);
        jPanel3.add(this.highlightColorEditor);
        jPanel3.add(jLabel2);
        jPanel3.add(this.shadowColorEditor);
        jPanel.add("Center", jPanel3);
        return jPanel;
    }

    private JPanel createLineCard() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new JCAlignLayout());
        JLabel jLabel = new JLabel(JCBeanInfo.getLocaleManager().getString(BORDER_LINE_COLOR));
        this.lineColorEditor = new ColorEditorPanel(this.getForeground());
        this.lineColorEditor.addPropertyChangeListener(this);
        JLabel jLabel2 = new JLabel(JCBeanInfo.getLocaleManager().getString(BORDER_LINE_THICKNESS));
        this.thickTF = new JTextField(5);
        this.thickTF.addActionListener(this);
        this.thickTF.addFocusListener(this);
        jPanel.add(jLabel);
        jPanel.add(this.lineColorEditor);
        jPanel.add(jLabel2);
        jPanel.add(this.thickTF);
        return jPanel;
    }

    private JPanel createMatteCard() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new JCAlignLayout());
        JLabel jLabel = new JLabel(JCBeanInfo.getLocaleManager().getString(BORDER_TOP_MARGIN));
        JLabel jLabel2 = new JLabel(JCBeanInfo.getLocaleManager().getString(BORDER_LEFT_MARGIN));
        JLabel jLabel3 = new JLabel(JCBeanInfo.getLocaleManager().getString(BORDER_BOTTOM_MARGIN));
        JLabel jLabel4 = new JLabel(JCBeanInfo.getLocaleManager().getString(BORDER_RIGHT_MARGIN));
        this.topTF = new JTextField(5);
        this.leftTF = new JTextField(5);
        this.bottomTF = new JTextField(5);
        this.rightTF = new JTextField(5);
        this.topTF.addActionListener(this);
        this.topTF.addFocusListener(this);
        this.leftTF.addActionListener(this);
        this.leftTF.addFocusListener(this);
        this.bottomTF.addActionListener(this);
        this.bottomTF.addFocusListener(this);
        this.rightTF.addActionListener(this);
        this.rightTF.addFocusListener(this);
        this.matteColorLabel = new JLabel(JCBeanInfo.getLocaleManager().getString(BORDER_MATTE_COLOR));
        this.matteColorEditor = new ColorEditorPanel(this.getForeground());
        this.matteColorEditor.addPropertyChangeListener(this);
        jPanel.add(jLabel);
        jPanel.add(this.topTF);
        jPanel.add(jLabel2);
        jPanel.add(this.leftTF);
        jPanel.add(jLabel3);
        jPanel.add(this.bottomTF);
        jPanel.add(jLabel4);
        jPanel.add(this.rightTF);
        jPanel.add(this.matteColorLabel);
        jPanel.add(this.matteColorEditor);
        return jPanel;
    }

    private JPanel createTitledCard() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new JCAlignLayout());
        JLabel jLabel = new JLabel(JCBeanInfo.getLocaleManager().getString(BORDER_TITLE_TEXT));
        jPanel.add(jLabel);
        this.titledTF = new JTextField(20);
        this.titledTF.addActionListener(this);
        this.titledTF.addFocusListener(this);
        jPanel.add(this.titledTF);
        return jPanel;
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        this.changeBorder();
    }

    private int getBevelType() {
        int n2 = -1;
        if (this.bevelLoweredRB.isSelected()) {
            n2 = this.currentBorderType == 2 ? 1 : 1;
        } else if (this.bevelRaisedRB.isSelected()) {
            n2 = this.currentBorderType == 2 ? 0 : 0;
        }
        return n2;
    }

    private Insets getBorderInsets() {
        Insets insets = new Insets(0, 0, 0, 0);
        try {
            insets.top = Integer.valueOf(this.topTF.getText());
        }
        catch (NumberFormatException numberFormatException) {}
        try {
            insets.left = Integer.valueOf(this.leftTF.getText());
        }
        catch (NumberFormatException numberFormatException) {}
        try {
            insets.bottom = Integer.valueOf(this.bottomTF.getText());
        }
        catch (NumberFormatException numberFormatException) {}
        try {
            insets.right = Integer.valueOf(this.rightTF.getText());
        }
        catch (NumberFormatException numberFormatException) {}
        return insets;
    }

    public Object getValue() {
        return this.currentBorder;
    }

    public void init() {
        JCBeanInfo.getLocaleManager().add("com.klg.jclass.beans.resources.LocaleInfo");
        border_i18n_names = new String[6];
        BorderEditorPanel.border_i18n_names[0] = JCBeanInfo.getLocaleManager().getString(BORDER_EMPTY);
        BorderEditorPanel.border_i18n_names[1] = JCBeanInfo.getLocaleManager().getString(BORDER_BEVEL);
        BorderEditorPanel.border_i18n_names[2] = JCBeanInfo.getLocaleManager().getString(BORDER_ETCHED);
        BorderEditorPanel.border_i18n_names[3] = JCBeanInfo.getLocaleManager().getString(BORDER_LINE);
        BorderEditorPanel.border_i18n_names[4] = JCBeanInfo.getLocaleManager().getString(BORDER_SOFT_BEVEL);
        BorderEditorPanel.border_i18n_names[5] = JCBeanInfo.getLocaleManager().getString(BORDER_TITLED);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.setLayout(new BorderLayout());
        this.borderCB = new JComboBox<String>(border_i18n_names);
        this.borderCB.addItemListener(this);
        this.add("North", this.borderCB);
        this.subPanel = new JPanel();
        this.subPanel.setBorder(BorderFactory.createTitledBorder(JCBeanInfo.getLocaleManager().getString(BORDER_PROP_TITLE)));
        this.subPanel.setLayout(new CardLayout());
        this.subPanel.add((Component)this.createMatteCard(), border_cards[6]);
        this.subPanel.add((Component)this.createBevelCard(), border_cards[1]);
        this.subPanel.add((Component)this.createLineCard(), border_cards[3]);
        this.subPanel.add((Component)this.createTitledCard(), border_cards[5]);
        this.add("Center", this.subPanel);
        this.cardChanging();
        this.changeBorder();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.borderCB && itemEvent.getStateChange() == 1) {
            this.currentBorderType = this.borderCB.getSelectedIndex();
            CardLayout cardLayout = (CardLayout)this.subPanel.getLayout();
            this.changeBorder();
            this.cardChanging();
            cardLayout.show(this.subPanel, border_cards[this.currentBorderType]);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        this.changeBorder();
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removePropertyChangeListener(propertyChangeListener);
    }

    public void setBackground(Color color) {
    }

    public void setValue(Object object) {
        Border border;
        JComponent jComponent;
        if (object instanceof Border) {
            if (!this.currentBorder.equals((Border)object)) {
                this.currentBorder = (Border)object;
                this.updateCard((Border)object, this);
            }
        } else if (object instanceof JComponent && (jComponent = (JComponent)object) != null && !this.currentBorder.equals(border = jComponent.getBorder())) {
            this.currentBorder = border;
            this.updateCard(border, jComponent);
        }
    }

    private void updateCard(Border border, JComponent jComponent) {
        if (border instanceof EmptyBorder) {
            EmptyBorder emptyBorder = (EmptyBorder)border;
            Insets insets = emptyBorder.getBorderInsets(null);
            this.topTF.setText(String.valueOf(insets.top));
            this.leftTF.setText(String.valueOf(insets.left));
            this.bottomTF.setText(String.valueOf(insets.bottom));
            this.rightTF.setText(String.valueOf(insets.right));
            if (border instanceof MatteBorder) {
                this.borderCB.setSelectedIndex(6);
            } else {
                this.borderCB.setSelectedIndex(0);
            }
        } else if (border instanceof BevelBorder) {
            BevelBorder bevelBorder = (BevelBorder)border;
            Color color = bevelBorder.getHighlightInnerColor(jComponent);
            Color color2 = bevelBorder.getShadowOuterColor(jComponent);
            this.highlightColorEditor.setValue(color);
            this.shadowColorEditor.setValue(color2);
            int n2 = bevelBorder.getBevelType();
            if (n2 == 0) {
                this.bevelRaisedRB.setSelected(true);
            } else {
                this.bevelLoweredRB.setSelected(true);
            }
            if (border instanceof SoftBevelBorder) {
                this.borderCB.setSelectedIndex(4);
            } else {
                this.borderCB.setSelectedIndex(1);
            }
        } else if (border instanceof EtchedBorder) {
            EtchedBorder etchedBorder = (EtchedBorder)border;
            Color color = etchedBorder.getHighlightColor(jComponent);
            Color color3 = etchedBorder.getShadowColor(jComponent);
            this.highlightColorEditor.setValue(color);
            this.shadowColorEditor.setValue(color3);
            int n3 = etchedBorder.getEtchType();
            if (n3 == 0) {
                this.bevelRaisedRB.setSelected(true);
            } else {
                this.bevelLoweredRB.setSelected(true);
            }
            this.borderCB.setSelectedIndex(2);
        } else if (border instanceof LineBorder) {
            LineBorder lineBorder = (LineBorder)border;
            this.thickTF.setText(String.valueOf(lineBorder.getThickness()));
            this.lineColorEditor.setValue(lineBorder.getLineColor());
            this.borderCB.setSelectedIndex(3);
        } else if (border instanceof TitledBorder) {
            this.titledTF.setText(((TitledBorder)this.currentBorder).getTitle());
            this.borderCB.setSelectedIndex(5);
        }
    }
}

