/*
 * Decompiled with CFR 0.152.
 */
package webshadow.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import webshadow.util.ByteSearch;

public class LineInputStream
extends FilterInputStream {
    boolean eof = false;
    byte[] buf = new byte[4096];
    int pos = 0;
    int count = 0;
    byte[] boundary = null;
    int boundaryPos = -1;

    public LineInputStream(InputStream in) throws IOException {
        super(in);
    }

    public LineInputStream(Socket sock) throws IOException {
        this(sock.getInputStream());
        sock.setSoTimeout(1000);
    }

    public final boolean expectBoundary() throws IOException {
        this.findBoundary();
        return this.pos == this.boundaryPos;
    }

    public final void setBoundary(String boundary) {
        this.boundary = boundary.getBytes();
    }

    public final void unread(byte[] b, int off, int len) {
        if (this.pos < len) {
            if (this.count - this.pos + len < this.buf.length) {
                byte[] newBuf = new byte[this.count - this.pos + len];
                System.arraycopy(b, off, newBuf, 0, len);
                System.arraycopy(this.buf, this.pos, newBuf, len, this.count - this.pos);
                this.buf = newBuf;
                return;
            }
            System.arraycopy(this.buf, this.pos, this.buf, len, this.count - this.pos);
            this.count += len - this.pos;
            this.pos = len;
        }
        System.arraycopy(b, off, this.buf, this.pos - len, len);
        this.pos -= len;
    }

    public final void unread(byte[] b) {
        this.unread(b, 0, b.length);
    }

    public final void unread(byte b) {
        byte[] tmp = new byte[]{b};
        this.unread(tmp);
    }

    final boolean findBoundary() throws IOException {
        if (this.boundary == null) {
            return false;
        }
        if (this.boundaryPos >= 0) {
            return true;
        }
        while (!this.eof && this.count - this.pos < this.boundary.length) {
            this.fill();
        }
        this.boundaryPos = ByteSearch.find(this.boundary, this.buf, this.pos, this.count);
        return this.boundaryPos >= 0;
    }

    final void fill() throws IOException {
        if (this.pos < this.count && this.pos > 0) {
            System.arraycopy(this.buf, this.pos, this.buf, 0, this.count - this.pos);
            this.count -= this.pos;
        } else {
            this.count = 0;
        }
        this.pos = 0;
        int res = 0;
        while (res == 0) {
            try {
                res = this.in.read(this.buf, this.count, this.buf.length - this.count);
            }
            catch (SocketTimeoutException ste) {
                res = ste.bytesTransferred;
            }
        }
        if (res < 0) {
            this.eof = true;
        } else {
            this.count += res;
        }
    }

    public final int read() throws IOException {
        byte[] b = new byte[1];
        if (this.read(b) > 0) {
            return b[0] & 0xFF;
        }
        return -1;
    }

    public final int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public final int read(byte[] b, int offs, int len) throws IOException {
        int n = 0;
        if (!this.eof && this.pos >= this.count) {
            this.fill();
        }
        if (this.count - this.pos > 0) {
            int left;
            if (this.boundaryPos < this.pos) {
                left = this.boundary != null && this.count - this.pos > this.boundary.length ? this.count - this.pos - (this.boundary.length - 1) : this.count - this.pos;
            } else if (this.boundaryPos == this.pos) {
                left = this.boundary.length;
                this.boundaryPos = -1;
            } else {
                left = this.boundaryPos - this.pos;
            }
            while (left > 0 && n < len) {
                int min = len - n < left ? len - n : left;
                System.arraycopy(this.buf, this.pos, b, offs + n, min);
                this.pos += min;
                left -= min;
                n += min;
            }
        }
        if (n > 0) {
            return n;
        }
        return -1;
    }

    public final String readLine() throws IOException {
        StringBuffer retbuf = new StringBuffer();
        if (this.eof && this.pos >= this.count) {
            return null;
        }
        if (this.boundaryPos == this.pos) {
            this.boundaryPos = -1;
        }
        boolean didRead = false;
        block4: while (!this.eof) {
            if (this.pos >= this.count) {
                this.fill();
                if (this.eof) break;
            }
            int i = this.pos;
            while (i < this.count) {
                switch (this.buf[i]) {
                    case 13: {
                        retbuf.append(new String(this.buf, this.pos, i - this.pos));
                        didRead = true;
                        this.pos = i + 1;
                        if (this.pos >= this.count) {
                            this.fill();
                            i = this.pos;
                            if (this.eof) {
                                break block4;
                            }
                        } else {
                            ++i;
                        }
                        if (this.buf[i] != 10) break block4;
                        this.pos = i + 1;
                        break block4;
                    }
                    case 10: {
                        retbuf.append(new String(this.buf, this.pos, i - this.pos));
                        didRead = true;
                        this.pos = i + 1;
                        break block4;
                    }
                    default: {
                        ++i;
                        break;
                    }
                }
            }
            retbuf.append(new String(this.buf, this.pos, this.count - this.pos));
            didRead = true;
            this.fill();
            if (!this.eof) continue;
            break;
        }
        return this.eof && !didRead ? null : retbuf.toString();
    }
}

