/*
 * Decompiled with CFR 0.152.
 */
package webshadow.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;

public class InterruptableInputStream
extends InputStream {
    boolean wasClosed = false;
    Socket sock;
    InputStream in;

    public InterruptableInputStream(Socket sock) throws IOException {
        this.sock = sock;
        sock.setSoTimeout(1000);
        this.in = sock.getInputStream();
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        if (this.read(b) > 0) {
            return b[0];
        }
        return -1;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b, int offs, int len) throws IOException {
        int n = 0;
        while (n < len) {
            try {
                Socket socket = this.sock;
                synchronized (socket) {
                    if (this.wasClosed || this.sock.isInputShutdown()) {
                        this.wasClosed = true;
                        if (n > 0) {
                            return n;
                        }
                        return -1;
                    }
                    int res = this.in.read(b, offs + n, len - n);
                    if (res > 0) {
                        n += res;
                    } else {
                        this.wasClosed = true;
                    }
                    if (n > 0) {
                        return n;
                    }
                    return -1;
                }
            }
            catch (SocketTimeoutException ste) {
                if (ste.bytesTransferred <= 0) continue;
                n += ste.bytesTransferred;
            }
            catch (IOException ioe) {
            }
        }
        return n;
    }

    public void close() throws IOException {
        this.wasClosed = true;
        this.in.close();
    }
}

