/*
 * Decompiled with CFR 0.152.
 */
package webshadow.ui.hex;

import java.util.ArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import webshadow.ui.hex.HexData;

public class HexTableModel
implements TableModel {
    protected static final String HEX = "0123456789ABCDEF";
    protected ArrayList listeners = new ArrayList();
    protected String[] names = new String[]{"Address", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F", "Text"};
    protected HexData data;

    public void setHexData(HexData data) {
        this.data = data;
        this.fireTableDataChanged();
    }

    public HexTableModel(HexData data) {
        this.setHexData(data);
    }

    public HexTableModel() {
        this.data = null;
    }

    protected String byteToHex(int val) {
        int hi = (val & 0xF0) >> 4;
        int lo = val & 0xF;
        return "" + HEX.charAt(hi) + HEX.charAt(lo);
    }

    protected String intToHex(int val) {
        int hi = (val & 0xFF00) >> 8;
        int lo = val & 0xFF;
        return this.byteToHex(hi) + this.byteToHex(lo);
    }

    public Class getColumnClass(int index) {
        return String.class;
    }

    public String getColumnName(int col) {
        return this.names[col];
    }

    public int getColumnCount() {
        return this.names.length;
    }

    public int getRowCount() {
        if (this.data != null) {
            return this.data.getRowCount();
        }
        return 0;
    }

    public boolean isCellEditable(int row, int col) {
        if (this.data == null) {
            return false;
        }
        if (row == this.getRowCount() - 1 && col >= this.data.getLastRowSize()) {
            return false;
        }
        int max = this.getColumnCount() - 1;
        return col != 0 && col != max;
    }

    public Object getValueAt(int row, int col) {
        if (this.data == null) {
            return null;
        }
        int max = this.getColumnCount() - 1;
        if (col == 0) {
            return this.intToHex(row * 16) + ":";
        }
        if (col == max) {
            return this.data.getRow(row);
        }
        if (row == this.data.getRowCount() - 1 && col >= this.data.getLastRowSize()) {
            return "";
        }
        return this.byteToHex(this.data.getByte(row, col - 1));
    }

    public void setValueAt(Object value, int row, int col) {
        if (this.data == null) {
            return;
        }
        String hex = value.toString();
        this.data.setByte(row, col - 1, (byte)Integer.parseInt(hex, 16));
        int max = this.getColumnCount() - 1;
        this.fireModelChangeEvent(row, col - 1);
        this.fireModelChangeEvent(row, max);
    }

    protected void fireModelChangeEvent(int row, int col) {
        ArrayList list = (ArrayList)this.listeners.clone();
        TableModelEvent event = new TableModelEvent(this, row, row, col);
        for (int i = 0; i < list.size(); ++i) {
            TableModelListener listener = (TableModelListener)list.get(i);
            listener.tableChanged(event);
        }
    }

    protected void fireTableDataChanged() {
        ArrayList list = (ArrayList)this.listeners.clone();
        TableModelEvent event = new TableModelEvent(this);
        for (int i = 0; i < list.size(); ++i) {
            TableModelListener listener = (TableModelListener)list.get(i);
            listener.tableChanged(event);
        }
    }

    public void addTableModelListener(TableModelListener listener) {
        this.listeners.add(listener);
    }

    public void removeTableModelListener(TableModelListener listener) {
        this.listeners.remove(listener);
    }
}

