/*
 * Decompiled with CFR 0.152.
 */
package webshadow.ui.hex;

import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import webshadow.ui.hex.HexTableCellEditor;
import webshadow.ui.hex.HexTableCellRenderer;
import webshadow.ui.hex.HexTableModel;

public class HexTable
extends JTable {
    public HexTable(HexTableModel model) {
        super(model);
        this.setDefaultRenderer(String.class, new HexTableCellRenderer());
        this.setDefaultEditor(String.class, new HexTableCellEditor());
        int count = model.getColumnCount();
        for (int i = 0; i < count; ++i) {
            int w = 27;
            if (i == 0) {
                w = 60;
            }
            if (i == count - 1) {
                w = 150;
            }
            String name = this.getColumnName(i);
            TableColumn column = this.getColumn(name);
            column.setWidth(w);
            column.setMinWidth(w);
            column.setPreferredWidth(w);
        }
        this.setShowGrid(false);
        this.setRowSelectionAllowed(false);
        this.setAutoResizeMode(0);
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setResizingAllowed(false);
        this.setFont(new Font("monospaced", 0, 12));
        this.setIntercellSpacing(new Dimension(4, 0));
    }

    public void setModel(TableModel model) {
        if (!(model instanceof HexTableModel)) {
            throw new IllegalArgumentException("HexTable expects to use a HexTableModel");
        }
        super.setModel(model);
    }
}

