/*
 * Decompiled with CFR 0.152.
 */
package webshadow.ui.hex;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import webshadow.ui.hex.HexData;

public class HexFile
extends RandomAccessFile
implements HexData {
    public static final int ROW_SIZE = 16;
    protected int size = (int)this.length();

    public HexFile(String filename) throws IOException {
        this(new File(filename));
    }

    public HexFile(File file) throws IOException {
        super(file, "rw");
    }

    public int getRowCount() {
        int rows = this.size / 16;
        if (rows * 16 < this.size) {
            ++rows;
        }
        return rows;
    }

    public int getColumnCount() {
        return 16;
    }

    public int getLastRowSize() {
        int max = (this.getRowCount() - 1) * 16;
        if (this.size - max == 0) {
            return 16;
        }
        return this.size - max;
    }

    public byte getByte(int row, int col) {
        try {
            this.seek(row * 16 + col);
            return (byte)this.read();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void setByte(int row, int col, byte value) {
        try {
            this.seek(row * 16 + col);
            this.write(value);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getRow(int row) {
        int rowSize = 16;
        if (row == this.getRowCount() - 1) {
            rowSize = this.getLastRowSize();
        }
        byte[] data = new byte[rowSize];
        try {
            this.seek(row * 16);
            this.read(data);
            return new String(data);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new String(data);
        }
    }
}

