/*
 * Decompiled with CFR 0.152.
 */
package webshadow.ui.hex;

import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import webshadow.ui.hex.HexData;

public class ByteArrayHexData
implements HexData {
    public static final int ROW_SIZE = 16;
    private byte[] data;
    private ArrayList listeners = new ArrayList();

    public ByteArrayHexData(byte[] data) {
        this.data = data;
    }

    public byte getByte(int row, int col) {
        if (this.data == null) {
            return 0;
        }
        int idx = row * 16 + col;
        if (idx > this.data.length) {
            return 0;
        }
        return this.data[idx];
    }

    public int getColumnCount() {
        return 16;
    }

    public int getLastRowSize() {
        int lastRow = this.data.length % 16;
        return lastRow == 0 ? 16 : lastRow;
    }

    public String getRow(int row) {
        if (this.data == null) {
            return null;
        }
        if (row * 16 >= this.data.length) {
            return null;
        }
        if (row * 16 + 16 - 1 >= this.data.length) {
            return new String(this.data, row * 16, this.data.length % 16);
        }
        return new String(this.data, row * 16, 16);
    }

    public int getRowCount() {
        return (this.data.length + 16 - 1) / 16;
    }

    public void setByte(int row, int col, byte value) {
        if (this.data == null) {
            return;
        }
        int idx = row * 16 + col;
        if (idx > this.data.length) {
            return;
        }
        this.data[idx] = value;
        this.fireActionPerformed();
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    protected void fireActionPerformed() {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ActionListener al = (ActionListener)it.next();
            al.actionPerformed(null);
        }
    }
}

