/*
 * Decompiled with CFR 0.152.
 */
package webshadow.ui;

import java.io.File;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;

public class SpoxyPrefs {
    static final String PREFERENCE_PATH = "/watchfire/httpproxy";
    public static final int PREF_NUMTHREADS = 0;
    public static final int PREF_HTTPPROXY = 1;
    public static final int PREF_SOCKSPROXY = 2;
    public static final int PREF_LOGDIR = 3;
    public static final int PREF_TEMPLATEDIR = 4;
    public static final int PREF_REVERSEDNS = 5;
    public static final int PREF_JSALERTS = 6;
    static final String tmpdir = System.getProperty("java.io.tmpdir", "c:\\temp");
    static final String userHome = System.getProperty("user.home", tmpdir);
    static PrefDesc[] prefDescs = new PrefDesc[]{new PrefDesc("Number of Threads", Integer.TYPE, "20"), new PrefDesc("HTTP Proxy Port", Integer.TYPE, "8080"), new PrefDesc("SOCKS Proxy Port", Integer.TYPE, "1080"), new PrefDesc("Logging Directory", File.class, userHome + File.separator + "Watchfire" + File.separator + "HttpProxy" + File.separator + "logdir"), new PrefDesc("Template Directory", File.class, userHome + File.separator + "Watchfire" + File.separator + "HttpProxy" + File.separator + "templates"), new PrefDesc("Reverse DNS", Boolean.TYPE, "false"), new PrefDesc("Show Javascript Errors", Boolean.TYPE, "true")};

    public static Preferences getPrefs() {
        return Preferences.userRoot().node(PREFERENCE_PATH);
    }

    public static int getNumPrefs() {
        return prefDescs.length;
    }

    public static String getPrefName(int prefNum) {
        if (prefNum >= prefDescs.length) {
            return null;
        }
        return SpoxyPrefs.prefDescs[prefNum].name;
    }

    public static int getPrefIndex(String prefName) {
        for (int i = 0; i < prefDescs.length; ++i) {
            if (!SpoxyPrefs.prefDescs[i].name.equals(prefName)) continue;
            return i;
        }
        return -1;
    }

    public static int getInt(int prefNum) {
        if (prefNum >= prefDescs.length) {
            return 0;
        }
        PrefDesc desc = prefDescs[prefNum];
        int defValue = 0;
        try {
            defValue = Integer.parseInt(desc.defaultValue);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return SpoxyPrefs.getPrefs().getInt(desc.name, defValue);
    }

    public static void putInt(int prefNum, int value) {
        if (prefNum >= prefDescs.length) {
            return;
        }
        PrefDesc desc = prefDescs[prefNum];
        SpoxyPrefs.getPrefs().putInt(desc.name, value);
    }

    public static boolean getBoolean(int prefNum) {
        if (prefNum >= prefDescs.length) {
            return false;
        }
        PrefDesc desc = prefDescs[prefNum];
        boolean defValue = desc.defaultValue.equals("true");
        return SpoxyPrefs.getPrefs().getBoolean(desc.name, defValue);
    }

    public static void putBoolean(int prefNum, boolean value) {
        if (prefNum >= prefDescs.length) {
            return;
        }
        PrefDesc desc = prefDescs[prefNum];
        SpoxyPrefs.getPrefs().putBoolean(desc.name, value);
    }

    public static File getFile(int prefNum) {
        if (prefNum >= prefDescs.length) {
            return null;
        }
        PrefDesc desc = prefDescs[prefNum];
        return new File(SpoxyPrefs.getPrefs().get(desc.name, desc.defaultValue));
    }

    public static void putFile(int prefNum, File value) {
        if (prefNum >= prefDescs.length) {
            return;
        }
        PrefDesc desc = prefDescs[prefNum];
        SpoxyPrefs.getPrefs().put(desc.name, value.getAbsolutePath());
    }

    public static String getString(int prefNum) {
        if (prefNum >= prefDescs.length) {
            return null;
        }
        PrefDesc desc = prefDescs[prefNum];
        return SpoxyPrefs.getPrefs().get(desc.name, desc.defaultValue);
    }

    public static void putString(int prefNum, String value) {
        if (prefNum >= prefDescs.length) {
            return;
        }
        PrefDesc desc = prefDescs[prefNum];
        SpoxyPrefs.getPrefs().put(desc.name, value);
    }

    public static Object get(int prefNum) {
        if (prefNum >= prefDescs.length) {
            return null;
        }
        PrefDesc desc = prefDescs[prefNum];
        if (desc.type == Integer.TYPE) {
            return new Integer(SpoxyPrefs.getInt(prefNum));
        }
        if (desc.type == Boolean.TYPE) {
            return new Boolean(SpoxyPrefs.getBoolean(prefNum));
        }
        if (desc.type == File.class) {
            return SpoxyPrefs.getFile(prefNum);
        }
        return SpoxyPrefs.getString(prefNum);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean put(int prefNum, Object value) {
        if (prefNum >= prefDescs.length) {
            return false;
        }
        PrefDesc desc = prefDescs[prefNum];
        if (desc.type == Integer.TYPE) {
            int val;
            if (value instanceof Integer) {
                val = (Integer)value;
            } else {
                if (!(value instanceof String)) return false;
                try {
                    val = Integer.parseInt((String)value);
                }
                catch (NumberFormatException nfe) {
                    return false;
                }
            }
            SpoxyPrefs.putInt(prefNum, val);
            return true;
        }
        if (desc.type == Boolean.TYPE) {
            boolean val;
            if (value instanceof Boolean) {
                val = (Boolean)value;
            } else {
                if (!(value instanceof String)) return false;
                val = ((String)value).equals("true");
            }
            SpoxyPrefs.putBoolean(prefNum, val);
            return true;
        } else {
            if (desc.type != File.class) return false;
            if (value instanceof File) {
                SpoxyPrefs.putFile(prefNum, (File)value);
                return true;
            } else {
                if (!(value instanceof String)) return false;
                SpoxyPrefs.putString(prefNum, (String)value);
            }
        }
        return true;
    }

    public static void addPreferenceChangeListener(PreferenceChangeListener pcl) {
        SpoxyPrefs.getPrefs().addPreferenceChangeListener(pcl);
    }

    static class PrefDesc {
        String name;
        Class type;
        String defaultValue;

        PrefDesc(String name, Class type, String defaultValue) {
            this.name = name;
            this.type = type;
            this.defaultValue = defaultValue;
        }
    }
}

