/*
 * Decompiled with CFR 0.152.
 */
package webshadow.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import webshadow.ui.FileChooserEditor;
import webshadow.ui.SpoxyPrefs;
import webshadow.ui.UIUtils;

public class PreferenceEditor
extends JDialog {
    private JPanel jPanel2;
    private JButton jButton1;
    private JScrollPane jScrollPane1;
    private JTable jPrefTable;
    private PreferenceTableModel prefTableModel = new PreferenceTableModel();

    public PreferenceEditor(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setupFileChooserEditor();
        UIUtils.locateOnScreenCenter(this);
    }

    private void setupFileChooserEditor() {
        JButton button = new JButton("");
        button.setBackground(Color.white);
        button.setBorderPainted(false);
        button.setMargin(new Insets(0, 0, 0, 0));
        final FileChooserEditor fileChooserEditor = new FileChooserEditor(button);
        this.jPrefTable.getColumnModel().getColumn(1).setCellEditor(fileChooserEditor);
        final JFileChooser fileChooser = new JFileChooser(SpoxyPrefs.getString(3));
        fileChooser.setFileSelectionMode(1);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int returnVal;
                int selRow = PreferenceEditor.this.jPrefTable.getSelectedRow();
                if (selRow >= 0) {
                    File lastFile = SpoxyPrefs.getFile(selRow);
                    fileChooser.setSelectedFile(lastFile);
                }
                if ((returnVal = fileChooser.showOpenDialog(PreferenceEditor.this.jPrefTable)) == 0) {
                    fileChooserEditor.currentFile = fileChooser.getSelectedFile();
                }
            }
        });
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jButton1 = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jPrefTable = new JTable();
        this.setTitle("Preferences");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PreferenceEditor.this.closeDialog(evt);
            }
        });
        this.jButton1.setText("OK");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PreferenceEditor.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.jButton1);
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.jPrefTable.setModel(this.prefTableModel);
        this.jScrollPane1.setViewportView(this.jPrefTable);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        new PreferenceEditor((Frame)new JFrame(), true).show();
    }

    class PreferenceTableModel
    extends AbstractTableModel
    implements PreferenceChangeListener {
        PreferenceTableModel() {
            SpoxyPrefs.getPrefs().addPreferenceChangeListener(this);
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "Key";
                }
                case 1: {
                    return "Value";
                }
            }
            return null;
        }

        public boolean isCellEditable(int row, int col) {
            return row < SpoxyPrefs.getNumPrefs() && col == 1;
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return SpoxyPrefs.getNumPrefs();
        }

        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return SpoxyPrefs.getPrefName(row);
            }
            return SpoxyPrefs.get(row);
        }

        public void setValueAt(Object newVal, int row, int col) {
            if (col != 1) {
                return;
            }
            if (!SpoxyPrefs.put(row, newVal)) {
                PreferenceEditor.this.getToolkit().beep();
            }
        }

        public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
            String key = preferenceChangeEvent.getKey();
            int prefNum = SpoxyPrefs.getPrefIndex(key);
            if (prefNum >= 0) {
                this.fireTableCellUpdated(prefNum, 1);
            }
        }
    }
}

