/*
 * Decompiled with CFR 0.152.
 */
package webshadow.ui;

import com.jgoodies.forms.factories.DefaultComponentFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import webshadow.http.HttpRequest;
import webshadow.http.ParsedHeaders;
import webshadow.http.RequestParsedHeaders;
import webshadow.ui.GUIOps;
import webshadow.ui.MessageModel;

public class ParsedRequestPanel
extends JPanel
implements MessageModel {
    static final String[] paramTypes = new String[]{"Query", "Body"};
    boolean needParamCompose = false;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JTable jCookieTable;
    private JButton jDeleteParam;
    private JRadioButton jGetReq;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JComboBox jParamContentType;
    private JTextField jParamFilename;
    private JSplitPane jParamSplit;
    private JTable jParamTable;
    private JTextArea jParamValue;
    private JTextField jPathField;
    private JRadioButton jPostMultipart;
    private JRadioButton jPostUrlEncoded;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JButton jSetNullValue;
    private JSplitPane jSplitPane1;
    private ButtonGroup reqTypeGroup;
    private boolean ignoreFirstValueEdit;
    private boolean ignoreFirstContentTypeEdit;
    private boolean ignoreFirstFilenameEdit;
    private HttpRequest req;
    private ArrayList params;
    private HttpRequest.Param selectedParam;
    private RequestParsedHeaders headers;
    private CookieTableModel cookieTableModel;
    private ParamTableModel paramTableModel;

    public ParsedRequestPanel() {
        JComboBox<String> paramTypeEditor = new JComboBox<String>(paramTypes);
        paramTypeEditor.setEditable(false);
        this.cookieTableModel = new CookieTableModel();
        this.paramTableModel = new ParamTableModel();
        this.initComponents();
        this.jPathField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                ParsedRequestPanel.this.needParamCompose = true;
            }

            public void insertUpdate(DocumentEvent e) {
                ParsedRequestPanel.this.needParamCompose = true;
            }

            public void removeUpdate(DocumentEvent e) {
                ParsedRequestPanel.this.needParamCompose = true;
            }
        });
        this.jButton2.setEnabled(false);
        this.jCookieTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ParsedRequestPanel.this.jButton2.setEnabled(ParsedRequestPanel.this.jCookieTable.getSelectedRowCount() > 0);
            }
        });
        this.jDeleteParam.setEnabled(false);
        this.jParamTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ParsedRequestPanel.this.jDeleteParam.setEnabled(ParsedRequestPanel.this.jParamTable.getSelectedRowCount() > 0);
            }
        });
        this.jParamTable.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(paramTypeEditor));
        this.jParamTable.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component cell;
                if (column == 1) {
                    String msg;
                    Color color = Color.black;
                    if (value == null) {
                        value = "NULL";
                        color = Color.red;
                    } else if (value instanceof String && (msg = (String)value).indexOf(10) >= 0) {
                        value = "BIG";
                        color = Color.red;
                    }
                    cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    cell.setForeground(color);
                } else {
                    cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                }
                return cell;
            }
        });
        ListSelectionModel rowSM = this.jParamTable.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ParsedRequestPanel.this.paramTableDisplayUpdate();
            }
        });
        this.jParamValue.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                this.valueChanged();
            }

            public void insertUpdate(DocumentEvent e) {
                this.valueChanged();
            }

            public void removeUpdate(DocumentEvent e) {
                this.valueChanged();
            }

            private void valueChanged() {
                if (ParsedRequestPanel.this.selectedParam == null) {
                    return;
                }
                if (ParsedRequestPanel.this.ignoreFirstValueEdit) {
                    ParsedRequestPanel.this.ignoreFirstValueEdit = false;
                    return;
                }
                ((ParsedRequestPanel)ParsedRequestPanel.this).selectedParam.hasValue = true;
                ((ParsedRequestPanel)ParsedRequestPanel.this).selectedParam.value = ParsedRequestPanel.this.jParamValue.getText().getBytes();
                ParsedRequestPanel.this.needParamCompose = true;
                ParsedRequestPanel.this.paramTableModel.fireTableCellUpdated(ParsedRequestPanel.this.jParamTable.getSelectedRow(), 1);
            }
        });
        this.jParamContentType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ParsedRequestPanel.this.selectedParam == null) {
                    return;
                }
                if (ParsedRequestPanel.this.ignoreFirstContentTypeEdit) {
                    ParsedRequestPanel.this.ignoreFirstContentTypeEdit = false;
                    return;
                }
                ParsedRequestPanel.this.needParamCompose = true;
                ((ParsedRequestPanel)ParsedRequestPanel.this).selectedParam.contentType = (String)ParsedRequestPanel.this.jParamContentType.getSelectedItem();
            }
        });
        this.jParamFilename.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                this.valueChanged();
            }

            public void insertUpdate(DocumentEvent e) {
                this.valueChanged();
            }

            public void removeUpdate(DocumentEvent e) {
                this.valueChanged();
            }

            private void valueChanged() {
                if (ParsedRequestPanel.this.selectedParam == null) {
                    return;
                }
                if (ParsedRequestPanel.this.ignoreFirstFilenameEdit) {
                    ParsedRequestPanel.this.ignoreFirstFilenameEdit = false;
                    return;
                }
                ParsedRequestPanel.this.needParamCompose = true;
                ((ParsedRequestPanel)ParsedRequestPanel.this).selectedParam.fileName = ParsedRequestPanel.this.jParamFilename.getText();
                if (((ParsedRequestPanel)ParsedRequestPanel.this).selectedParam.fileName.length() == 0) {
                    ((ParsedRequestPanel)ParsedRequestPanel.this).selectedParam.fileName = null;
                }
            }
        });
        this.setRequest(null);
    }

    public synchronized void setRequest(HttpRequest req) {
        this.needParamCompose = false;
        this.req = req;
        GUIOps.put(new GUIOps.Operator(){

            public void fireEvent() {
                ParsedRequestPanel.this.jGetReq.setSelected(false);
                ParsedRequestPanel.this.jPostMultipart.setSelected(false);
                ParsedRequestPanel.this.jPostUrlEncoded.setSelected(false);
            }
        });
        if (req == null) {
            this.headers = null;
            this.params = null;
            this.selectedParam = null;
            GUIOps.put(new GUIOps.Operator(){

                public void fireEvent() {
                    ParsedRequestPanel.this.jPathField.setText("");
                    ParsedRequestPanel.this.jPathField.setEnabled(false);
                }
            });
        } else {
            this.headers = req.getReqHeaders();
            this.params = req.parseParams();
            final String path = this.headers.getPath();
            GUIOps.put(new GUIOps.Operator(){

                public void fireEvent() {
                    ParsedRequestPanel.this.jPathField.setText(path);
                    ParsedRequestPanel.this.jPathField.setEnabled(true);
                }
            });
            if (this.headers.method.equals("GET")) {
                GUIOps.put(new GUIOps.Operator(){

                    public void fireEvent() {
                        ParsedRequestPanel.this.jGetReq.setSelected(true);
                    }
                });
            } else if (this.headers.method.equals("POST")) {
                final String ctype = this.headers.getHeaderValue("Content-Type");
                GUIOps.put(new GUIOps.Operator(){

                    public void fireEvent() {
                        if (ctype != null && ctype.startsWith("multipart")) {
                            ParsedRequestPanel.this.jPostMultipart.setSelected(true);
                        } else {
                            ParsedRequestPanel.this.jPostUrlEncoded.setSelected(true);
                        }
                    }
                });
            }
        }
        this.cookieTableModel.fireTableDataChanged();
        this.paramTableModel.fireTableDataChanged();
        this.showParam();
    }

    public HttpRequest getRequest() {
        return this.req;
    }

    public void updateModelFromMessage() {
        this.setRequest(this.req);
    }

    public synchronized void updateMessageFromModel() {
        if (this.req == null) {
            return;
        }
        if (this.needParamCompose) {
            this.headers.setPath(this.jPathField.getText());
            this.req.composeParams(this.params);
        }
        this.req.composeHeaders();
        this.needParamCompose = false;
    }

    private synchronized void showParam() {
        this.ignoreFirstValueEdit = true;
        this.ignoreFirstContentTypeEdit = true;
        this.ignoreFirstFilenameEdit = true;
        final HttpRequest.Param selectedParam = this.selectedParam;
        GUIOps.put(new GUIOps.Operator(){

            public void fireEvent() {
                if (selectedParam == null) {
                    ParsedRequestPanel.this.jParamValue.setText("");
                    ParsedRequestPanel.this.jParamValue.setEnabled(false);
                    ParsedRequestPanel.this.jLabel6.setEnabled(false);
                    ParsedRequestPanel.this.jParamContentType.setSelectedItem("");
                    ParsedRequestPanel.this.jParamContentType.setEnabled(false);
                    ParsedRequestPanel.this.jLabel4.setEnabled(false);
                    ParsedRequestPanel.this.jParamFilename.setText("");
                    ParsedRequestPanel.this.jParamFilename.setEnabled(false);
                    ParsedRequestPanel.this.jLabel5.setEnabled(false);
                    ParsedRequestPanel.this.jSetNullValue.setEnabled(false);
                } else {
                    ParsedRequestPanel.this.jParamContentType.setSelectedItem(selectedParam.contentType);
                    ParsedRequestPanel.this.jParamContentType.setEnabled(true);
                    ParsedRequestPanel.this.jLabel4.setEnabled(true);
                    if (selectedParam.fileName != null) {
                        ParsedRequestPanel.this.jParamFilename.setText(selectedParam.fileName);
                    } else {
                        ParsedRequestPanel.this.jParamFilename.setText("");
                    }
                    ParsedRequestPanel.this.jParamFilename.setEnabled(true);
                    ParsedRequestPanel.this.jLabel5.setEnabled(true);
                    if (selectedParam.hasValue) {
                        ParsedRequestPanel.this.jSetNullValue.setEnabled(true);
                    } else {
                        ParsedRequestPanel.this.jSetNullValue.setEnabled(false);
                    }
                    if (selectedParam.value != null) {
                        ParsedRequestPanel.this.jParamValue.setText(new String(selectedParam.value));
                    } else {
                        ParsedRequestPanel.this.jParamValue.setText("");
                    }
                    ParsedRequestPanel.this.jParamValue.setEnabled(true);
                    ParsedRequestPanel.this.jLabel6.setEnabled(true);
                }
            }
        });
    }

    private synchronized void paramTableDisplayUpdate() {
        if (this.params == null) {
            return;
        }
        ListSelectionModel lsm = this.jParamTable.getSelectionModel();
        if (lsm.isSelectionEmpty() && this.params.size() == 0) {
            this.selectedParam = null;
        } else {
            int idx;
            if (lsm.isSelectionEmpty()) {
                lsm.setSelectionInterval(0, 0);
            }
            this.selectedParam = (idx = lsm.getLeadSelectionIndex()) >= this.params.size() || idx < 0 ? null : (HttpRequest.Param)this.params.get(idx);
        }
        this.showParam();
    }

    private void initComponents() {
        this.reqTypeGroup = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jPanel6 = (JPanel)DefaultComponentFactory.getInstance().createSeparator("General");
        this.jGetReq = new JRadioButton();
        this.jPostUrlEncoded = new JRadioButton();
        this.jPostMultipart = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.jPathField = new JTextField();
        this.jLabel2 = new JLabel();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel4 = new JPanel();
        this.jPanel7 = (JPanel)DefaultComponentFactory.getInstance().createSeparator("Cookies");
        this.jScrollPane1 = new JScrollPane();
        this.jCookieTable = new JTable();
        this.jPanel9 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jPanel5 = new JPanel();
        this.jPanel8 = (JPanel)DefaultComponentFactory.getInstance().createSeparator("Parameters");
        this.jParamSplit = new JSplitPane();
        this.jPanel10 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jParamTable = new JTable();
        this.jPanel11 = new JPanel();
        this.jButton3 = new JButton();
        this.jDeleteParam = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jParamContentType = new JComboBox();
        this.jLabel5 = new JLabel();
        this.jParamFilename = new JTextField();
        this.jLabel6 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.jParamValue = new JTextArea();
        this.jPanel3 = new JPanel();
        this.jSetNullValue = new JButton();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(new EmptyBorder(new Insets(8, 8, 8, 8)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel1.add((Component)this.jPanel6, gridBagConstraints);
        this.reqTypeGroup.add(this.jGetReq);
        this.jGetReq.setText("GET");
        this.jGetReq.setToolTipText("GET method and no body");
        this.jGetReq.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParsedRequestPanel.this.jGetReqActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 0, 2);
        this.jPanel1.add((Component)this.jGetReq, gridBagConstraints);
        this.reqTypeGroup.add(this.jPostUrlEncoded);
        this.jPostUrlEncoded.setText("POST urlencoded");
        this.jPostUrlEncoded.setToolTipText("POST method, body params are www-form-urlencoded");
        this.jPostUrlEncoded.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParsedRequestPanel.this.jPostUrlEncodedActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 0, 2);
        this.jPanel1.add((Component)this.jPostUrlEncoded, gridBagConstraints);
        this.reqTypeGroup.add(this.jPostMultipart);
        this.jPostMultipart.setText("POST multipart/form-data");
        this.jPostMultipart.setToolTipText("POST method, body params are multipart/form-data");
        this.jPostMultipart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParsedRequestPanel.this.jPostMultipartActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel1.add((Component)this.jPostMultipart, gridBagConstraints);
        this.jLabel1.setText("Path:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 2);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 3.0;
        gridBagConstraints.insets = new Insets(0, 2, 2, 0);
        this.jPanel1.add((Component)this.jPathField, gridBagConstraints);
        this.jLabel2.setText("Request type:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 2);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.5);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel4.setOpaque(false);
        this.jPanel4.setPreferredSize(new Dimension(37, 52));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 4, 8);
        this.jPanel4.add((Component)this.jPanel7, gridBagConstraints);
        this.jScrollPane1.setBorder(null);
        this.jCookieTable.setModel(this.cookieTableModel);
        this.jScrollPane1.setViewportView(this.jCookieTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 8);
        this.jPanel4.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel9.setLayout(new FlowLayout(2, 8, 8));
        this.jButton1.setText("Add");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParsedRequestPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel9.add(this.jButton1);
        this.jButton2.setText("Remove");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParsedRequestPanel.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel9.add(this.jButton2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel4.add((Component)this.jPanel9, gridBagConstraints);
        this.jSplitPane1.setLeftComponent(this.jPanel4);
        this.jPanel5.setLayout(new GridBagLayout());
        this.jPanel5.setBorder(new EmptyBorder(new Insets(8, 8, 8, 8)));
        this.jPanel5.setPreferredSize(new Dimension(246, 129));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel5.add((Component)this.jPanel8, gridBagConstraints);
        this.jParamSplit.setResizeWeight(0.5);
        this.jPanel10.setLayout(new GridBagLayout());
        this.jParamTable.setModel(this.paramTableModel);
        this.jScrollPane2.setViewportView(this.jParamTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 0, 8);
        this.jPanel10.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jPanel11.setLayout(new FlowLayout(2, 8, 8));
        this.jButton3.setText("Add");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParsedRequestPanel.this.jButton3ActionPerformed(evt);
            }
        });
        this.jPanel11.add(this.jButton3);
        this.jDeleteParam.setText("Remove");
        this.jDeleteParam.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParsedRequestPanel.this.jDeleteParamActionPerformed(evt);
            }
        });
        this.jPanel11.add(this.jDeleteParam);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel10.add((Component)this.jPanel11, gridBagConstraints);
        this.jParamSplit.setLeftComponent(this.jPanel10);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel4.setHorizontalAlignment(2);
        this.jLabel4.setText("Content-Type:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 8, 2, 2);
        this.jPanel2.add((Component)this.jLabel4, gridBagConstraints);
        this.jParamContentType.setEditable(true);
        this.jParamContentType.setModel(new DefaultComboBoxModel<String>(new String[]{"text/plain", "text/html", "text/xml", "application/octet-stream"}));
        this.jParamContentType.setPreferredSize(new Dimension(138, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 2, 2, 8);
        this.jPanel2.add((Component)this.jParamContentType, gridBagConstraints);
        this.jLabel5.setHorizontalAlignment(2);
        this.jLabel5.setText("Filename:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 8, 2, 2);
        this.jPanel2.add((Component)this.jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 8);
        this.jPanel2.add((Component)this.jParamFilename, gridBagConstraints);
        this.jLabel6.setText("Value:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(2, 8, 2, 2);
        this.jPanel2.add((Component)this.jLabel6, gridBagConstraints);
        this.jScrollPane3.setViewportView(this.jParamValue);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 8);
        this.jPanel2.add((Component)this.jScrollPane3, gridBagConstraints);
        this.jPanel3.setLayout(new FlowLayout(2, 8, 8));
        this.jSetNullValue.setText("Set to NULL");
        this.jSetNullValue.setToolTipText("Set the value to null");
        this.jSetNullValue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ParsedRequestPanel.this.jSetNullValueActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.jSetNullValue);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.jPanel2.add((Component)this.jPanel3, gridBagConstraints);
        this.jParamSplit.setRightComponent(this.jPanel2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel5.add((Component)this.jParamSplit, gridBagConstraints);
        this.jSplitPane1.setRightComponent(this.jPanel5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jSplitPane1, gridBagConstraints);
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.paramTableModel.addParam();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        int[] rows = this.jCookieTable.getSelectedRows();
        for (int i = rows.length - 1; i >= 0; --i) {
            this.cookieTableModel.removeCookie(rows[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jDeleteParamActionPerformed(ActionEvent evt) {
        ParsedRequestPanel parsedRequestPanel = this;
        synchronized (parsedRequestPanel) {
            if (this.params == null) {
                return;
            }
            int[] rows = this.jParamTable.getSelectedRows();
            for (int i = rows.length - 1; i >= 0; --i) {
                this.paramTableModel.removeParam(rows[i]);
            }
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.cookieTableModel.addCookie();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jSetNullValueActionPerformed(ActionEvent evt) {
        ParsedRequestPanel parsedRequestPanel = this;
        synchronized (parsedRequestPanel) {
            if (this.selectedParam == null) {
                return;
            }
            this.selectedParam.hasValue = false;
            this.selectedParam.value = null;
            this.needParamCompose = true;
            this.paramTableModel.fireTableCellUpdated(this.jParamTable.getSelectedRow(), 1);
            this.showParam();
        }
    }

    private void jPostMultipartActionPerformed(ActionEvent evt) {
        if (this.req == null) {
            return;
        }
        this.headers.method = "POST";
        if (this.headers.boundary == null) {
            this.headers.boundary = Math.random() + "Boundary" + Math.random();
        }
        this.headers.setHeaderValue("Content-Type", "multipart/form-data; boundary=" + this.headers.boundary);
        this.needParamCompose = true;
    }

    private void jPostUrlEncodedActionPerformed(ActionEvent evt) {
        if (this.req == null) {
            return;
        }
        this.headers.method = "POST";
        this.headers.setHeaderValue("Content-Type", "application/x-www-form-urlencoded");
        this.needParamCompose = true;
    }

    private void jGetReqActionPerformed(ActionEvent evt) {
        if (this.req == null) {
            return;
        }
        this.headers.method = "GET";
        this.headers.setHeaderValue("Content-Type", null);
        this.needParamCompose = true;
    }

    class ParamTableModel
    extends AbstractTableModel {
        final String[] columnNames = new String[]{"Name", "Value", "Location"};

        ParamTableModel() {
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRowCount() {
            ParsedRequestPanel parsedRequestPanel = ParsedRequestPanel.this;
            synchronized (parsedRequestPanel) {
                if (ParsedRequestPanel.this.params == null) {
                    return 0;
                }
                return ParsedRequestPanel.this.params.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getValueAt(int row, int col) {
            ParsedRequestPanel parsedRequestPanel = ParsedRequestPanel.this;
            synchronized (parsedRequestPanel) {
                if (ParsedRequestPanel.this.params == null) {
                    return "";
                }
                if (row >= ParsedRequestPanel.this.params.size()) {
                    return "";
                }
                HttpRequest.Param param = (HttpRequest.Param)ParsedRequestPanel.this.params.get(row);
                switch (col) {
                    case 0: {
                        return param.name;
                    }
                    case 1: {
                        if (param.hasValue) {
                            if (param.value != null) {
                                if (param.value.length > 30) {
                                    return "\n";
                                }
                                return new String(param.value);
                            }
                            return "";
                        }
                        return null;
                    }
                    case 2: {
                        return paramTypes[param.location];
                    }
                }
                return null;
            }
        }

        public boolean isCellEditable(int row, int col) {
            return col < 3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValueAt(Object value, int row, int col) {
            if (!(value instanceof String)) {
                return;
            }
            ParsedRequestPanel parsedRequestPanel = ParsedRequestPanel.this;
            synchronized (parsedRequestPanel) {
                if (ParsedRequestPanel.this.params == null) {
                    return;
                }
                ParsedRequestPanel.this.needParamCompose = true;
                String val = (String)value;
                if (val != null) {
                    val = val.replaceAll("[\\s&]", "");
                }
                HttpRequest.Param param = (HttpRequest.Param)ParsedRequestPanel.this.params.get(row);
                switch (col) {
                    case 0: {
                        param.name = val;
                        break;
                    }
                    case 1: {
                        param.value = val.getBytes();
                        param.hasValue = true;
                        break;
                    }
                    case 2: {
                        for (int i = 0; i < paramTypes.length; ++i) {
                            if (!paramTypes[i].equals(val)) continue;
                            param.location = i;
                        }
                        break;
                    }
                }
                ParsedRequestPanel.this.showParam();
            }
        }

        public void addParam() {
            ParsedRequestPanel.this.params.add(new HttpRequest.Param());
            this.fireTableRowsInserted(ParsedRequestPanel.this.params.size(), ParsedRequestPanel.this.params.size());
        }

        public void removeParam(int row) {
            if (row < 0 || row >= ParsedRequestPanel.this.params.size()) {
                return;
            }
            ParsedRequestPanel.this.needParamCompose = true;
            ParsedRequestPanel.this.params.remove(row);
            ParsedRequestPanel.this.paramTableModel.fireTableRowsDeleted(row, row);
        }
    }

    class CookieTableModel
    extends AbstractTableModel {
        final String[] columnNames = new String[]{"Name", "Value"};

        CookieTableModel() {
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            if (ParsedRequestPanel.this.headers == null) {
                return 0;
            }
            return ((ParsedRequestPanel)ParsedRequestPanel.this).headers.cookies.size();
        }

        public Object getValueAt(int row, int col) {
            if (ParsedRequestPanel.this.headers == null) {
                return null;
            }
            if (row >= ((ParsedRequestPanel)ParsedRequestPanel.this).headers.cookies.size()) {
                return "";
            }
            ParsedHeaders.NameValue cookie = (ParsedHeaders.NameValue)((ParsedRequestPanel)ParsedRequestPanel.this).headers.cookies.get(row);
            if (col == 0) {
                return cookie.name;
            }
            return cookie.value;
        }

        public boolean isCellEditable(int row, int col) {
            return true;
        }

        public void setValueAt(Object value, int row, int col) {
            if (!(value instanceof String)) {
                return;
            }
            if (ParsedRequestPanel.this.headers == null) {
                return;
            }
            String strVal = (String)value;
            if (strVal != null) {
                strVal = strVal.replaceAll("[\\s,;]", "");
            }
            ParsedHeaders.NameValue cookie = (ParsedHeaders.NameValue)((ParsedRequestPanel)ParsedRequestPanel.this).headers.cookies.get(row);
            if (col == 0) {
                cookie.name = strVal;
            } else {
                cookie.value = strVal;
            }
            ParsedRequestPanel.this.headers.composeCookies();
            this.fireTableCellUpdated(row, col);
        }

        public void addCookie() {
            ParsedHeaders.NameValue cookie = new ParsedHeaders.NameValue("", "");
            ((ParsedRequestPanel)ParsedRequestPanel.this).headers.cookies.add(cookie);
            this.fireTableRowsInserted(((ParsedRequestPanel)ParsedRequestPanel.this).headers.cookies.size(), ((ParsedRequestPanel)ParsedRequestPanel.this).headers.cookies.size());
        }

        public void removeCookie(int row) {
            ((ParsedRequestPanel)ParsedRequestPanel.this).headers.cookies.remove(row);
            this.fireTableRowsDeleted(row, row);
        }
    }
}

