/*
 * Decompiled with CFR 0.152.
 */
package webshadow.ui;

import java.awt.Toolkit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;
import webshadow.comm.Connection;
import webshadow.comm.ConnectionObserverAdapter;
import webshadow.comm.HostPort;
import webshadow.comm.Message;
import webshadow.comm.MessageObserver;
import webshadow.http.HttpMessage;
import webshadow.http.HttpRequest;
import webshadow.http.HttpResponse;
import webshadow.http.RequestParsedHeaders;
import webshadow.ui.AutomationRule;
import webshadow.ui.ConIcons;
import webshadow.ui.GUIOps;
import webshadow.util.Module;

public class MsgInterceptor
extends AbstractTableModel
implements Module {
    static Pattern nonInterestingActionPattern;
    static AutomationRule fullyAutomatic;
    static AutomationRule fullyManual;
    static AutomationRule smartAutomation;
    ArrayList msgs = new ArrayList();
    MessageObserver reqReader;
    MessageObserver resReader;
    Module reqWriter;
    Module resWriter;
    Module reqConnector;
    boolean useCustom = true;
    AutomationRule defaultRule = smartAutomation;
    AutomationRule customRule;

    public void setUseCustom(boolean useCustom) {
        this.useCustom = useCustom;
    }

    public void setDefaultRule(int rule) {
        switch (rule) {
            case 0: {
                this.defaultRule = smartAutomation;
                break;
            }
            case 1: {
                this.defaultRule = fullyAutomatic;
                break;
            }
            case 2: {
                this.defaultRule = fullyManual;
            }
        }
    }

    public void setCustomRule(AutomationRule rule) {
        this.customRule = rule;
    }

    public synchronized void setMessageHandlers(Module reqWriter, Module resWriter, Module reqConnector, MessageObserver reqReader, MessageObserver resReader) {
        this.reqWriter = reqWriter;
        this.resWriter = resWriter;
        this.reqConnector = reqConnector;
        this.reqReader = reqReader;
        this.resReader = resReader;
    }

    void setDefaultValues(HttpMessage msg) {
        if (msg == null) {
            return;
        }
        Message.Info dst = msg.getDstInfo();
        Message.Info src = msg.getSrcInfo();
        dst.setLast(src.isLast());
        dst.setSSL(src.isSSL());
    }

    synchronized void reqStatusChanged(PendingMessage msg) {
        final int idx = this.msgs.indexOf(msg);
        if (idx >= 0) {
            GUIOps.put(new GUIOps.Operator(){

                public void fireEvent() {
                    MsgInterceptor.this.fireTableRowsUpdated(idx, idx);
                }
            });
        }
    }

    synchronized void resStatusChanged(PendingMessage msg) {
        final int idx = this.msgs.indexOf(msg);
        if (idx >= 0) {
            GUIOps.put(new GUIOps.Operator(){

                public void fireEvent() {
                    MsgInterceptor.this.fireTableRowsUpdated(idx, idx);
                }
            });
        }
    }

    public synchronized int checkRules(Message msg, boolean wasHeld) {
        int action = 0;
        if (this.useCustom && this.customRule != null) {
            action = this.customRule.handleMessage(msg, wasHeld);
        }
        if (action == 0) {
            action = this.defaultRule.handleMessage(msg, wasHeld);
        }
        return action;
    }

    synchronized void addMsg(Object msgObj) {
        HttpMessage msg = (HttpMessage)msgObj;
        this.setDefaultValues(msg);
        msg.hold();
        if (msg instanceof HttpRequest) {
            boolean isLocalRequest;
            HttpRequest req = (HttpRequest)msg;
            Connection con = req.getSrcInfo().getCon();
            boolean bl = isLocalRequest = con != null && con.getPeerAddress() == null;
            if (!isLocalRequest) {
                if (msg.hasMoreBody()) {
                    msg.addObserver(this.reqReader);
                } else {
                    this.reqReader.messageReadDone(msg);
                }
            }
            this.reqWriter.put(req);
            final PendingMessage pendReq = new PendingMessage(msg);
            if (con != null && !isLocalRequest) {
                if (con.isClosed()) {
                    req.release();
                    return;
                }
                con.addObserver(new ConnectionObserverAdapter(){

                    public void closedConnection(Connection con) {
                        MsgInterceptor.this.reqStatusChanged(pendReq);
                    }
                });
            }
            this.msgs.add(pendReq);
            int action = this.checkRules(req, false);
            if (!isLocalRequest) {
                if (action == 1) {
                    pendReq.wasHeld = true;
                } else {
                    pendReq.wasHeld = false;
                    if (action == 3) {
                        this.deleteMsg(this.msgs.size() - 1);
                    } else {
                        this.submitMsg(this.msgs.size() - 1);
                    }
                }
            } else {
                pendReq.wasHeld = true;
            }
            final int idx = this.msgs.size() - 1;
            GUIOps.put(new GUIOps.Operator(){

                public void fireEvent() {
                    MsgInterceptor.this.fireTableRowsInserted(idx, idx);
                }
            });
        } else if (msg instanceof HttpResponse) {
            PendingMessage req;
            int fIdx;
            int idx;
            if (msg.hasMoreBody()) {
                msg.addObserver(this.resReader);
            } else {
                this.resReader.messageReadDone(msg);
            }
            HttpResponse res = (HttpResponse)msg;
            if (res.getRequest() == null || res.getRequest().getReqHeaders().action == null) {
                Connection con = res.getSrcInfo().getCon();
                boolean hadPending = false;
                if (con != null) {
                    for (int idx2 = 0; idx2 < this.msgs.size(); ++idx2) {
                        Connection reqTarget;
                        PendingMessage pend = (PendingMessage)this.msgs.get(idx2);
                        if (pend.req == null || (reqTarget = pend.req.getDstInfo().getCon()) != con) continue;
                        hadPending = true;
                        if (pend.res != null) continue;
                        HttpResponse newRes = new HttpResponse();
                        newRes.hold();
                        newRes.setRequest(pend.req);
                        newRes.getSrcInfo().setCon(con);
                        pend.setResponse(newRes);
                        pend.submitted = true;
                        this.resWriter.put(newRes);
                        int action = this.checkRules(newRes, pend.wasHeld);
                        if (action == 2) {
                            this.submitMsg(idx2);
                            --idx2;
                            continue;
                        }
                        final int fIdx2 = idx2;
                        GUIOps.put(new GUIOps.Operator(){

                            public void fireEvent() {
                                MsgInterceptor.this.fireTableRowsUpdated(fIdx2, fIdx2);
                            }
                        });
                    }
                }
                if (!hadPending) {
                    res.release();
                    this.resWriter.put(res);
                }
                return;
            }
            this.resWriter.put(res);
            int maxIdx = this.msgs.size();
            for (idx = 0; idx < maxIdx && !this.msgs.get(idx).equals(msg); ++idx) {
            }
            if (idx < maxIdx) {
                fIdx = idx;
                req = (PendingMessage)this.msgs.get(idx);
                if (req.res != null) {
                    req.res.release();
                }
                req.setResponse(res);
                GUIOps.put(new GUIOps.Operator(){

                    public void fireEvent() {
                        MsgInterceptor.this.fireTableRowsUpdated(fIdx, fIdx);
                    }
                });
            } else {
                req = new PendingMessage(res);
                this.msgs.add(req);
                fIdx = this.msgs.size() - 1;
                GUIOps.put(new GUIOps.Operator(){

                    public void fireEvent() {
                        MsgInterceptor.this.fireTableRowsInserted(fIdx, fIdx);
                    }
                });
            }
            Connection con = res.getSrcInfo().getCon();
            if (con != null) {
                con.addObserver(new ConnectionObserverAdapter(){

                    public void closedConnection(Connection con) {
                        MsgInterceptor.this.resStatusChanged(req);
                    }
                });
            }
            int action = this.checkRules(res, req.wasHeld);
            if (req.req.getSrcInfo().getCon().getPeerAddress() != null && action == 2) {
                this.submitMsg(idx);
            }
        }
    }

    synchronized void deleteMsg(int idx) {
        if (idx < 0 || idx >= this.msgs.size()) {
            return;
        }
        PendingMessage msg = (PendingMessage)this.msgs.get(idx);
        Connection srcCon = msg.req.getSrcInfo().getCon();
        if (srcCon != null) {
            Connection tgtCon = srcCon.getTargetConnection();
            if (tgtCon != null) {
                tgtCon.close();
            }
            srcCon.close();
        }
        this.msgs.remove(idx);
        final int fIdx = idx;
        GUIOps.put(new GUIOps.Operator(){

            public void fireEvent() {
                MsgInterceptor.this.fireTableRowsDeleted(fIdx, fIdx);
            }
        });
    }

    synchronized void submitMsg(int idx) {
        if (idx < 0 || idx >= this.msgs.size()) {
            return;
        }
        PendingMessage msg = (PendingMessage)this.msgs.get(idx);
        if (msg.res != null) {
            this.msgs.remove(idx);
            final int fIdx = idx;
            GUIOps.put(new GUIOps.Operator(){

                public void fireEvent() {
                    MsgInterceptor.this.fireTableRowsDeleted(fIdx, fIdx);
                }
            });
            msg.res.release();
        } else if (msg.submitted) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            Connection con = msg.req.getSrcInfo().getCon().getTargetConnection();
            if (!con.wasConnected()) {
                con.setConnectStatus(1);
                this.reqConnector.put(con);
            }
            msg.submitted = true;
            msg.req.release();
            final int fIdx = idx;
            GUIOps.put(new GUIOps.Operator(){

                public void fireEvent() {
                    MsgInterceptor.this.fireTableRowsUpdated(fIdx, fIdx);
                }
            });
        }
    }

    public void put(Object in) {
        this.addMsg(in);
    }

    public int getColumnCount() {
        return 3;
    }

    public synchronized int getRowCount() {
        return this.msgs.size();
    }

    public synchronized HttpRequest getRequest(int idx) {
        if (idx < 0 || idx >= this.msgs.size()) {
            return null;
        }
        PendingMessage pendMsg = (PendingMessage)this.msgs.get(idx);
        return pendMsg.req;
    }

    public synchronized List getRequestsForConnection(Connection con) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        int idx = 0;
        Iterator it = this.msgs.iterator();
        while (it.hasNext()) {
            PendingMessage pend = (PendingMessage)it.next();
            if (pend.req != null && pend.req.getSrcInfo().getCon() == con) {
                ret.add(new Integer(idx));
            }
            ++idx;
        }
        return ret;
    }

    public synchronized HttpResponse getResponse(int idx) {
        if (idx < 0 || idx >= this.msgs.size()) {
            return null;
        }
        PendingMessage pendMsg = (PendingMessage)this.msgs.get(idx);
        return pendMsg.res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearResponse(int idx) {
        Connection srcCon = null;
        boolean statusChanged = false;
        MsgInterceptor msgInterceptor = this;
        synchronized (msgInterceptor) {
            if (idx < 0 || idx >= this.msgs.size()) {
                return;
            }
            PendingMessage pendMsg = (PendingMessage)this.msgs.get(idx);
            pendMsg.submitted = false;
            if (pendMsg.res != null) {
                pendMsg.res.delete();
                if (pendMsg.res.hasMoreBody()) {
                    Connection resCon = pendMsg.res.getSrcInfo().getCon();
                    Connection oldTarget = resCon.getTargetConnection();
                    resCon.setTargetConnection(null);
                    try {
                        pendMsg.res.streamBody(null, null, null);
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    resCon.setTargetConnection(oldTarget);
                }
            }
            pendMsg.res = null;
            srcCon = pendMsg.req.getSrcInfo().getCon();
            Connection dstCon = srcCon.getTargetConnection();
            if (dstCon.isClosed()) {
                boolean wasSSL = dstCon.isSSL();
                HostPort targetAddr = dstCon.getPeerAddress();
                dstCon = Connection.newSource(srcCon);
                dstCon.setPeerAddress(targetAddr);
                srcCon.setTargetConnection(dstCon);
                if (wasSSL) {
                    dstCon.setAttribute("SSL", Boolean.TRUE);
                }
                statusChanged = true;
            }
            pendMsg.req.hold();
            this.reqWriter.put(pendMsg.req);
            final int fIdx = idx;
            GUIOps.put(new GUIOps.Operator(){

                public void fireEvent() {
                    MsgInterceptor.this.fireTableRowsUpdated(fIdx, fIdx);
                }
            });
        }
        if (statusChanged) {
            srcCon.fireStatusChanged();
        }
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: 
            case 2: {
                return ImageIcon.class;
            }
        }
        return null;
    }

    public synchronized Object getValueAt(int row, int col) {
        if (row >= this.msgs.size() || col > 2) {
            return null;
        }
        HttpRequest req = null;
        HttpResponse res = null;
        PendingMessage msg = (PendingMessage)this.msgs.get(row);
        req = msg.req;
        res = msg.res;
        boolean status = false;
        switch (col) {
            case 0: {
                if (req == null) {
                    return null;
                }
                RequestParsedHeaders reqHeaders = req.getReqHeaders();
                String portStr = "";
                if (reqHeaders.port != reqHeaders.defaultPort) {
                    portStr = ":" + reqHeaders.port;
                }
                int port = req.getReqHeaders().port;
                return "//" + req.getHost() + portStr + req.getReqHeaders().action;
            }
            case 1: {
                if (req == null) {
                    return null;
                }
                return ConIcons.getMessageIcon(req);
            }
            case 2: {
                if (res == null) {
                    if (msg.submitted) {
                        return ConIcons.getMessageProgressIcon(req);
                    }
                    return null;
                }
                return ConIcons.getMessageIcon(res);
            }
        }
        return null;
    }

    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Target";
            }
            case 1: {
                return "Req";
            }
            case 2: {
                return "Res";
            }
        }
        return "";
    }

    static {
        fullyAutomatic = new AutomationRule(){

            public int handleMessage(Message msg, boolean exists) {
                return 2;
            }
        };
        fullyManual = new AutomationRule(){

            public int handleMessage(Message msg, boolean exists) {
                return 1;
            }
        };
        nonInterestingActionPattern = Pattern.compile("\\.(?:ico|jpg|jpeg|png|gif|js|css|tiff|tif|xls|doc|zip|jar|class|arj|swf|avi|mp3|ogg|mpeg|mpg)$", 2);
        smartAutomation = new AutomationRule(){

            public int handleMessage(Message msg, boolean exists) {
                if (exists) {
                    return 1;
                }
                if (msg instanceof HttpResponse) {
                    return 2;
                }
                HttpRequest req = (HttpRequest)msg;
                if (nonInterestingActionPattern.matcher(req.getReqHeaders().action).find(0)) {
                    return 2;
                }
                return 1;
            }
        };
    }

    static class PendingMessage {
        HttpRequest req;
        HttpResponse res;
        boolean submitted = false;
        boolean wasHeld = false;

        PendingMessage(Object msg) {
            if (msg instanceof HttpRequest) {
                this.req = (HttpRequest)msg;
                this.res = null;
            } else {
                this.res = (HttpResponse)msg;
                this.req = this.res.getRequest();
            }
        }

        void setResponse(HttpResponse res) {
            this.res = res;
        }

        public int hashCode() {
            return this.req.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof PendingMessage) {
                return this.req.equals(((PendingMessage)obj).req);
            }
            if (obj instanceof HttpResponse) {
                return this.req.equals(((HttpResponse)obj).getRequest());
            }
            return this.req.equals(obj);
        }
    }
}

