/*
 * Decompiled with CFR 0.152.
 */
package webshadow.ui;

import com.jgoodies.forms.factories.DefaultComponentFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.zip.ZipInputStream;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import webshadow.comm.Acceptor;
import webshadow.comm.Connection;
import webshadow.comm.ConnectionObserver;
import webshadow.comm.HostPort;
import webshadow.comm.MessageWriter;
import webshadow.comm.SocksAcceptor;
import webshadow.http.ConnectMessageInterceptor;
import webshadow.http.HttpMessage;
import webshadow.http.HttpRequest;
import webshadow.http.HttpRequestReader;
import webshadow.http.HttpRequestWriter;
import webshadow.http.HttpResponse;
import webshadow.http.HttpResponseReader;
import webshadow.http.RequestConnector;
import webshadow.http.RequestMessageSender;
import webshadow.http.ResponseMessageSender;
import webshadow.log.FileLogger;
import webshadow.ui.AbstractListSelectionModel;
import webshadow.ui.AutoReadBody;
import webshadow.ui.ConnectionCellRenderer;
import webshadow.ui.ConnectionListModel;
import webshadow.ui.ConnectionPanel;
import webshadow.ui.CustomRulesDialog;
import webshadow.ui.GUIOps;
import webshadow.ui.HttpRequestPanel;
import webshadow.ui.HttpResponsePanel;
import webshadow.ui.MessageModel;
import webshadow.ui.MsgInterceptor;
import webshadow.ui.ParsedRequestPanel;
import webshadow.ui.SpoxyBanner;
import webshadow.ui.SpoxyPrefs;
import webshadow.util.Queue;

public class MainPanel
extends JPanel
implements Runnable {
    static final int MAX_READBODY_LENGTH = 20480;
    static boolean initializedConnection = false;
    int selectedCon = -1;
    private CustomRulesDialog customRulesDialog;
    private ButtonGroup defaultRuleGroup;
    private JRadioButton jAutoFull;
    private JRadioButton jAutoManual;
    private JRadioButton jAutoSmart;
    private JButton jClearResponse;
    private ConnectionPanel jConnection;
    private JList jConnectionList;
    private JButton jDelete;
    private JScrollPane jMessageScroll;
    private JTable jMessageTable;
    private JButton jNewRequest;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private ParsedRequestPanel jParsedRequest;
    private HttpRequestPanel jRawRequest;
    private HttpResponsePanel jRawResponse;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JLabel jStatusLabel;
    private JButton jSubmit;
    private JTabbedPane jTabbedPane1;
    private JCheckBox jUseCustom;
    private MsgInterceptor msgInterceptor;
    private ConnectionListModel conListModel;
    ConSelectionModel conSelectionModel;
    ListSelectionModel msgSelectionModel;
    boolean allowEmptyMainSelection;
    private AutoReadBody reqAutoReadBody;
    private AutoReadBody resAutoReadBody;
    private int numThreads;
    private int port;
    private int socksport;
    private int lastTab;
    private int userTab;
    private FileLogger logger = new FileLogger();

    private void setPrefs() {
        this.port = SpoxyPrefs.getInt(1);
        --this.port;
        this.socksport = SpoxyPrefs.getInt(2);
        --this.socksport;
        HostPort.autoReverseDNS = SpoxyPrefs.getBoolean(5);
        this.numThreads = SpoxyPrefs.getInt(0);
    }

    public MainPanel() {
        this.msgInterceptor = new MsgInterceptor();
        this.setPrefs();
        SpoxyPrefs.addPreferenceChangeListener(new PreferenceChangeListener(){

            public void preferenceChange(PreferenceChangeEvent evt) {
                MainPanel.this.setPrefs();
            }
        });
        this.lastTab = -1;
        this.userTab = 3;
        this.conListModel = new ConnectionListModel();
        this.conSelectionModel = new ConSelectionModel();
        this.initComponents();
        this.jUseCustomActionPerformed(null);
        ConnectionCellRenderer conRender = new ConnectionCellRenderer();
        this.jConnectionList.setCellRenderer(conRender);
        Dimension cellSize = conRender.getCellSize();
        this.jConnectionList.setFixedCellHeight(cellSize.height);
        this.jConnectionList.setFixedCellWidth(cellSize.width);
        this.jConnectionList.setSelectionModel(this.conSelectionModel);
        this.msgSelectionModel = this.jMessageTable.getSelectionModel();
        this.msgSelectionModel.setSelectionMode(2);
        cellSize.height *= 2;
        cellSize.height += 3;
        cellSize.width *= 3;
        cellSize.width += 3;
        this.jScrollPane2.setPreferredSize(cellSize);
        this.jMessageTable.setRowHeight(32);
        this.jMessageTable.getColumn("Req").setMinWidth(40);
        this.jMessageTable.getColumn("Req").setMaxWidth(40);
        this.jMessageTable.getColumn("Req").setPreferredWidth(40);
        this.jMessageTable.getColumn("Res").setMinWidth(40);
        this.jMessageTable.getColumn("Res").setMaxWidth(40);
        this.jMessageTable.getColumn("Res").setPreferredWidth(40);
    }

    private void initComponents() {
        this.defaultRuleGroup = new ButtonGroup();
        this.customRulesDialog = new CustomRulesDialog();
        this.jPanel10 = new SpoxyBanner();
        this.jPanel1 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jPanel7 = (JPanel)DefaultComponentFactory.getInstance().createSeparator("Active Connections");
        this.jScrollPane2 = new JScrollPane();
        this.jConnectionList = new JList();
        this.jPanel5 = new JPanel();
        this.jPanel8 = new JPanel();
        this.jNewRequest = new JButton();
        this.jDelete = new JButton();
        this.jSubmit = new JButton();
        this.jClearResponse = new JButton();
        this.jPanel9 = new JPanel();
        this.jUseCustom = new JCheckBox();
        this.jAutoSmart = new JRadioButton();
        this.jAutoFull = new JRadioButton();
        this.jAutoManual = new JRadioButton();
        this.jPanel6 = new JPanel();
        this.jStatusLabel = new JLabel();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel2 = new JPanel();
        this.jMessageScroll = new JScrollPane();
        this.jMessageTable = new JTable();
        this.jPanel3 = new JPanel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jConnection = new ConnectionPanel();
        this.jRawRequest = new HttpRequestPanel();
        this.jParsedRequest = new ParsedRequestPanel();
        this.jRawResponse = new HttpResponsePanel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.jPanel10, "North");
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel4.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel4.add((Component)this.jPanel7, gridBagConstraints);
        this.jConnectionList.setModel(this.conListModel);
        this.jConnectionList.setLayoutOrientation(2);
        this.jConnectionList.setSelectionMode(0);
        this.jConnectionList.setVisibleRowCount(0);
        this.jScrollPane2.setViewportView(this.jConnectionList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.jScrollPane2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 2, 8);
        this.jPanel1.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanel5.setLayout(new BorderLayout());
        this.jPanel8.setLayout(new FlowLayout(0, 8, 8));
        this.jNewRequest.setText("New Request");
        this.jNewRequest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.jNewRequestActionPerformed(evt);
            }
        });
        this.jPanel8.add(this.jNewRequest);
        this.jDelete.setText("Delete Request");
        this.jDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.jDeleteActionPerformed(evt);
            }
        });
        this.jPanel8.add(this.jDelete);
        this.jSubmit.setText("Submit");
        this.jSubmit.setMaximumSize(new Dimension(120, 23));
        this.jSubmit.setMinimumSize(new Dimension(120, 23));
        this.jSubmit.setPreferredSize(new Dimension(120, 23));
        this.jSubmit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.jSubmitActionPerformed(evt);
            }
        });
        this.jPanel8.add(this.jSubmit);
        this.jClearResponse.setText("Clear Response");
        this.jClearResponse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.jClearResponseActionPerformed(evt);
            }
        });
        this.jPanel8.add(this.jClearResponse);
        this.jPanel5.add((Component)this.jPanel8, "West");
        this.jPanel9.setLayout(new FlowLayout(2, 8, 8));
        this.jUseCustom.setText("Use Custom Rules");
        this.jUseCustom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.jUseCustomActionPerformed(evt);
            }
        });
        this.jPanel9.add(this.jUseCustom);
        this.defaultRuleGroup.add(this.jAutoSmart);
        this.jAutoSmart.setText("Smart");
        this.jAutoSmart.setToolTipText("Don't stop images, applets, etc.");
        this.jAutoSmart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.jAutoSmartActionPerformed(evt);
            }
        });
        this.jPanel9.add(this.jAutoSmart);
        this.defaultRuleGroup.add(this.jAutoFull);
        this.jAutoFull.setSelected(true);
        this.jAutoFull.setText("Automatic");
        this.jAutoFull.setToolTipText("Don't stop anything");
        this.jAutoFull.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.jAutoFullActionPerformed(evt);
            }
        });
        this.jPanel9.add(this.jAutoFull);
        this.defaultRuleGroup.add(this.jAutoManual);
        this.jAutoManual.setText("Manual");
        this.jAutoManual.setToolTipText("Stop everything");
        this.jAutoManual.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainPanel.this.jAutoManualActionPerformed(evt);
            }
        });
        this.jPanel9.add(this.jAutoManual);
        this.jPanel5.add((Component)this.jPanel9, "East");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 8, 0);
        this.jPanel1.add((Component)this.jPanel5, gridBagConstraints);
        this.jPanel6.setLayout(new BorderLayout());
        this.jPanel6.setBorder(new SoftBevelBorder(1));
        this.jStatusLabel.setHorizontalAlignment(2);
        this.jStatusLabel.setText("Starting Up");
        this.jPanel6.add((Component)this.jStatusLabel, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel6, gridBagConstraints);
        this.add((Component)this.jPanel1, "South");
        this.jSplitPane1.setDividerLocation(200);
        this.jSplitPane1.setResizeWeight(0.5);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jMessageScroll.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
        this.jMessageTable.setModel(this.getMsgInterceptor());
        this.jMessageScroll.setViewportView(this.jMessageTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.jMessageScroll, gridBagConstraints);
        this.jSplitPane1.setLeftComponent(this.jPanel2);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                MainPanel.this.jTabbedPane1StateChanged(evt);
            }
        });
        this.jTabbedPane1.addTab("Connection", this.jConnection);
        this.jTabbedPane1.addTab("Raw Request", this.jRawRequest);
        this.jTabbedPane1.addTab("Parsed Request", this.jParsedRequest);
        this.jTabbedPane1.addTab("Raw Response", this.jRawResponse);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.jTabbedPane1, gridBagConstraints);
        this.jSplitPane1.setRightComponent(this.jPanel3);
        this.add((Component)this.jSplitPane1, "Center");
    }

    private InputStream getDefaultRequestStream() throws IOException {
        File templateDir = SpoxyPrefs.getFile(4);
        File defFile = new File(templateDir, "default.reqz");
        InputStream ins = null;
        if (defFile.exists()) {
            try {
                ins = new FileInputStream(defFile);
            }
            catch (IOException ioe) {
                ins = this.getClass().getResourceAsStream("default.reqz");
            }
        } else {
            ins = this.getClass().getResourceAsStream("default.reqz");
        }
        return ins;
    }

    private void jNewRequestActionPerformed(ActionEvent evt) {
        try {
            Connection oldCon;
            boolean needAccept = true;
            InputStream ins = this.getDefaultRequestStream();
            ZipInputStream inz = new ZipInputStream(ins);
            HttpRequest newReq = new HttpRequest();
            int idx = this.conSelectionModel.getMinSelectionIndex();
            if (idx >= 0 && this.msgSelectionModel.getMinSelectionIndex() < 0 && (oldCon = (Connection)this.conListModel.getElementAt(idx)) != null) {
                newReq.getSrcInfo().setCon(oldCon);
                needAccept = false;
            }
            newReq.readFromZip(inz);
            inz.close();
            this.msgInterceptor.put(newReq);
            if (needAccept) {
                Connection con = newReq.getSrcInfo().getCon();
                this.conListModel.acceptedConnection(con);
            }
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, "Unexpected error: " + ioe.getMessage());
        }
    }

    private void jClearResponseActionPerformed(ActionEvent evt) {
        int idx = this.msgSelectionModel.getMinSelectionIndex();
        if (idx >= 0) {
            this.msgInterceptor.clearResponse(idx);
        } else {
            this.getToolkit().beep();
        }
    }

    private void jTabbedPane1StateChanged(ChangeEvent evt) {
        int newTab = this.jTabbedPane1.getSelectedIndex();
        if (this.lastTab >= 0) {
            ((MessageModel)((Object)this.jTabbedPane1.getComponent(this.lastTab))).updateMessageFromModel();
            if (newTab < this.lastTab && this.jTabbedPane1.isEnabledAt(this.lastTab)) {
                this.userTab = newTab;
            }
        }
        if (newTab > this.userTab) {
            this.userTab = newTab;
        }
        if (this.msgSelectionModel != null) {
            HttpResponse res;
            HttpRequest req;
            int idx = this.msgSelectionModel.getMinSelectionIndex();
            if (idx >= 0) {
                req = this.msgInterceptor.getRequest(idx);
                res = this.msgInterceptor.getResponse(idx);
            } else {
                req = null;
                res = null;
            }
            switch (newTab) {
                case 0: {
                    Connection con = null;
                    if (req != null) {
                        con = req.getSrcInfo().getCon();
                    }
                    if (con == this.jConnection.getConnection()) break;
                    this.jConnection.setConnection(con);
                    break;
                }
                case 1: {
                    if (req == this.jRawRequest.getHttpMessage()) break;
                    this.jRawRequest.setHttpMessage(req);
                    break;
                }
                case 2: {
                    if (req == this.jParsedRequest.getRequest()) break;
                    this.jParsedRequest.setRequest(req);
                    break;
                }
                case 3: {
                    if (res == this.jRawResponse.getHttpMessage()) break;
                    this.jRawResponse.setHttpMessage(res);
                }
            }
            ((MessageModel)((Object)this.jTabbedPane1.getComponent(newTab))).updateModelFromMessage();
        }
        this.lastTab = this.jTabbedPane1.getSelectedIndex();
    }

    private void jDeleteActionPerformed(ActionEvent evt) {
        int idx = this.msgSelectionModel.getMinSelectionIndex();
        if (idx >= 0) {
            this.msgInterceptor.deleteMsg(idx);
            this.messageTableDisplayUpdate();
        } else {
            idx = this.conSelectionModel.getMinSelectionIndex();
            if (idx >= 0) {
                this.conListModel.delConnection(idx);
            }
            this.conListDisplayUpdate();
        }
    }

    private void jUseCustomActionPerformed(ActionEvent evt) {
        this.msgInterceptor.setUseCustom(this.jUseCustom.isSelected());
    }

    private void jAutoFullActionPerformed(ActionEvent evt) {
        if (this.jAutoFull.isSelected()) {
            this.msgInterceptor.setDefaultRule(1);
        }
    }

    private void jAutoSmartActionPerformed(ActionEvent evt) {
        if (this.jAutoSmart.isSelected()) {
            this.msgInterceptor.setDefaultRule(0);
        }
    }

    private void jAutoManualActionPerformed(ActionEvent evt) {
        if (this.jAutoManual.isSelected()) {
            this.msgInterceptor.setDefaultRule(2);
        }
    }

    private void jSubmitActionPerformed(ActionEvent evt) {
        int idx = this.jMessageTable.getSelectedRow();
        if (idx >= 0) {
            ((MessageModel)((Object)this.jTabbedPane1.getComponent(idx))).updateMessageFromModel();
            this.msgInterceptor.submitMsg(idx);
            this.messageTableDisplayUpdate();
        }
    }

    private void conListDisplayUpdate() {
        ConSelectionModel lsm = this.conSelectionModel;
        Connection con = null;
        if (lsm.isSelectionEmpty()) {
            HttpRequest req;
            ListSelectionModel mlsm = this.msgSelectionModel;
            int idx = mlsm.getMinSelectionIndex();
            if (idx >= 0 && (req = this.msgInterceptor.getRequest(idx)) != null) {
                con = req.getSrcInfo().getCon();
            }
        } else {
            int idx = lsm.getMinSelectionIndex();
            if (idx >= 0) {
                con = (Connection)this.conListModel.getElementAt(idx);
            }
        }
        if (con == null) {
            this.jConnection.setConnection(null);
            this.jTabbedPane1.setEnabledAt(0, false);
        } else if (con != this.jConnection.getConnection()) {
            this.jConnection.setConnection(con);
            this.jTabbedPane1.setEnabledAt(0, true);
        }
    }

    private void messageTableDisplayUpdate() {
        ListSelectionModel lsm = this.msgSelectionModel;
        HttpRequest req = null;
        int idx = lsm.getMinSelectionIndex();
        if (idx >= 0) {
            req = this.msgInterceptor.getRequest(idx);
        }
        if (req == null && !this.allowEmptyMainSelection && (req = this.msgInterceptor.getRequest(0)) != null) {
            lsm.setSelectionInterval(0, 0);
        }
        this.allowEmptyMainSelection = false;
        if (req == null) {
            int minIndex = 1;
            this.jRawRequest.setHttpMessage(null);
            this.jRawResponse.setHttpMessage(null);
            for (int i = minIndex; i < this.jTabbedPane1.getTabCount(); ++i) {
                this.jTabbedPane1.setEnabledAt(i, false);
            }
            this.jTabbedPane1.setSelectedIndex(0);
            this.jSubmit.setEnabled(false);
            this.jClearResponse.setEnabled(false);
        } else {
            Connection reqCon = req.getSrcInfo().getCon();
            int conIdx = this.conListModel.indexOf(reqCon);
            if (conIdx != this.selectedCon) {
                this.conSelectionModel.newSelectionValue(conIdx);
            }
            for (int i = 1; i < 3; ++i) {
                this.jTabbedPane1.setEnabledAt(i, true);
            }
            HttpResponse res = this.msgInterceptor.getResponse(idx);
            if (res != null) {
                if (reqCon.getConnectStatus() == 2 && reqCon.getPeerAddress() != null) {
                    this.jSubmit.setEnabled(true);
                } else {
                    this.jSubmit.setEnabled(false);
                }
                this.jClearResponse.setEnabled(true);
                this.jSubmit.setText("Submit Response");
                this.jSubmit.setToolTipText("Submit the response back to the browser");
                for (int i = 3; i < this.jTabbedPane1.getTabCount(); ++i) {
                    this.jTabbedPane1.setEnabledAt(i, true);
                }
                if (this.userTab >= 0) {
                    this.jTabbedPane1.setSelectedIndex(this.userTab);
                }
            } else {
                this.jSubmit.setEnabled(true);
                Connection resCon = reqCon.getTargetConnection();
                if (resCon.isClosed()) {
                    this.jClearResponse.setEnabled(true);
                } else {
                    this.jClearResponse.setEnabled(false);
                }
                this.jSubmit.setText("Submit Request");
                this.jSubmit.setToolTipText("Submit the request to the web server");
                for (int i = 3; i < this.jTabbedPane1.getTabCount(); ++i) {
                    this.jTabbedPane1.setEnabledAt(i, false);
                }
                int newTab = 1;
                if (this.userTab == 2 || this.userTab == 0) {
                    newTab = this.userTab;
                }
                this.jTabbedPane1.setSelectedIndex(newTab);
            }
            int selected = this.jTabbedPane1.getSelectedIndex();
            switch (selected) {
                case 1: {
                    if (req == this.jRawRequest.getHttpMessage()) break;
                    this.jRawRequest.setHttpMessage(req);
                    break;
                }
                case 2: {
                    if (req == this.jParsedRequest.getRequest()) break;
                    this.jParsedRequest.setRequest(req);
                    break;
                }
                case 3: {
                    if (res == this.jRawResponse.getHttpMessage()) break;
                    this.jRawResponse.setHttpMessage(res);
                }
            }
        }
    }

    public boolean startLogging(File logDir) {
        boolean res = this.logger.startLogging(logDir);
        this.showStatus();
        return res;
    }

    public void stopLogging() {
        this.logger.stopLogging();
        this.showStatus();
    }

    public int getPort() {
        return this.port;
    }

    public MsgInterceptor getMsgInterceptor() {
        return this.msgInterceptor;
    }

    public HttpRequest getSelectedRequest() {
        int idx = this.msgSelectionModel.getMinSelectionIndex();
        if (idx < 0) {
            return null;
        }
        return this.msgInterceptor.getRequest(idx);
    }

    public void refresh() {
        this.jRawRequest.setHttpMessage(null);
        this.jParsedRequest.setRequest(null);
        this.jConnection.setConnection(null);
        int idx = this.msgSelectionModel.getMinSelectionIndex();
        if (idx >= 0) {
            HttpRequest req = this.msgInterceptor.getRequest(idx);
            if (req != null) {
                this.jRawRequest.setHttpMessage(req);
                this.jParsedRequest.setRequest(req);
                Connection con = req.getSrcInfo().getCon();
                if (con != null) {
                    this.jConnection.setConnection(con);
                }
            }
            this.msgInterceptor.fireTableRowsUpdated(idx, idx);
        }
        if ((idx = this.conSelectionModel.getMinSelectionIndex()) >= 0) {
            Connection con = (Connection)this.conListModel.getElementAt(idx);
            if (con != null) {
                this.jConnection.setConnection(con);
            }
            this.conListModel.fireContentsChanged(idx);
        } else {
            this.conListDisplayUpdate();
        }
    }

    public CustomRulesDialog getCustomRules() {
        return this.customRulesDialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Class clazz = MainPanel.class;
        synchronized (clazz) {
            if (!initializedConnection) {
                Connection.init(this.getClass().getResourceAsStream("/ssl.keys"), "passphrase");
                initializedConnection = true;
            }
        }
        List<FileLogger> loggerList = Collections.singletonList(this.logger);
        ArrayList<ConnectionObserver> connectionObservers = new ArrayList<ConnectionObserver>();
        connectionObservers.add(this.logger);
        connectionObservers.add(this.jConnection);
        connectionObservers.add(this.conListModel);
        List<ConnectionListModel> conTrackList = Collections.singletonList(this.conListModel);
        Queue reqReadQueue = new Queue();
        Queue reqWriteQueue = new Queue();
        Queue resReadQueue = new Queue();
        Queue resWriteQueue = new Queue();
        Queue reqConnectQueue = new Queue();
        Acceptor acceptor = null;
        Acceptor sacceptor = null;
        while (acceptor == null) {
            try {
                ++this.port;
                acceptor = new Acceptor(this.port);
            }
            catch (IOException ioe) {}
        }
        while (sacceptor == null) {
            try {
                ++this.socksport;
                sacceptor = new SocksAcceptor(this.socksport);
            }
            catch (IOException ioe) {}
        }
        acceptor.setObservers(conTrackList);
        sacceptor.setObservers(conTrackList);
        new Thread((Runnable)acceptor, "Acceptor (" + this.port + ")").start();
        new Thread((Runnable)sacceptor, "SocksAcceptor (" + this.socksport + ")").start();
        ResponseMessageSender responseMessageSender = new ResponseMessageSender();
        RequestMessageSender requestMessageSender = new RequestMessageSender();
        HttpRequestReader[] reqReaders = new HttpRequestReader[this.numThreads];
        for (int i = 0; i < reqReaders.length; ++i) {
            reqReaders[i] = new HttpRequestReader();
            reqReaders[i].setModuleQueue(reqReadQueue);
            reqReaders[i].setMessageHandler(this.msgInterceptor);
            new Thread((Runnable)reqReaders[i], "Request Reader " + i).start();
        }
        HttpResponseReader[] resReaders = new HttpResponseReader[this.numThreads];
        for (int i = 0; i < reqReaders.length; ++i) {
            resReaders[i] = new HttpResponseReader();
            resReaders[i].setModuleQueue(resReadQueue);
            resReaders[i].setMessageHandler(this.msgInterceptor);
            resReaders[i].setObservers(loggerList);
            new Thread((Runnable)resReaders[i], "Response Reader " + i).start();
        }
        HttpRequestWriter[] reqWriters = new HttpRequestWriter[this.numThreads];
        for (int i = 0; i < reqWriters.length; ++i) {
            reqWriters[i] = new HttpRequestWriter();
            reqWriters[i].setModuleQueue(reqWriteQueue);
            reqWriters[i].setObservers(loggerList);
            new Thread((Runnable)reqWriters[i], "Request Writer " + i).start();
        }
        MessageWriter[] resWriters = new MessageWriter[this.numThreads];
        for (int i = 0; i < resWriters.length; ++i) {
            resWriters[i] = new MessageWriter();
            resWriters[i].setModuleQueue(resWriteQueue);
            new Thread((Runnable)resWriters[i], "Response Writer " + i).start();
        }
        ConnectMessageInterceptor[] sslIntercepts = new ConnectMessageInterceptor[this.numThreads];
        Queue connectorQueue = new Queue();
        for (int i = 0; i < sslIntercepts.length; ++i) {
            sslIntercepts[i] = new ConnectMessageInterceptor();
            sslIntercepts[i].setHandlers(reqReadQueue, resWriteQueue, this.msgInterceptor);
            sslIntercepts[i].setModuleQueue(connectorQueue);
            new Thread((Runnable)sslIntercepts[i], "ConnectInterceptor " + i).start();
        }
        acceptor.setConnectionHandler(connectorQueue);
        sacceptor.setConnectionHandler(connectorQueue);
        RequestConnector[] connectors = new RequestConnector[this.numThreads];
        for (int i = 0; i < connectors.length; ++i) {
            connectors[i] = new RequestConnector();
            connectors[i].setModuleQueue(reqConnectQueue);
            connectors[i].setConnectionHandlers(reqWriteQueue, resReadQueue);
            connectors[i].setObservers(connectionObservers);
            new Thread((Runnable)connectors[i], "Connector " + i).start();
        }
        this.msgInterceptor.setMessageHandlers(requestMessageSender, responseMessageSender, reqConnectQueue, reqReaders[0], resReaders[0]);
        new Thread((Runnable)new GUIOps(), "GUI Operations").start();
        this.showStatus();
        this.reqAutoReadBody = new AutoReadBody(){

            public boolean shouldReadBody(HttpMessage msg) {
                return msg.getParsedHeaders().contentLength <= 20480;
            }

            public boolean shouldDisplayBody(HttpMessage msg) {
                return true;
            }
        };
        this.resAutoReadBody = new AutoReadBody(){

            public boolean shouldReadBody(HttpMessage msg) {
                if (msg.getParsedHeaders().contentLength > 20480) {
                    return false;
                }
                return this.shouldDisplayBody(msg);
            }

            public boolean shouldDisplayBody(HttpMessage msg) {
                String contentType = msg.getParsedHeaders().contentType;
                if (contentType != null) {
                    if (contentType.indexOf("html") >= 0) {
                        return true;
                    }
                    if (contentType.indexOf("text") >= 0) {
                        return true;
                    }
                    if (contentType.indexOf("xml") >= 0) {
                        return true;
                    }
                    return contentType.indexOf("script") >= 0;
                }
                return true;
            }
        };
        this.jRawRequest.setAutoReadBody(this.reqAutoReadBody);
        this.jRawResponse.setAutoReadBody(this.resAutoReadBody);
        ListSelectionModel rowSM = this.jMessageTable.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                MainPanel.this.messageTableDisplayUpdate();
            }
        });
        ListSelectionModel conListSM = this.jConnectionList.getSelectionModel();
        conListSM.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                MainPanel.this.conListDisplayUpdate();
            }
        });
        this.msgInterceptor.setCustomRule(this.customRulesDialog);
        this.msgInterceptor.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                MainPanel.this.messageTableDisplayUpdate();
            }
        });
        this.messageTableDisplayUpdate();
        this.jAutoFullActionPerformed(null);
    }

    private void showStatus() {
        File logdir = this.logger.getLogDir();
        this.jStatusLabel.setText("Serving HTTP on port " + this.port + " and SOCKS on port " + this.socksport + ". " + this.numThreads + " threads; " + (logdir == null ? "" : "Logging to " + logdir.getAbsolutePath()));
    }

    class ConSelectionModel
    extends AbstractListSelectionModel {
        ConSelectionModel() {
        }

        public boolean isSelectedIndex(int idx) {
            return idx == MainPanel.this.selectedCon;
        }

        public boolean isSelectionEmpty() {
            return MainPanel.this.selectedCon == -1;
        }

        public int getAnchorSelectionIndex() {
            return MainPanel.this.selectedCon;
        }

        public int getLeadSelectionIndex() {
            return MainPanel.this.selectedCon;
        }

        public int getMinSelectionIndex() {
            return MainPanel.this.selectedCon;
        }

        public int getMaxSelectionIndex() {
            return MainPanel.this.selectedCon;
        }

        void newSelectionValue(int newCon) {
            int oldCon = MainPanel.this.selectedCon;
            MainPanel.this.selectedCon = newCon;
            if (MainPanel.this.selectedCon != oldCon) {
                if (oldCon != -1) {
                    this.fireValueChanged(oldCon, oldCon, true);
                }
                this.fireValueChanged(MainPanel.this.selectedCon, MainPanel.this.selectedCon, false);
            }
        }

        public void setSelectionInterval(int first, int last) {
            Connection con = (Connection)MainPanel.this.conListModel.getElementAt(first);
            if (con != null) {
                List newMessages = MainPanel.this.msgInterceptor.getRequestsForConnection(con);
                MainPanel.this.allowEmptyMainSelection = true;
                MainPanel.this.msgSelectionModel.clearSelection();
                Iterator it = newMessages.iterator();
                if (it.hasNext()) {
                    int i = (Integer)it.next();
                    MainPanel.this.msgSelectionModel.setSelectionInterval(i, i);
                    while (it.hasNext()) {
                        i = (Integer)it.next();
                        MainPanel.this.msgSelectionModel.addSelectionInterval(i, i);
                    }
                }
            }
            this.newSelectionValue(first);
        }

        public void removeIndexInterval(int first, int last) {
            if (MainPanel.this.selectedCon >= first && MainPanel.this.selectedCon <= last) {
                MainPanel.this.selectedCon = -1;
            }
        }
    }
}

