/*
 * Decompiled with CFR 0.152.
 */
package webshadow.ui;

import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import com.jgoodies.looks.plastic.theme.ExperienceBlue;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.filechooser.FileFilter;
import webshadow.http.HttpRequest;
import webshadow.ui.AboutDialog;
import webshadow.ui.MainPanel;
import webshadow.ui.PreferenceEditor;
import webshadow.ui.SpoxyPrefs;
import webshadow.ui.UIUtils;

public class JSpoxy
extends JFrame {
    public static final String TEMPLATE_EXT = ".reqz";
    public static final FileFilter templateFilesFilter = new FileFilter(){

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith(JSpoxy.TEMPLATE_EXT);
        }

        public String getDescription() {
            return "Request templates";
        }
    };
    public static final int MAX_LASTFILES = 4;
    boolean hasRecent = false;
    int fileMenuLastPos;
    ArrayList recentFiles = new ArrayList();
    ArrayList recentFileMenus = new ArrayList();
    HelpBroker hb;
    private JMenuItem jLoadRequest;
    private JMenuItem jEditPrefs;
    private JCheckBoxMenuItem jLoggingState;
    private JMenuItem jReloadJS;
    private JMenuItem jEditCustom;
    private JMenuItem jContents;
    private JMenuItem jQuit;
    private JMenu jEditMenu;
    private JMenu jHelp;
    private JMenuItem jSaveRequest;
    private JMenuBar jMenuBar1;
    private MainPanel mainPanel1;
    private JMenu jFileMenu;
    private JMenuItem jAbout;
    private PreferenceEditor jPrefsEditor;
    private AboutDialog jAboutDialog;
    private JFileChooser fileChooser;

    public JSpoxy() {
        this.initComponents();
        this.setIconImage(new ImageIcon(this.getClass().getResource("spoxy.gif")).getImage());
        this.fileMenuLastPos = this.jFileMenu.getItemCount() + 1;
        this.jPrefsEditor = new PreferenceEditor((Frame)this, true);
        this.jAboutDialog = new AboutDialog((Frame)this, true);
        this.fileChooser = new JFileChooser(SpoxyPrefs.getFile(4));
        this.fileChooser.addChoosableFileFilter(templateFilesFilter);
        this.fileChooser.setFileFilter(templateFilesFilter);
        this.loadCustomRules();
        try {
            URL hsURL = this.getClass().getResource("/powertools-httpProxy.hs");
            HelpSet hs = new HelpSet(null, hsURL);
            this.hb = hs.createHelpBroker();
            this.jContents.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(this.hb));
        }
        catch (Exception ee) {
            JOptionPane.showMessageDialog(null, "Error loading help: " + ee);
            this.jContents.setEnabled(false);
        }
        this.mainPanel1.run();
    }

    private void initComponents() {
        this.mainPanel1 = new MainPanel();
        this.jMenuBar1 = new JMenuBar();
        this.jFileMenu = new JMenu();
        this.jLoggingState = new JCheckBoxMenuItem();
        this.jSaveRequest = new JMenuItem();
        this.jLoadRequest = new JMenuItem();
        this.jQuit = new JMenuItem();
        this.jEditMenu = new JMenu();
        this.jEditCustom = new JMenuItem();
        this.jEditPrefs = new JMenuItem();
        this.jReloadJS = new JMenuItem();
        this.jHelp = new JMenu();
        this.jContents = new JMenuItem();
        this.jAbout = new JMenuItem();
        this.setTitle("Watchfire HTTP Proxy");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JSpoxy.this.exitForm(evt);
            }
        });
        this.getContentPane().add((Component)this.mainPanel1, "Center");
        this.jFileMenu.setMnemonic('F');
        this.jFileMenu.setText("File");
        this.jLoggingState.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.jLoggingState.setMnemonic('L');
        this.jLoggingState.setText("Enable Logging");
        this.jLoggingState.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JSpoxy.this.jLoggingStateActionPerformed(evt);
            }
        });
        this.jFileMenu.add(this.jLoggingState);
        this.jSaveRequest.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.jSaveRequest.setMnemonic('S');
        this.jSaveRequest.setText("Save Request...");
        this.jSaveRequest.setToolTipText("Save the current request to a file");
        this.jSaveRequest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JSpoxy.this.jSaveRequestActionPerformed(evt);
            }
        });
        this.jFileMenu.add(this.jSaveRequest);
        this.jLoadRequest.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.jLoadRequest.setMnemonic('O');
        this.jLoadRequest.setText("Load Request...");
        this.jLoadRequest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JSpoxy.this.jLoadRequestActionPerformed(evt);
            }
        });
        this.jFileMenu.add(this.jLoadRequest);
        this.jQuit.setMnemonic('x');
        this.jQuit.setText("Exit");
        this.jQuit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JSpoxy.this.jQuitActionPerformed(evt);
            }
        });
        this.jFileMenu.add(this.jQuit);
        this.jMenuBar1.add(this.jFileMenu);
        this.jEditMenu.setMnemonic('E');
        this.jEditMenu.setText("Edit");
        this.jEditCustom.setMnemonic('C');
        this.jEditCustom.setText("Custom Rules...");
        this.jEditCustom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JSpoxy.this.jEditCustomActionPerformed(evt);
            }
        });
        this.jEditMenu.add(this.jEditCustom);
        this.jEditPrefs.setMnemonic('P');
        this.jEditPrefs.setText("Preferences...");
        this.jEditPrefs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JSpoxy.this.jEditPrefsActionPerformed(evt);
            }
        });
        this.jEditMenu.add(this.jEditPrefs);
        this.jReloadJS.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.jReloadJS.setMnemonic('R');
        this.jReloadJS.setText("Reload JavaScript");
        this.jReloadJS.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JSpoxy.this.jReloadJSActionPerformed(evt);
            }
        });
        this.jEditMenu.add(this.jReloadJS);
        this.jMenuBar1.add(this.jEditMenu);
        this.jHelp.setMnemonic('H');
        this.jHelp.setText("Help");
        this.jContents.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.jContents.setText("Contents");
        this.jHelp.add(this.jContents);
        this.jAbout.setText("About...");
        this.jAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JSpoxy.this.jAboutActionPerformed(evt);
            }
        });
        this.jHelp.add(this.jAbout);
        this.jMenuBar1.add(this.jHelp);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void jReloadJSActionPerformed(ActionEvent evt) {
        this.loadJSRules();
    }

    private void jLoadRequestActionPerformed(ActionEvent evt) {
        if (this.fileChooser.showOpenDialog(this) != 0) {
            return;
        }
        File loadFile = this.fileChooser.getSelectedFile();
        this.addToLastFiles(loadFile);
        this.loadRequest(loadFile);
    }

    private void loadRequest(File loadFile) {
        HttpRequest req = this.mainPanel1.getSelectedRequest();
        if (req == null) {
            return;
        }
        try {
            FileInputStream fin = new FileInputStream(loadFile);
            ZipInputStream zin = new ZipInputStream(fin);
            req.readFromZip(zin);
            zin.close();
            this.mainPanel1.getMsgInterceptor().checkRules(req, false);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, "Error reading request: " + ioe.getMessage());
        }
        this.mainPanel1.refresh();
    }

    private void saveRequest(File saveFile, HttpRequest req) {
        if (saveFile.getName().indexOf(46) < 0) {
            saveFile = new File(saveFile.getAbsolutePath() + TEMPLATE_EXT);
        }
        try {
            FileOutputStream fout = new FileOutputStream(saveFile);
            ZipOutputStream zout = new ZipOutputStream(fout);
            req.writeToZip(zout);
            zout.close();
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, "Error writing request: " + ioe.getMessage());
        }
    }

    private void jAboutActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, "HTTP Proxy Version 1.0\n\nCopyright (c) 2005. Watchfire Corporation. All rights reserved.\n\nWatchfire, WebXM, PowerTools and the Flame Logo are\ntrademarks or registered trademarks of Watchfire Corporation.\n\nAll other products, company names, and logos are trademarks\nor registered trademarks of their respective owners.\n\n", "About Watchfire HTTP Proxy", 1);
    }

    private void jSaveRequestActionPerformed(ActionEvent evt) {
        HttpRequest req = this.mainPanel1.getSelectedRequest();
        if (req == null) {
            this.getToolkit().beep();
            return;
        }
        if (this.fileChooser.showSaveDialog(this) != 0) {
            return;
        }
        File saveFile = this.fileChooser.getSelectedFile();
        this.addToLastFiles(saveFile);
        this.saveRequest(saveFile, req);
    }

    private void jLoggingStateActionPerformed(ActionEvent evt) {
        if (this.jLoggingState.isSelected()) {
            File logDir = SpoxyPrefs.getFile(3);
            if (!this.mainPanel1.startLogging(logDir)) {
                this.getToolkit().beep();
                this.jLoggingState.setSelected(false);
            }
        } else {
            this.mainPanel1.stopLogging();
        }
    }

    private void jEditPrefsActionPerformed(ActionEvent evt) {
        this.jPrefsEditor.show();
    }

    private void addToLastFiles(File newFile) {
        if (!this.hasRecent) {
            this.jFileMenu.addSeparator();
            this.hasRecent = true;
        }
        if (newFile.getName().indexOf(46) < 0) {
            newFile = new File(newFile.getAbsolutePath() + TEMPLATE_EXT);
        }
        if (this.recentFiles.contains(newFile)) {
            return;
        }
        final File fNewFile = newFile;
        JMenuItem loadFile = new JMenuItem(newFile.getName());
        loadFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JSpoxy.this.loadRequest(fNewFile);
            }
        });
        this.recentFiles.add(0, newFile);
        this.recentFileMenus.add(0, loadFile);
        this.jFileMenu.insert(loadFile, this.fileMenuLastPos);
        if (this.recentFiles.size() > 4) {
            JMenuItem lastItem = (JMenuItem)this.recentFileMenus.get(4);
            this.recentFiles.remove(4);
            this.recentFileMenus.remove(4);
            this.jFileMenu.remove(lastItem);
        }
        this.jFileMenu.revalidate();
        this.jFileMenu.repaint();
    }

    void saveCustomRules() {
        File templateDir = SpoxyPrefs.getFile(4);
        if (!templateDir.exists() && !templateDir.mkdirs()) {
            return;
        }
        File defaultRuleFile = new File(templateDir, "defaultRules.rules");
        this.mainPanel1.getCustomRules().save(defaultRuleFile);
    }

    void loadCustomRules() {
        File templateDir = SpoxyPrefs.getFile(4);
        File defaultRuleFile = new File(templateDir, "defaultRules.rules");
        if (defaultRuleFile.exists()) {
            this.mainPanel1.getCustomRules().load(defaultRuleFile);
        }
        this.loadJSRules();
    }

    void loadJSRules() {
        File templateDir = SpoxyPrefs.getFile(4);
        File defaultJSRuleFile = new File(templateDir, "defaultRules.js");
        if (defaultJSRuleFile.exists()) {
            this.mainPanel1.getCustomRules().loadJSRules(defaultJSRuleFile);
        }
    }

    private void jQuitActionPerformed(ActionEvent evt) {
        this.exitForm(null);
    }

    private void jEditCustomActionPerformed(ActionEvent evt) {
        this.mainPanel1.getCustomRules().show();
    }

    private void exitForm(WindowEvent evt) {
        this.saveCustomRules();
        System.exit(0);
    }

    static void setPrefs() {
        try {
            LookUtils.setLookAndTheme((LookAndFeel)new PlasticXPLookAndFeel(), (Object)new ExperienceBlue());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        JSpoxy.setPrefs();
        JSpoxy spoxy = new JSpoxy();
        UIUtils.locateOnScreenCenter(spoxy);
        spoxy.setVisible(true);
    }
}

