/*
 * Decompiled with CFR 0.152.
 */
package webshadow.ui;

import com.jgoodies.forms.factories.DefaultComponentFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import webshadow.http.HttpMessage;
import webshadow.http.HttpResponse;
import webshadow.http.ResponseParsedHeaders;
import webshadow.ui.HttpMessagePanel;

public class HttpResponsePanel
extends HttpMessagePanel {
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JComboBox jStatus;
    private JTextField jStatusText;
    private JComboBox jVersion;

    public HttpResponsePanel() {
        this.initComponents();
        this.jStatusText.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                HttpResponsePanel.this.statusTextChanged();
            }

            public void insertUpdate(DocumentEvent e) {
                HttpResponsePanel.this.statusTextChanged();
            }

            public void removeUpdate(DocumentEvent e) {
                HttpResponsePanel.this.statusTextChanged();
            }
        });
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel2 = (JPanel)DefaultComponentFactory.getInstance().createSeparator("Response");
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jVersion = new JComboBox();
        this.jStatus = new JComboBox();
        this.jStatusText = new JTextField();
        this.getContentPane().setLayout(new BorderLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(new EmptyBorder(new Insets(8, 8, 8, 8)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("Version");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 2, 2);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setText("Status");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 2, 2);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setText("Explanation");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 2, 0);
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        this.jVersion.setEditable(true);
        this.jVersion.setModel(new DefaultComboBoxModel<String>(new String[]{"HTTP/1.1", "HTTP/1.0", "HTTP/0.9"}));
        this.jVersion.setMinimumSize(new Dimension(94, 18));
        this.jVersion.setPreferredSize(new Dimension(94, 19));
        this.jVersion.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HttpResponsePanel.this.jVersionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 0, 0, 2);
        this.jPanel1.add((Component)this.jVersion, gridBagConstraints);
        this.jStatus.setEditable(true);
        this.jStatus.setModel(new DefaultComboBoxModel<String>(new String[]{"200", "404", "301", "403"}));
        this.jStatus.setPreferredSize(new Dimension(94, 19));
        this.jStatus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HttpResponsePanel.this.jStatusActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 0, 2);
        this.jPanel1.add((Component)this.jStatus, gridBagConstraints);
        this.jStatusText.setText("OK");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel1.add((Component)this.jStatusText, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel1, "Center");
    }

    private void jStatusActionPerformed(ActionEvent evt) {
        if (this.httpMessage == null) {
            return;
        }
        HttpResponse res = (HttpResponse)this.httpMessage;
        ResponseParsedHeaders hdrs = res.getRespHeaders();
        try {
            hdrs.code = Integer.parseInt((String)this.jStatus.getSelectedItem());
        }
        catch (NumberFormatException nfe) {
            this.jStatus.setSelectedItem(String.valueOf(hdrs.code));
        }
    }

    private void jVersionActionPerformed(ActionEvent evt) {
        if (this.httpMessage == null) {
            return;
        }
        HttpResponse res = (HttpResponse)this.httpMessage;
        ResponseParsedHeaders hdrs = res.getRespHeaders();
        hdrs.protocol = (String)this.jVersion.getSelectedItem();
    }

    private void statusTextChanged() {
        if (this.httpMessage == null) {
            return;
        }
        HttpResponse res = (HttpResponse)this.httpMessage;
        ResponseParsedHeaders hdrs = res.getRespHeaders();
        hdrs.codeMsg = this.jStatusText.getText();
    }

    public void setHttpMessage(HttpMessage httpMessage) {
        super.setHttpMessage(httpMessage);
        if (httpMessage == null) {
            this.jStatus.setSelectedItem("");
            this.jStatus.setEnabled(false);
            this.jVersion.setSelectedItem("");
            this.jVersion.setEnabled(false);
            this.jStatusText.setText("");
            this.jStatusText.setEnabled(false);
            return;
        }
        HttpResponse res = (HttpResponse)httpMessage;
        ResponseParsedHeaders hdrs = res.getRespHeaders();
        this.jStatus.setSelectedItem(String.valueOf(hdrs.code));
        this.jStatus.setEnabled(true);
        this.jVersion.setSelectedItem(hdrs.protocol);
        this.jVersion.setEnabled(true);
        this.jStatusText.setText(hdrs.codeMsg);
        this.jStatusText.setEnabled(true);
    }
}

