/*
 * Decompiled with CFR 0.152.
 */
package webshadow.ui;

import com.jgoodies.forms.factories.DefaultComponentFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import webshadow.http.HttpMessage;
import webshadow.http.HttpRequest;
import webshadow.http.RequestParsedHeaders;
import webshadow.ui.HttpMessagePanel;

public class HttpRequestPanel
extends HttpMessagePanel {
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JComboBox jMethod;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextField jPath;
    private JComboBox jVersion;

    public HttpRequestPanel() {
        this.initComponents();
        this.jPath.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                HttpRequestPanel.this.pathChanged();
            }

            public void insertUpdate(DocumentEvent e) {
                HttpRequestPanel.this.pathChanged();
            }

            public void removeUpdate(DocumentEvent e) {
                HttpRequestPanel.this.pathChanged();
            }
        });
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel2 = (JPanel)DefaultComponentFactory.getInstance().createSeparator("Request");
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jMethod = new JComboBox();
        this.jPath = new JTextField();
        this.jVersion = new JComboBox();
        this.getContentPane().setLayout(new BorderLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(new EmptyBorder(new Insets(8, 8, 8, 8)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("Method");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 2, 2);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setText("Path");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 2, 2);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setText("Version");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 2, 2, 0);
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        this.jMethod.setEditable(true);
        this.jMethod.setModel(new DefaultComboBoxModel<String>(new String[]{"GET", "POST", "HEAD", "TRACE", "OPTIONS", "PUT", "DELETE", "CONNECT"}));
        this.jMethod.setPreferredSize(new Dimension(94, 19));
        this.jMethod.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HttpRequestPanel.this.jMethodActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 0, 0, 2);
        this.jPanel1.add((Component)this.jMethod, gridBagConstraints);
        this.jPath.setText("/");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 0, 2);
        this.jPanel1.add((Component)this.jPath, gridBagConstraints);
        this.jVersion.setEditable(true);
        this.jVersion.setModel(new DefaultComboBoxModel<String>(new String[]{"HTTP/1.1", "HTTP/1.0", "HTTP/0.9"}));
        this.jVersion.setMinimumSize(new Dimension(94, 18));
        this.jVersion.setPreferredSize(new Dimension(94, 19));
        this.jVersion.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HttpRequestPanel.this.jVersionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 0, 0);
        this.jPanel1.add((Component)this.jVersion, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel1, "Center");
    }

    private void jVersionActionPerformed(ActionEvent evt) {
        if (this.httpMessage == null) {
            return;
        }
        HttpRequest req = (HttpRequest)this.httpMessage;
        RequestParsedHeaders hdrs = req.getReqHeaders();
        hdrs.protocol = (String)this.jVersion.getSelectedItem();
    }

    private void jMethodActionPerformed(ActionEvent evt) {
        if (this.httpMessage == null) {
            return;
        }
        HttpRequest req = (HttpRequest)this.httpMessage;
        RequestParsedHeaders hdrs = req.getReqHeaders();
        hdrs.method = (String)this.jMethod.getSelectedItem();
    }

    private void pathChanged() {
        if (this.httpMessage == null) {
            return;
        }
        HttpRequest req = (HttpRequest)this.httpMessage;
        RequestParsedHeaders hdrs = req.getReqHeaders();
        hdrs.setAction(this.jPath.getText());
    }

    public void setHttpMessage(HttpMessage httpMessage) {
        super.setHttpMessage(httpMessage);
        if (httpMessage == null) {
            this.jMethod.setSelectedItem("");
            this.jMethod.setEnabled(false);
            this.jVersion.setSelectedItem("");
            this.jVersion.setEnabled(false);
            this.jPath.setText("");
            this.jPath.setEnabled(false);
            return;
        }
        HttpRequest req = (HttpRequest)httpMessage;
        RequestParsedHeaders hdrs = req.getReqHeaders();
        this.jVersion.setSelectedItem(hdrs.protocol);
        this.jVersion.setEnabled(true);
        this.jMethod.setSelectedItem(hdrs.method);
        this.jMethod.setEnabled(true);
        this.jPath.setText(hdrs.action);
        this.jPath.setEnabled(true);
    }
}

