/*
 * Decompiled with CFR 0.152.
 */
package webshadow.ui;

import com.jgoodies.forms.factories.DefaultComponentFactory;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.zip.ZipException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import webshadow.http.HttpMessage;
import webshadow.ui.AutoReadBody;
import webshadow.ui.GUIOps;
import webshadow.ui.HttpHeaderTableModel;
import webshadow.ui.MessageModel;
import webshadow.ui.hex.ByteArrayHexData;
import webshadow.ui.hex.JHexEdit;

public class HttpMessagePanel
extends JPanel
implements MessageModel {
    private JCheckBox jAutoUnzip;
    private JPanel jBodyPanel;
    private JButton jButton1;
    private JButton jButton2;
    private JPanel jFirstLinePanel;
    private JButton jForceBodyRead;
    private JTable jHeaders;
    private JHexEdit jHexBody;
    private JCheckBox jHexDisplay;
    private JCheckBox jIgnoreContentLength;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JTextArea jRawBodyText;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    protected AutoReadBody autoReadBody = null;
    protected HttpMessage httpMessage = null;
    protected HttpHeaderTableModel headerTableModel = new HttpHeaderTableModel();
    private byte[] hexBuf;
    private boolean wasHexEdited;
    private boolean ignoreFirstEdit;

    public HttpMessagePanel() {
        this.initComponents();
        this.jButton2.setEnabled(false);
        this.jHeaders.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                HttpMessagePanel.this.jButton2.setEnabled(HttpMessagePanel.this.jHeaders.getSelectedRowCount() > 0);
            }
        });
        this.jSplitPane1.resetToPreferredSizes();
        this.jRawBodyText.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                HttpMessagePanel.this.rawBodyChanged();
            }

            public void insertUpdate(DocumentEvent e) {
                HttpMessagePanel.this.rawBodyChanged();
            }

            public void removeUpdate(DocumentEvent e) {
                HttpMessagePanel.this.rawBodyChanged();
            }
        });
    }

    private void initComponents() {
        this.jFirstLinePanel = new JPanel();
        this.jPanel3 = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jPanel2 = (JPanel)DefaultComponentFactory.getInstance().createSeparator("Headers");
        this.jScrollPane1 = new JScrollPane();
        this.jHeaders = new JTable();
        this.jPanel7 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jPanel5 = new JPanel();
        this.jPanel6 = (JPanel)DefaultComponentFactory.getInstance().createSeparator("Body");
        this.jBodyPanel = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jRawBodyText = new JTextArea();
        this.jHexBody = new JHexEdit();
        this.jPanel4 = new JPanel();
        this.jPanel8 = new JPanel();
        this.jIgnoreContentLength = new JCheckBox();
        this.jAutoUnzip = new JCheckBox();
        this.jHexDisplay = new JCheckBox();
        this.jPanel9 = new JPanel();
        this.jForceBodyRead = new JButton();
        this.setLayout(new BorderLayout());
        this.add((Component)this.jFirstLinePanel, "North");
        this.jPanel3.setLayout(new BorderLayout());
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.5);
        this.jSplitPane1.setPreferredSize(new Dimension(47, 114));
        this.jPanel1.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 4, 8);
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        this.jScrollPane1.setPreferredSize(new Dimension(240, 270));
        this.jHeaders.setModel(this.getHeaderTableModel());
        this.jScrollPane1.setViewportView(this.jHeaders);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 8);
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel7.setLayout(new FlowLayout(2, 8, 8));
        this.jButton1.setText("Add");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HttpMessagePanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel7.add(this.jButton1);
        this.jButton2.setText("Remove");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HttpMessagePanel.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel7.add(this.jButton2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel7, gridBagConstraints);
        this.jSplitPane1.setLeftComponent(this.jPanel1);
        this.jPanel5.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 4, 8);
        this.jPanel5.add((Component)this.jPanel6, gridBagConstraints);
        this.jBodyPanel.setLayout(new CardLayout());
        this.jRawBodyText.setColumns(30);
        this.jRawBodyText.setRows(15);
        this.jRawBodyText.setTabSize(4);
        this.jScrollPane2.setViewportView(this.jRawBodyText);
        this.jBodyPanel.add((Component)this.jScrollPane2, "card2");
        this.jBodyPanel.add((Component)this.jHexBody, "card3");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 8);
        this.jPanel5.add((Component)this.jBodyPanel, gridBagConstraints);
        this.jSplitPane1.setRightComponent(this.jPanel5);
        this.jPanel3.add((Component)this.jSplitPane1, "Center");
        this.add((Component)this.jPanel3, "Center");
        this.jPanel4.setLayout(new BorderLayout());
        this.jPanel8.setLayout(new FlowLayout(0, 8, 8));
        this.jIgnoreContentLength.setSelected(true);
        this.jIgnoreContentLength.setText("Auto Content Length");
        this.jIgnoreContentLength.setToolTipText("Automatically insert a content-length header according to the body size");
        this.jIgnoreContentLength.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                HttpMessagePanel.this.jIgnoreContentLengthStateChanged(evt);
            }
        });
        this.jPanel8.add(this.jIgnoreContentLength);
        this.jAutoUnzip.setSelected(true);
        this.jAutoUnzip.setText("Auto Unzip Body");
        this.jAutoUnzip.setToolTipText("Automatically Gzip/Unzip the body for Content-Encoding: gzip");
        this.jPanel8.add(this.jAutoUnzip);
        this.jHexDisplay.setText("Hex");
        this.jHexDisplay.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HttpMessagePanel.this.jHexDisplayActionPerformed(evt);
            }
        });
        this.jPanel8.add(this.jHexDisplay);
        this.jPanel4.add((Component)this.jPanel8, "West");
        this.jPanel9.setLayout(new FlowLayout(2, 8, 8));
        this.jForceBodyRead.setText("Force Body Read");
        this.jForceBodyRead.setToolTipText("Read the body into the buffer");
        this.jForceBodyRead.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HttpMessagePanel.this.jForceBodyReadActionPerformed(evt);
            }
        });
        this.jPanel9.add(this.jForceBodyRead);
        this.jPanel4.add((Component)this.jPanel9, "East");
        this.add((Component)this.jPanel4, "South");
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        int[] rows = this.jHeaders.getSelectedRows();
        for (int i = rows.length - 1; i >= 0; --i) {
            this.headerTableModel.removeHeader(rows[i]);
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.headerTableModel.addHeader();
    }

    private void jHexDisplayActionPerformed(ActionEvent evt) {
        if (this.wasHexEdited) {
            this.rawBodyChanged();
        }
        this.displayBody();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jIgnoreContentLengthStateChanged(ChangeEvent evt) {
        HttpMessagePanel httpMessagePanel = this;
        synchronized (httpMessagePanel) {
            if (this.httpMessage == null) {
                return;
            }
            this.httpMessage.getParsedHeaders().ignoreContentLengthHeader = this.jIgnoreContentLength.isSelected();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jForceBodyReadActionPerformed(ActionEvent evt) {
        HttpMessagePanel httpMessagePanel = this;
        synchronized (httpMessagePanel) {
            if (this.httpMessage != null) {
                try {
                    this.httpMessage.readBody();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.displayBody();
            }
        }
    }

    private synchronized void rawBodyChanged() {
        if (this.httpMessage == null) {
            return;
        }
        if (this.ignoreFirstEdit) {
            this.ignoreFirstEdit = false;
            return;
        }
        byte[] newBody = this.wasHexEdited ? this.hexBuf : this.jRawBodyText.getText().getBytes();
        this.httpMessage.setBody(newBody, this.jAutoUnzip.isSelected());
        this.wasHexEdited = false;
    }

    public HttpHeaderTableModel getHeaderTableModel() {
        return this.headerTableModel;
    }

    public HttpMessage getHttpMessage() {
        return this.httpMessage;
    }

    private synchronized void displayBody() {
        final HttpMessage httpMessage = this.httpMessage;
        GUIOps.put(new GUIOps.Operator(){

            public void fireEvent() {
                HttpMessagePanel.this.wasHexEdited = false;
                HttpMessagePanel.this.ignoreFirstEdit = true;
                HttpMessagePanel.this.jRawBodyText.setText("");
                HttpMessagePanel.this.jHexBody.setHexData(null);
                if (HttpMessagePanel.this.jHexDisplay.isSelected()) {
                    ((CardLayout)HttpMessagePanel.this.jBodyPanel.getLayout()).last(HttpMessagePanel.this.jBodyPanel);
                } else {
                    ((CardLayout)HttpMessagePanel.this.jBodyPanel.getLayout()).first(HttpMessagePanel.this.jBodyPanel);
                }
                if (httpMessage == null) {
                    HttpMessagePanel.this.jRawBodyText.setEnabled(false);
                    HttpMessagePanel.this.jForceBodyRead.setEnabled(false);
                    return;
                }
                if (httpMessage.hasMoreBody()) {
                    HttpMessagePanel.this.jRawBodyText.setEnabled(false);
                    HttpMessagePanel.this.jForceBodyRead.setEnabled(true);
                } else {
                    HttpMessagePanel.this.jRawBodyText.setEnabled(true);
                    HttpMessagePanel.this.jForceBodyRead.setEnabled(false);
                    byte[] bodyBytes = null;
                    try {
                        bodyBytes = httpMessage.getBody(HttpMessagePanel.this.jAutoUnzip.isSelected());
                    }
                    catch (ZipException ze) {
                        try {
                            bodyBytes = httpMessage.getBody(false);
                            HttpMessagePanel.this.jAutoUnzip.setSelected(false);
                        }
                        catch (ZipException zipException) {
                            // empty catch block
                        }
                    }
                    if (HttpMessagePanel.this.jHexDisplay.isSelected()) {
                        HttpMessagePanel.access$1602(HttpMessagePanel.this, bodyBytes);
                        ByteArrayHexData bah = new ByteArrayHexData(HttpMessagePanel.this.hexBuf);
                        bah.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                HttpMessagePanel.this.wasHexEdited = true;
                            }
                        });
                        HttpMessagePanel.this.jHexBody.setHexData(bah);
                        HttpMessagePanel.this.ignoreFirstEdit = false;
                    } else {
                        HttpMessagePanel.access$1602(HttpMessagePanel.this, null);
                        HttpMessagePanel.this.jRawBodyText.setText(new String(bodyBytes));
                    }
                }
            }
        });
    }

    public synchronized void setHttpMessage(HttpMessage httpMessage) {
        this.httpMessage = httpMessage;
        if (httpMessage == null) {
            this.headerTableModel.setHttpMessage(null);
            this.displayBody();
            return;
        }
        this.jIgnoreContentLength.setSelected(httpMessage.getParsedHeaders().ignoreContentLengthHeader);
        if (this.autoReadBody != null) {
            if (this.autoReadBody.shouldReadBody(httpMessage) && httpMessage.hasMoreBody()) {
                try {
                    httpMessage.readBody();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                httpMessage.setUnchunk(true);
            }
            this.jHexDisplay.setSelected(!this.autoReadBody.shouldDisplayBody(httpMessage));
        } else {
            this.jHexDisplay.setSelected(false);
        }
        this.displayBody();
        this.headerTableModel.setHttpMessage(httpMessage);
    }

    public void setAutoReadBody(AutoReadBody autoReadBody) {
        this.autoReadBody = autoReadBody;
    }

    public Container getContentPane() {
        return this.jFirstLinePanel;
    }

    public synchronized void updateMessageFromModel() {
        if (this.httpMessage == null) {
            return;
        }
        if (this.wasHexEdited) {
            this.rawBodyChanged();
        }
    }

    public synchronized void updateModelFromMessage() {
        if (this.httpMessage == null) {
            return;
        }
        this.setHttpMessage(this.httpMessage);
    }

    static /* synthetic */ byte[] access$1602(HttpMessagePanel x0, byte[] x1) {
        x0.hexBuf = x1;
        return x1;
    }
}

