/*
 * Decompiled with CFR 0.152.
 */
package webshadow.ui;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import webshadow.http.HttpMessage;
import webshadow.http.ParsedHeaders;

public class HttpHeaderTableModel
extends AbstractTableModel {
    HttpMessage msg;

    public void setHttpMessage(HttpMessage msg) {
        this.msg = msg;
        this.fireTableDataChanged();
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Header";
            }
            case 1: {
                return "Value";
            }
        }
        return null;
    }

    public int getRowCount() {
        if (this.msg == null) {
            return 0;
        }
        return this.msg.getParsedHeaders().headers.size();
    }

    public Object getValueAt(int row, int col) {
        if (this.msg == null) {
            return null;
        }
        if (row < 0 || row >= this.msg.getParsedHeaders().headers.size()) {
            return "";
        }
        ParsedHeaders.NameValue hdr = (ParsedHeaders.NameValue)this.msg.getParsedHeaders().headers.get(row);
        return col == 0 ? hdr.name : hdr.value;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (this.msg == null) {
            return;
        }
        if (rowIndex < 0 || rowIndex >= this.msg.getParsedHeaders().headers.size()) {
            return;
        }
        String newVal = (String)aValue;
        ArrayList headers = this.msg.getParsedHeaders().headers;
        this.msg.setUseRawHeaders(false);
        ParsedHeaders.NameValue hdr = (ParsedHeaders.NameValue)headers.get(rowIndex);
        if (columnIndex == 0) {
            hdr.name = newVal;
        } else {
            hdr.value = newVal;
        }
        this.msg.getParsedHeaders().parseAllSignificantHeaders();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.msg != null;
    }

    public void addHeader() {
        ArrayList headers = this.msg.getParsedHeaders().headers;
        ParsedHeaders.NameValue hdr = new ParsedHeaders.NameValue("", "");
        headers.add(hdr);
        this.msg.getParsedHeaders().parseAllSignificantHeaders();
        this.fireTableRowsInserted(headers.size(), headers.size());
    }

    public void removeHeader(int row) {
        this.msg.getParsedHeaders().headers.remove(row);
        this.fireTableRowsDeleted(row, row);
    }
}

