/*
 * Decompiled with CFR 0.152.
 */
package webshadow.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;

class FileChooserEditor
extends DefaultCellEditor {
    File currentFile = null;
    Component fileEditorComponent;
    JComboBox booleanEditor;
    boolean isBoolean = false;

    public FileChooserEditor(JButton b) {
        super(new JTextField());
        this.fileEditorComponent = b;
        String[] trueFalse = new String[]{"true", "false"};
        this.booleanEditor = new JComboBox<String>(trueFalse);
        this.setClickCountToStart(2);
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileChooserEditor.this.fireEditingStopped();
            }
        });
    }

    protected void fireEditingStopped() {
        super.fireEditingStopped();
    }

    public Object getCellEditorValue() {
        if (this.currentFile != null) {
            return this.currentFile;
        }
        if (this.isBoolean) {
            return new Boolean(this.booleanEditor.getSelectedItem().equals("true"));
        }
        return super.getCellEditorValue();
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.isBoolean = false;
        this.currentFile = null;
        if (value instanceof File) {
            this.currentFile = (File)value;
            ((JButton)this.fileEditorComponent).setText(this.currentFile.getAbsolutePath());
            return this.fileEditorComponent;
        }
        if (value instanceof Boolean) {
            this.isBoolean = true;
            this.booleanEditor.setSelectedIndex((Boolean)value != false ? 0 : 1);
            return this.booleanEditor;
        }
        return super.getTableCellEditorComponent(table, value, isSelected, row, column);
    }
}

