/*
 * Decompiled with CFR 0.152.
 */
package webshadow.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import webshadow.comm.Message;
import webshadow.http.HttpMessage;
import webshadow.http.HttpRequest;
import webshadow.http.HttpResponse;
import webshadow.js.RuleContext;
import webshadow.ui.AutomationRule;
import webshadow.ui.SpoxyPrefs;
import webshadow.ui.UIUtils;

public class CustomRulesDialog
extends JDialog
implements AutomationRule {
    public static final String RULES_EXT = ".rules";
    public static final String JSRULES_EXT = ".js";
    public static final FileFilter ruleFilesFilter = new FileFilter(){

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith(CustomRulesDialog.RULES_EXT);
        }

        public String getDescription() {
            return "Rules files";
        }
    };
    JComboBox matchEditor = new JComboBox<String>(matches);
    JComboBox dirEditor;
    JComboBox actionEditor;
    JComboBox headerEditor;
    RuleTableModel rulesModel;
    ArrayList rules;
    List jsRules;
    RuleContext js;
    private JButton addButton;
    private JTable customRulesTable;
    private JButton deleteButton;
    private JPanel jPanel1;
    private JScrollPane jScrollPane2;
    private JButton loadButton;
    private JButton okButton;
    private JButton saveAsButton;
    private JFileChooser fileChooser;

    public CustomRulesDialog() {
        this.matchEditor.setEditable(false);
        this.dirEditor = new JComboBox<String>(directions);
        this.dirEditor.setEditable(false);
        this.actionEditor = new JComboBox<String>(actions);
        this.actionEditor.setEditable(false);
        this.headerEditor = new JComboBox<String>(headers);
        this.headerEditor.setEditable(true);
        this.rules = new ArrayList();
        this.jsRules = new ArrayList();
        this.rulesModel = new RuleTableModel();
        this.fileChooser = new JFileChooser(SpoxyPrefs.getFile(4));
        this.fileChooser.addChoosableFileFilter(ruleFilesFilter);
        this.fileChooser.setFileFilter(ruleFilesFilter);
        this.initComponents();
        this.customRulesTable.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(this.matchEditor));
        this.customRulesTable.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(this.dirEditor));
        this.customRulesTable.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(this.headerEditor));
        this.customRulesTable.getColumnModel().getColumn(4).setCellEditor(new DefaultCellEditor(this.actionEditor));
        this.deleteButton.setEnabled(false);
        this.customRulesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                CustomRulesDialog.this.deleteButton.setEnabled(CustomRulesDialog.this.customRulesTable.getSelectedRowCount() > 0);
            }
        });
        this.pack();
        UIUtils.locateOnScreenCenter(this);
    }

    public void load(InputStream istream) throws IOException {
        try {
            ObjectInputStream ois = new ObjectInputStream(istream);
            this.rules = (ArrayList)ois.readObject();
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Corrupted File");
        }
        this.rulesModel.fireTableDataChanged();
    }

    public void save(OutputStream ostream) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(ostream);
        oos.writeObject(this.rules);
        oos.flush();
    }

    public boolean load(File loadFile) {
        try {
            FileInputStream ruleFileStream = new FileInputStream(loadFile);
            this.load(ruleFileStream);
            ruleFileStream.close();
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, "Couldn't load custom rules: " + loadFile.getAbsolutePath() + " (" + ioe.getMessage() + ")", "Load Error", 0);
            return false;
        }
        return true;
    }

    public boolean loadJSRules(File loadFile) {
        try {
            FileInputStream ruleFileStream = new FileInputStream(loadFile);
            this.js = new RuleContext(ruleFileStream, loadFile.getName());
            ruleFileStream.close();
            this.jsRules = this.js.getFunctionNames();
            while (this.actionEditor.getItemCount() > actions.length) {
                this.actionEditor.removeItemAt(actions.length);
            }
            for (int i = 0; i < this.jsRules.size(); ++i) {
                this.actionEditor.addItem(this.jsRules.get(i));
            }
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, "Couldn't load custom rules: " + loadFile.getAbsolutePath() + " (" + ioe.getMessage() + ")", "Load Error", 0);
            return false;
        }
        return true;
    }

    public boolean save(File saveFile) {
        if (!saveFile.getName().endsWith(RULES_EXT) && saveFile.getName().indexOf(46) < 0) {
            saveFile = new File(saveFile.getAbsolutePath() + RULES_EXT);
        }
        try {
            FileOutputStream ruleFileStream = new FileOutputStream(saveFile);
            this.save(ruleFileStream);
            ruleFileStream.close();
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, "Couldn't save custom rules: " + saveFile.getAbsolutePath() + " (" + ioe.getMessage() + ")", "Save Error", 0);
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.okButton = new JButton();
        this.addButton = new JButton();
        this.deleteButton = new JButton();
        this.loadButton = new JButton();
        this.saveAsButton = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.customRulesTable = new JTable();
        this.setTitle("Custom Rules");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                CustomRulesDialog.this.closeDialog(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.setToolTipText("Close this dialog");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CustomRulesDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.okButton);
        this.addButton.setText("Add");
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CustomRulesDialog.this.addButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.addButton);
        this.deleteButton.setText("Delete");
        this.deleteButton.setToolTipText("Delete Selected rules");
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CustomRulesDialog.this.deleteButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.deleteButton);
        this.loadButton.setText("Load...");
        this.loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CustomRulesDialog.this.loadButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.loadButton);
        this.saveAsButton.setText("Save As...");
        this.saveAsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CustomRulesDialog.this.saveAsButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.saveAsButton);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.customRulesTable.setModel(this.rulesModel);
        this.jScrollPane2.setViewportView(this.customRulesTable);
        this.getContentPane().add((Component)this.jScrollPane2, "North");
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        this.rulesModel.addRule();
    }

    private void saveAsButtonActionPerformed(ActionEvent evt) {
        if (this.fileChooser.showSaveDialog(this) != 0) {
            return;
        }
        File saveFile = this.fileChooser.getSelectedFile();
        this.save(saveFile);
    }

    private void loadButtonActionPerformed(ActionEvent evt) {
        if (this.fileChooser.showOpenDialog(this) != 0) {
            return;
        }
        File loadFile = this.fileChooser.getSelectedFile();
        ArrayList oldRules = this.rules;
        if (this.load(loadFile)) {
            this.rules.addAll(oldRules);
            this.rulesModel.fireTableDataChanged();
        } else {
            this.rules = oldRules;
        }
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        if (JOptionPane.showConfirmDialog(this, "Delete selected rules?", "Confirm", 0) != 0) {
            return;
        }
        int[] rows = this.customRulesTable.getSelectedRows();
        if (rows == null) {
            return;
        }
        for (int i = rows.length - 1; i >= 0; --i) {
            this.rulesModel.removeRule(rows[i]);
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        new CustomRulesDialog().show();
    }

    public int handleMessage(Rule rule, Message rawMsg, boolean exists) {
        if (rule.actionType == 0 || rule.actionType < 0 && this.jsRules.indexOf(rule.actionName) < 0) {
            return 0;
        }
        HttpMessage msg = (HttpMessage)rawMsg;
        HttpRequest req = null;
        HttpResponse res = null;
        if (msg instanceof HttpResponse) {
            if (rule.dirType == 1) {
                return 0;
            }
            res = (HttpResponse)msg;
            req = res.getRequest();
        } else {
            if (rule.dirType == 2) {
                return 0;
            }
            req = (HttpRequest)msg;
        }
        if (rule.regexp == null) {
            return 0;
        }
        String testStr = null;
        switch (rule.matchType) {
            case 0: {
                if (req == null) {
                    return 0;
                }
                if (req.getReqHeaders().action == null) break;
                testStr = req.getReqHeaders().action;
                break;
            }
            case 1: {
                if (req == null) {
                    return 0;
                }
                if (req.getHost() == null) break;
                testStr = req.getHost() + ":" + req.getPort();
                break;
            }
            case 2: {
                if (req == null) {
                    return 0;
                }
                if (req.getReqHeaders().method == null) break;
                testStr = req.getReqHeaders().method;
                break;
            }
            case 3: {
                if (rule.header == null) break;
                testStr = msg.getParsedHeaders().getHeaderValue(rule.header);
                break;
            }
            case 4: {
                if (res == null) break;
                testStr = "" + res.getRespHeaders().code + " " + res.getRespHeaders().codeMsg;
                break;
            }
            case 5: {
                try {
                    if (msg.hasMoreBody()) {
                        msg.readBody();
                    }
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    msg.writeBody(bout, bout, bout);
                    bout.close();
                    testStr = bout.toString();
                    break;
                }
                catch (IOException ioe) {
                    testStr = null;
                }
            }
        }
        if (testStr != null && rule.regexp.matcher(testStr).find()) {
            if (rule.actionType >= 0) {
                return rule.actionType;
            }
            return this.js.callFunction(this.jsRules.indexOf(rule.actionName), req, res, exists);
        }
        return 0;
    }

    public int handleMessage(Message msg, boolean exists) {
        Iterator it = this.rules.iterator();
        while (it.hasNext()) {
            Rule rule = (Rule)it.next();
            int action = this.handleMessage(rule, msg, exists);
            if (action == 0) continue;
            return action;
        }
        return 0;
    }

    class RuleTableModel
    extends AbstractTableModel {
        final String[] columnNames = new String[]{"Match Object", "Direction", "Header Name", "Regular Expression", "Action"};

        RuleTableModel() {
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public int getRowCount() {
            if (CustomRulesDialog.this.rules == null) {
                return 0;
            }
            return CustomRulesDialog.this.rules.size();
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public Object getValueAt(int row, int col) {
            if (CustomRulesDialog.this.rules == null) {
                return null;
            }
            return ((Rule)CustomRulesDialog.this.rules.get(row)).getCol(col);
        }

        public boolean isCellEditable(int row, int col) {
            return true;
        }

        public void setValueAt(Object value, int row, int col) {
            if (!(value instanceof String)) {
                return;
            }
            if (CustomRulesDialog.this.rules == null) {
                return;
            }
            Rule rule = (Rule)CustomRulesDialog.this.rules.get(row);
            if (!rule.setCol(col, (String)value)) {
                JOptionPane.showMessageDialog(CustomRulesDialog.this, "Error setting field", "Edit Error", 0);
            }
            this.fireTableCellUpdated(row, col);
        }

        public void addRule() {
            Rule rule = new Rule();
            CustomRulesDialog.this.rules.add(rule);
            this.fireTableRowsInserted(CustomRulesDialog.this.rules.size(), CustomRulesDialog.this.rules.size());
        }

        public void removeRule(int row) {
            CustomRulesDialog.this.rules.remove(row);
            CustomRulesDialog.this.rulesModel.fireTableRowsDeleted(row, row);
        }
    }

    public static class Rule
    implements Serializable {
        int matchType;
        String header;
        Pattern regexp;
        String reStr;
        int actionType = 0;
        String actionName = AutomationRule.actions[0];
        int dirType;

        public String getCol(int col) {
            switch (col) {
                case 0: {
                    return AutomationRule.matches[this.matchType];
                }
                case 1: {
                    return AutomationRule.directions[this.dirType];
                }
                case 2: {
                    return this.header;
                }
                case 3: {
                    return this.reStr;
                }
                case 4: {
                    if (this.actionType >= 0) {
                        return AutomationRule.actions[this.actionType];
                    }
                    return this.actionName;
                }
            }
            return null;
        }

        public boolean setCol(int col, String str) {
            switch (col) {
                case 0: {
                    for (int i = 0; i < AutomationRule.matches.length; ++i) {
                        if (!AutomationRule.matches[i].equals(str)) continue;
                        this.matchType = i;
                        return true;
                    }
                    return false;
                }
                case 1: {
                    for (int i = 0; i < AutomationRule.directions.length; ++i) {
                        if (!AutomationRule.directions[i].equals(str)) continue;
                        this.dirType = i;
                        return true;
                    }
                    return false;
                }
                case 2: {
                    this.header = str;
                    return true;
                }
                case 3: {
                    this.reStr = str;
                    try {
                        this.regexp = Pattern.compile(str);
                        return true;
                    }
                    catch (PatternSyntaxException e) {
                        return false;
                    }
                }
                case 4: {
                    this.actionName = str;
                    for (int i = 0; i < AutomationRule.actions.length; ++i) {
                        if (!AutomationRule.actions[i].equals(str)) continue;
                        this.actionType = i;
                        return true;
                    }
                    this.actionType = -1;
                    return true;
                }
            }
            return false;
        }
    }
}

