/*
 * Decompiled with CFR 0.152.
 */
package webshadow.ui;

import com.jgoodies.forms.factories.DefaultComponentFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import webshadow.comm.Connection;
import webshadow.comm.ConnectionObserver;
import webshadow.comm.HostPort;
import webshadow.ui.ConIcons;
import webshadow.ui.MessageModel;

public class ConnectionPanel
extends JPanel
implements ConnectionObserver,
MessageModel {
    private JTextArea jCertificate;
    private JTextField jCipherSuite;
    private JButton jClientDisconnect;
    private JTextField jClientDst;
    private JPanel jClientPanel;
    private JTextField jClientSrc;
    private JButton jInvalidateSession;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JButton jRenegotiate;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JButton jServerDisconnect;
    private JTextField jServerDst;
    private JPanel jServerPanel;
    private JTextField jServerSrc;
    private JTextField jSessionID;
    private JCheckBox jUseSSL;
    private Connection con;
    private int ignoreServerDstChanged = 0;

    public ConnectionPanel() {
        this.initComponents();
        this.jUseSSL.setEnabled(false);
        this.jInvalidateSession.setEnabled(false);
        this.jRenegotiate.setEnabled(false);
        this.jRenegotiate.setEnabled(false);
        this.jServerDst.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                ConnectionPanel.this.targetChanged();
            }

            public void insertUpdate(DocumentEvent e) {
                ConnectionPanel.this.targetChanged();
            }

            public void removeUpdate(DocumentEvent e) {
                ConnectionPanel.this.targetChanged();
            }
        });
    }

    private void initComponents() {
        this.jSeparator1 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.jPanel5 = (JPanel)DefaultComponentFactory.getInstance().createSeparator("Connection Status");
        this.jClientPanel = new JPanel();
        this.jLabel4 = new JLabel();
        this.jClientSrc = new JTextField();
        this.jClientDisconnect = new JButton();
        this.jClientDst = new JTextField();
        this.jLabel5 = new JLabel();
        this.jServerSrc = new JTextField();
        this.jServerDisconnect = new JButton();
        this.jServerDst = new JTextField();
        this.jServerPanel = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel6 = (JPanel)DefaultComponentFactory.getInstance().createSeparator("SSL Status");
        this.jPanel3 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jSessionID = new JTextField();
        this.jLabel1 = new JLabel();
        this.jCipherSuite = new JTextField();
        this.jPanel7 = (JPanel)DefaultComponentFactory.getInstance().createSeparator("SSL Certificate");
        this.jScrollPane1 = new JScrollPane();
        this.jCertificate = new JTextArea();
        this.jPanel4 = new JPanel();
        this.jUseSSL = new JCheckBox();
        this.jInvalidateSession = new JButton();
        this.jRenegotiate = new JButton();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel1.add((Component)this.jPanel5, gridBagConstraints);
        this.jClientPanel.setLayout(new GridBagLayout());
        this.jLabel4.setText("HTTP Proxy <=> Browser:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.jClientPanel.add((Component)this.jLabel4, gridBagConstraints);
        this.jClientSrc.setEditable(false);
        this.jClientSrc.setText("N/A");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        this.jClientPanel.add((Component)this.jClientSrc, gridBagConstraints);
        this.jClientDisconnect.setMaximumSize(new Dimension(32, 32));
        this.jClientDisconnect.setMinimumSize(new Dimension(32, 32));
        this.jClientDisconnect.setPreferredSize(new Dimension(32, 32));
        this.jClientDisconnect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConnectionPanel.this.jClientDisconnectActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        this.jClientPanel.add((Component)this.jClientDisconnect, gridBagConstraints);
        this.jClientDst.setEditable(false);
        this.jClientDst.setText("N/A");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        this.jClientPanel.add((Component)this.jClientDst, gridBagConstraints);
        this.jLabel5.setText("HTTP Proxy <=> Web Server:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.jClientPanel.add((Component)this.jLabel5, gridBagConstraints);
        this.jServerSrc.setEditable(false);
        this.jServerSrc.setText("N/A");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        this.jClientPanel.add((Component)this.jServerSrc, gridBagConstraints);
        this.jServerDisconnect.setMaximumSize(new Dimension(32, 32));
        this.jServerDisconnect.setMinimumSize(new Dimension(32, 32));
        this.jServerDisconnect.setPreferredSize(new Dimension(32, 32));
        this.jServerDisconnect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConnectionPanel.this.jServerDisconnectActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.jClientPanel.add((Component)this.jServerDisconnect, gridBagConstraints);
        this.jServerDst.setEditable(false);
        this.jServerDst.setText("N/A");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        this.jClientPanel.add((Component)this.jServerDst, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jClientPanel, gridBagConstraints);
        this.jServerPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.jPanel1.add((Component)this.jServerPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel2.add((Component)this.jPanel6, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabel2.setHorizontalAlignment(2);
        this.jLabel2.setText("Session ID: ");
        this.jLabel2.setHorizontalTextPosition(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel3.add((Component)this.jLabel2, gridBagConstraints);
        this.jSessionID.setEditable(false);
        this.jSessionID.setText("N/A");
        this.jSessionID.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.jSessionID, gridBagConstraints);
        this.jLabel1.setHorizontalAlignment(2);
        this.jLabel1.setText("Cipher Suite: ");
        this.jLabel1.setHorizontalTextPosition(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel3.add((Component)this.jLabel1, gridBagConstraints);
        this.jCipherSuite.setEditable(false);
        this.jCipherSuite.setText("N/A");
        this.jCipherSuite.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.jCipherSuite, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 0, 4, 0);
        this.jPanel3.add((Component)this.jPanel7, gridBagConstraints);
        this.jCertificate.setEditable(false);
        this.jScrollPane1.setViewportView(this.jCertificate);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel3.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jUseSSL.setText("SSL");
        this.jUseSSL.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConnectionPanel.this.jUseSSLActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel4.add((Component)this.jUseSSL, gridBagConstraints);
        this.jInvalidateSession.setText("Invalidate Session");
        this.jInvalidateSession.setToolTipText("Subsequent SSL handshakes will use a new Session");
        this.jInvalidateSession.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConnectionPanel.this.jInvalidateSessionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.jPanel4.add((Component)this.jInvalidateSession, gridBagConstraints);
        this.jRenegotiate.setText("Renogotiate");
        this.jRenegotiate.setToolTipText("Force an SSL negotiation");
        this.jRenegotiate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConnectionPanel.this.jRenegotiateActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.jPanel4.add((Component)this.jRenegotiate, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        this.jPanel3.add((Component)this.jPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void jRenegotiateActionPerformed(ActionEvent evt) {
        if (this.con == null) {
            this.getToolkit().beep();
            return;
        }
        Connection targetCon = this.con.getTargetConnection();
        if (targetCon == null || targetCon.getConnectStatus() != 2) {
            this.getToolkit().beep();
            return;
        }
        SSLSocket sslSock = targetCon.getSSLSocket();
        if (sslSock == null) {
            this.getToolkit().beep();
            return;
        }
        try {
            sslSock.startHandshake();
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    private void jUseSSLActionPerformed(ActionEvent evt) {
        if (this.con == null) {
            return;
        }
        Connection targetCon = this.con.getTargetConnection();
        if (targetCon == null || targetCon.getConnectStatus() != 0) {
            this.getToolkit().beep();
            return;
        }
        HostPort targetAddr = targetCon.getPeerAddress();
        if (this.jUseSSL.isSelected()) {
            targetCon.setAttribute("SSL", Boolean.TRUE);
            if (targetAddr != null && targetAddr.getPort() == 80) {
                targetAddr.setPort(443);
                this.updateDisplay();
            }
        } else {
            targetCon.removeAttribute("SSL");
            if (targetAddr != null && targetAddr.getPort() == 443) {
                targetAddr.setPort(80);
                this.updateDisplay();
            }
        }
    }

    private void jInvalidateSessionActionPerformed(ActionEvent evt) {
        if (this.con == null) {
            this.getToolkit().beep();
            return;
        }
        Connection targetCon = this.con.getTargetConnection();
        if (targetCon == null || targetCon.getConnectStatus() != 2) {
            this.getToolkit().beep();
            return;
        }
        if (!targetCon.isSSL()) {
            this.getToolkit().beep();
            return;
        }
        SSLSession ses = targetCon.getSSLSession();
        ses.invalidate();
    }

    private void jServerDisconnectActionPerformed(ActionEvent evt) {
        if (this.con == null) {
            return;
        }
        Connection targetCon = this.con.getTargetConnection();
        if (targetCon == null || targetCon.getConnectStatus() != 2) {
            this.getToolkit().beep();
            return;
        }
        targetCon.close();
        this.updateDisplay();
    }

    private void jClientDisconnectActionPerformed(ActionEvent evt) {
        if (this.con == null || this.con.getConnectStatus() != 2) {
            this.getToolkit().beep();
            return;
        }
        this.con.close();
        this.updateDisplay();
    }

    public Connection getConnection() {
        return this.con;
    }

    public void setConnection(Connection connection) {
        Connection localCon = this.con;
        if (localCon != connection && localCon != null) {
            localCon.removeObserver(this);
        }
        this.con = connection;
        if (connection != null) {
            connection.addObserver(this);
        }
        this.updateDisplay();
    }

    void targetChanged() {
        int port;
        this.jServerDst.setForeground(Color.black);
        if (this.ignoreServerDstChanged > 0) {
            --this.ignoreServerDstChanged;
            return;
        }
        if (this.con == null || this.con.getTargetConnection().wasConnected()) {
            return;
        }
        String target = this.jServerDst.getText();
        int portStart = target.indexOf(58);
        int n = port = this.jUseSSL.isSelected() ? 443 : 80;
        if (portStart >= 0) {
            try {
                port = Integer.parseInt(target.substring(portStart + 1));
                target = target.substring(0, portStart);
            }
            catch (NumberFormatException nfe) {
                this.jServerDst.setForeground(Color.red);
            }
        }
        this.con.getTargetAddress().setPort(port);
        this.con.getTargetAddress().setHostName(target);
    }

    private void updateDisplay() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.display();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConnectionPanel.this.display();
                }
            });
        }
    }

    void display() {
        Connection target;
        ++this.ignoreServerDstChanged;
        this.jClientSrc.setText("N/A");
        this.jClientDisconnect.setIcon(ConIcons.emptyIcon);
        this.jClientDisconnect.setEnabled(false);
        this.jClientDst.setText("N/A");
        this.jServerSrc.setText("N/A");
        this.jServerDisconnect.setIcon(ConIcons.emptyIcon);
        this.jServerDisconnect.setEnabled(false);
        this.jServerDst.setText("");
        this.jServerDst.setEditable(false);
        this.jCipherSuite.setText("N/A");
        this.jSessionID.setText("N/A");
        this.jCertificate.setText("");
        this.jUseSSL.setSelected(false);
        this.jUseSSL.setEnabled(false);
        this.jInvalidateSession.setEnabled(false);
        this.jRenegotiate.setEnabled(false);
        Connection localCon = this.con;
        if (localCon == null) {
            return;
        }
        HostPort clientPeer = localCon.getPeerAddress();
        if (clientPeer != null) {
            this.jClientSrc.setText(clientPeer.toString());
            HostPort clientLocal = localCon.getLocalAddress();
            this.jClientDst.setText(clientLocal.toString());
            this.jClientDisconnect.setIcon(ConIcons.getConnectionIcon(this.con));
            this.jClientDisconnect.setEnabled(true);
        }
        if ((target = localCon.getTargetConnection()) == null) {
            return;
        }
        HostPort targetPeer = target.getPeerAddress();
        this.jServerDisconnect.setIcon(ConIcons.getConnectionIcon(target));
        if (targetPeer == null) {
            return;
        }
        ++this.ignoreServerDstChanged;
        this.jServerDst.setText(targetPeer.toString());
        if (target.getConnectStatus() != 0) {
            HostPort targetLocal = target.getLocalAddress();
            if (targetLocal != null) {
                this.jServerSrc.setText(targetLocal.toString());
            }
            this.jServerDisconnect.setEnabled(true);
            if (target.isSSL()) {
                this.jUseSSL.setSelected(true);
                this.jInvalidateSession.setEnabled(true);
                if (target.getConnectStatus() == 2) {
                    this.jRenegotiate.setEnabled(true);
                }
                SSLSession ses = target.getSSLSession();
                this.jCipherSuite.setText(ses.getCipherSuite());
                byte[] id = ses.getId();
                StringBuffer buf = new StringBuffer(id.length * 2);
                for (int i = 0; i < id.length; ++i) {
                    buf.append(Integer.toHexString(id[i] & 0xFF));
                }
                this.jSessionID.setText(buf.toString());
                try {
                    this.jCertificate.setText(ses.getPeerCertificates()[0].toString());
                }
                catch (SSLPeerUnverifiedException spu) {
                    this.jCertificate.setText("<Unverified: " + spu.getMessage() + ">");
                }
            }
        } else {
            this.jServerDst.setEditable(true);
            if (target.getAttribute("SSL") != null) {
                this.jUseSSL.setSelected(true);
            }
            this.jUseSSL.setEnabled(true);
        }
    }

    public void acceptedConnection(Connection con) {
        Connection localCon = this.con;
        if (localCon == con || con.getTargetConnection() == localCon) {
            this.updateDisplay();
        } else {
            con.removeObserver(this);
        }
    }

    public void closedConnection(Connection con) {
        Connection localCon = this.con;
        if (localCon == con || con.getTargetConnection() == localCon) {
            this.updateDisplay();
        } else {
            con.removeObserver(this);
        }
    }

    public void connectingConnection(Connection con) {
        if (this.con == con || con.getTargetConnection() == this.con) {
            this.updateDisplay();
        } else {
            con.removeObserver(this);
        }
    }

    public void createdConnection(Connection con) {
        if (this.con == con || con.getTargetConnection() == this.con) {
            this.updateDisplay();
        } else {
            con.removeObserver(this);
        }
    }

    public void readClosedConnection(Connection con) {
    }

    public void writeClosedConnection(Connection con) {
    }

    public void sslHandshakeCompleted(Connection con) {
        Connection localCon = this.con;
        if (localCon == con || con.getTargetConnection() == localCon) {
            this.updateDisplay();
        } else {
            con.removeObserver(this);
        }
    }

    public void updateMessageFromModel() {
    }

    public void updateModelFromMessage() {
    }

    public void statusChanged(Connection con) {
        Connection localCon = this.con;
        if (localCon == con || con.getTargetConnection() == localCon) {
            this.updateDisplay();
        } else {
            con.removeObserver(this);
        }
    }
}

