/*
 * Decompiled with CFR 0.152.
 */
package webshadow.ui;

import java.util.ArrayList;
import javax.swing.AbstractListModel;
import webshadow.comm.Connection;
import webshadow.comm.ConnectionObserver;

public class ConnectionListModel
extends AbstractListModel
implements ConnectionObserver {
    ArrayList activeConnections = new ArrayList();

    public void fireContentsChanged(int idx) {
        this.fireContentsChanged(this, idx, idx);
    }

    public synchronized int indexOf(Connection con) {
        Connection src;
        int i = this.activeConnections.indexOf(con);
        if (i < 0 && (src = con.getTargetConnection()) != null) {
            i = this.activeConnections.indexOf(src);
        }
        return i;
    }

    public synchronized void delConnection(int idx) {
        if (idx <= 0 || idx >= this.activeConnections.size()) {
            return;
        }
        Connection src = (Connection)this.activeConnections.get(idx);
        Connection dst = src.getTargetConnection();
        src.close();
        dst.close();
    }

    public synchronized void acceptedConnection(Connection con) {
        this.activeConnections.add(con);
        this.fireIntervalAdded(this, this.activeConnections.size() - 1, this.activeConnections.size() - 1);
    }

    private boolean isConnectionClosed(Connection src, Connection dst) {
        return !(src != null && !src.isClosed() && src.getPeerAddress() != null || dst != null && !dst.isClosed() && dst.getConnectStatus() != 0);
    }

    public synchronized void closedConnection(Connection con) {
        Connection src = con;
        Connection dst = null;
        int i = this.activeConnections.indexOf(src);
        if (i < 0) {
            dst = con;
            if ((src = src.getTargetConnection()) != null) {
                i = this.activeConnections.indexOf(src);
            }
        } else {
            dst = src.getTargetConnection();
        }
        if (i >= 0) {
            if (this.isConnectionClosed(src, dst)) {
                this.activeConnections.remove(i);
                this.fireIntervalRemoved(this, i, i);
            } else {
                this.fireContentsChanged(this, i, i);
            }
        }
    }

    public void connectingConnection(Connection con) {
        this.statusChanged(con);
    }

    public void createdConnection(Connection con) {
        this.statusChanged(con);
    }

    public void readClosedConnection(Connection con) {
    }

    public void writeClosedConnection(Connection con) {
    }

    public synchronized void statusChanged(Connection con) {
        Connection src;
        int i = this.activeConnections.indexOf(con);
        if (i < 0 && (src = con.getTargetConnection()) != null) {
            i = this.activeConnections.indexOf(src);
        }
        if (i >= 0) {
            this.fireContentsChanged(this, i, i);
        } else {
            src = con;
            Connection dst = src.getTargetConnection();
            if (dst.getPeerAddress() == null) {
                src = dst;
                dst = con;
            }
            if (!this.isConnectionClosed(src, dst)) {
                this.activeConnections.add(src);
                this.fireIntervalAdded(this, this.activeConnections.size() - 1, this.activeConnections.size() - 1);
            }
        }
    }

    public void sslHandshakeCompleted(Connection con) {
        this.statusChanged(con);
    }

    public synchronized Object getElementAt(int num) {
        if (num < this.activeConnections.size()) {
            return this.activeConnections.get(num);
        }
        return null;
    }

    public synchronized int getSize() {
        return this.activeConnections.size();
    }
}

