/*
 * Decompiled with CFR 0.152.
 */
package webshadow.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import webshadow.comm.Connection;
import webshadow.comm.HostPort;

public class ConnectionCellRenderer
extends DefaultListCellRenderer {
    JPanel biPane = new JPanel();
    JLabel srcLabel;
    JLabel dstLabel;

    public ConnectionCellRenderer() {
        this.biPane.setLayout(new BoxLayout(this.biPane, 0));
        this.srcLabel = new JLabel();
        this.srcLabel.setOpaque(true);
        this.dstLabel = new JLabel();
        this.dstLabel.setOpaque(true);
        this.biPane.add(this.srcLabel);
        this.biPane.add(this.dstLabel);
        this.biPane.setBorder(BorderFactory.createRaisedBevelBorder());
        this.biPane.setOpaque(false);
    }

    public Dimension getCellSize() {
        this.srcLabel.setText("(port) ");
        this.dstLabel.setText("WWW.HOSTSIZE.COM:PORT");
        this.biPane.doLayout();
        return this.biPane.getPreferredSize();
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value instanceof Connection) {
            Color bg = isSelected ? list.getSelectionBackground() : list.getBackground();
            Color fg = isSelected ? list.getSelectionForeground() : list.getForeground();
            this.srcLabel.setBackground(bg);
            this.dstLabel.setBackground(bg);
            Color sslColor = Color.blue;
            Color clearColor = fg;
            Color noneColor = Color.orange;
            Color errorColor = Color.red;
            Connection src = (Connection)value;
            Connection dst = null;
            this.srcLabel.setText("<None> ");
            this.srcLabel.setForeground(noneColor);
            this.dstLabel.setText("<Unconnected>");
            this.dstLabel.setForeground(noneColor);
            if (src != null) {
                HostPort srcAddress = src.getPeerAddress();
                if (srcAddress != null) {
                    this.srcLabel.setText("(" + String.valueOf(srcAddress.getPort()) + ") ");
                }
                if (src.isClosed()) {
                    this.srcLabel.setBackground(bg.darker());
                }
                if (src.isSSL()) {
                    this.srcLabel.setForeground(sslColor);
                } else {
                    this.srcLabel.setForeground(clearColor);
                }
                dst = src.getTargetConnection();
                if (dst != null) {
                    HostPort peerAddr = dst.getPeerAddress();
                    if (peerAddr != null) {
                        this.dstLabel.setText(peerAddr.getHostName() + ":" + peerAddr.getPort());
                    } else {
                        this.dstLabel.setText("<None>");
                    }
                    switch (dst.getConnectStatus()) {
                        case 0: {
                            break;
                        }
                        case -2: 
                        case -1: {
                            this.dstLabel.setForeground(errorColor);
                            break;
                        }
                        case 3: {
                            this.dstLabel.setBackground(bg.darker());
                        }
                        case 1: 
                        case 2: {
                            if (dst.isSSL()) {
                                this.dstLabel.setForeground(sslColor);
                                break;
                            }
                            this.dstLabel.setForeground(clearColor);
                        }
                    }
                }
            }
            return this.biPane;
        }
        return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
    }
}

