/*
 * Decompiled with CFR 0.152.
 */
package webshadow.ui;

import javax.swing.ImageIcon;
import webshadow.comm.Connection;
import webshadow.http.HttpMessage;

public class ConIcons {
    public static ImageIcon[] conIcon;
    public static ImageIcon[] msgIcon;
    public static ImageIcon emptyIcon;
    public static final int STATUS_CLEAR = 0;
    public static final int STATUS_SSL = 1;
    public static final int STATUS_OPEN = 0;
    public static final int STATUS_CLOSED = 2;
    public static final int STATUS_CONNECTING = 4;
    public static final int STATUS_FAILED = 2;
    public static final int STATUS_INPROGRESS = 4;
    public static final int STATUS_NONE = 6;

    public static ImageIcon getMessageIcon(HttpMessage msg) {
        int status = 0;
        if (msg == null) {
            return null;
        }
        if (msg.getRawHeaders() == null || msg.getRawHeaders().length() == 0) {
            return ConIcons.getConnectionIcon(msg.getSrcInfo().getCon());
        }
        if (msg.getSrcInfo().isSSL()) {
            status |= 1;
        }
        if (msg.getSrcInfo().getCon().isClosed()) {
            status |= 2;
        }
        return msgIcon[status];
    }

    public static ImageIcon getMessageProgressIcon(HttpMessage req) {
        int status = 4;
        if (req == null) {
            return null;
        }
        Connection target = req.getSrcInfo().getCon().getTargetConnection();
        if (target.isSSL() || target.getAttribute("SSL") != null) {
            status |= 1;
        }
        if (target.getConnectStatus() != 2) {
            return ConIcons.getConnectionIcon(target);
        }
        return msgIcon[status];
    }

    public static ImageIcon getConnectionIcon(Connection con) {
        int status = 0;
        if (con == null) {
            return null;
        }
        if (con.isSSL() || con.getAttribute("SSL") != null) {
            status |= 1;
        }
        switch (con.getConnectStatus()) {
            case 0: {
                return emptyIcon;
            }
            case 1: {
                status |= 4;
                break;
            }
            case 3: {
                status |= 2;
                break;
            }
            case -2: 
            case -1: {
                status |= 6;
            }
        }
        return conIcon[status];
    }

    static {
        Class myClass = ConIcons.class;
        conIcon = new ImageIcon[8];
        ConIcons.conIcon[0] = new ImageIcon(myClass.getResource("icons/conDir/open.png"));
        ConIcons.conIcon[2] = new ImageIcon(myClass.getResource("icons/conDir/closed.png"));
        ConIcons.conIcon[1] = new ImageIcon(myClass.getResource("icons/conDir/open-ssl.png"));
        ConIcons.conIcon[3] = new ImageIcon(myClass.getResource("icons/conDir/closed-ssl.png"));
        ConIcons.conIcon[4] = new ImageIcon(myClass.getResource("icons/conDir/connecting.png"));
        ConIcons.conIcon[5] = new ImageIcon(myClass.getResource("icons/conDir/connecting-ssl.png"));
        ConIcons.conIcon[6] = new ImageIcon(myClass.getResource("icons/conDir/connect-failed.png"));
        ConIcons.conIcon[7] = new ImageIcon(myClass.getResource("icons/conDir/connect-failed-ssl.png"));
        msgIcon = new ImageIcon[6];
        ConIcons.msgIcon[0] = new ImageIcon(myClass.getResource("icons/msgDir/msg.png"));
        ConIcons.msgIcon[2] = new ImageIcon(myClass.getResource("icons/msgDir/msg-closed.png"));
        ConIcons.msgIcon[1] = new ImageIcon(myClass.getResource("icons/msgDir/msg-ssl.png"));
        ConIcons.msgIcon[3] = new ImageIcon(myClass.getResource("icons/msgDir/msg-closed-ssl.png"));
        ConIcons.msgIcon[4] = new ImageIcon(myClass.getResource("icons/msgDir/receiving.png"));
        ConIcons.msgIcon[5] = new ImageIcon(myClass.getResource("icons/msgDir/receiving-ssl.png"));
        emptyIcon = new ImageIcon(myClass.getResource("icons/empty.png"));
    }
}

