/*
 * Decompiled with CFR 0.152.
 */
package webshadow.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import webshadow.ui.UIUtils;

public class AboutDialog
extends JDialog {
    private static final String WIN_ID = "Windows";
    private static final String WIN_PATH = "rundll32";
    private static final String WIN_FLAG = "url.dll,FileProtocolHandler";
    private static final String[] UNIX_PATH = new String[]{"mozilla", "konqueror", "netscape"};
    private static final String UNIX_FLAG = "-remote openURL";
    private static boolean isWindows = AboutDialog.isWindowsPlatform();
    private JButton jOKButton;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTextPane jTextPane1;

    public AboutDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.jTextPane1.setContentType("text/html");
        this.jTextPane1.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    AboutDialog.displayURL(e.getURL().toString());
                }
            }
        });
        try {
            this.jTextPane1.setPage(this.getClass().getResource("AboutText.html"));
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
        }
        UIUtils.locateOnScreenCenter(this);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jOKButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.setTitle("About Spoxy");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                AboutDialog.this.closeDialog(evt);
            }
        });
        this.jOKButton.setText("OK");
        this.jOKButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AboutDialog.this.jOKButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jOKButton);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jScrollPane1.setPreferredSize(new Dimension(580, 390));
        this.jTextPane1.setEditable(false);
        this.jScrollPane1.setViewportView(this.jTextPane1);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.pack();
    }

    private void jOKButtonActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        new AboutDialog((Frame)new JFrame(), true).show();
    }

    public static void displayURL(String url) {
        block8: {
            boolean windows = AboutDialog.isWindowsPlatform();
            String cmd = null;
            try {
                if (windows) {
                    cmd = "rundll32 url.dll,FileProtocolHandler " + url;
                    Process p = Runtime.getRuntime().exec(cmd);
                    break block8;
                }
                for (int i = 0; i < UNIX_PATH.length; ++i) {
                    int exitCode = -1;
                    cmd = UNIX_PATH[i] + " " + UNIX_FLAG + "(" + url + ")";
                    Process p = Runtime.getRuntime().exec(cmd);
                    try {
                        exitCode = p.waitFor();
                        if (exitCode != 0) {
                            cmd = UNIX_PATH[i] + " " + url;
                            p = Runtime.getRuntime().exec(cmd);
                            exitCode = p.waitFor();
                        }
                    }
                    catch (InterruptedException x) {
                        System.err.println("Error bringing up browser, cmd='" + cmd + "'");
                        System.err.println("Caught: " + x);
                    }
                    if (exitCode != 0) {
                        continue;
                    }
                    break;
                }
            }
            catch (IOException x) {
                System.err.println("Could not invoke browser, command=" + cmd);
                System.err.println("Caught: " + x);
            }
        }
    }

    public static boolean isWindowsPlatform() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith(WIN_ID);
    }
}

