/*
 * Decompiled with CFR 0.152.
 */
package webshadow.log;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import webshadow.comm.Connection;
import webshadow.comm.ConnectionObserverAdapter;
import webshadow.comm.Message;
import webshadow.http.HttpMessage;
import webshadow.http.HttpMessageObserver;
import webshadow.http.HttpRequest;

public class FileLogger
extends ConnectionObserverAdapter
implements HttpMessageObserver {
    static final String LOGFILE_PROPERTY = "Logfile";
    static final String METADATA_FILENAME = "metadata";
    File baseDir = null;
    PrintWriter metaData = null;
    int conNum = 0;

    public synchronized File getLogDir() {
        return this.baseDir;
    }

    public synchronized boolean startLogging(File baseDir) {
        if (!baseDir.isDirectory() && !baseDir.mkdirs()) {
            return false;
        }
        try {
            File metaFile = new File(baseDir, METADATA_FILENAME);
            metaFile.createNewFile();
            this.metaData = new PrintWriter(new FileWriter(metaFile, true));
        }
        catch (IOException ioe) {
            return false;
        }
        this.baseDir = baseDir;
        this.logMetaData("Started logging");
        return true;
    }

    public synchronized void stopLogging() {
        if (this.metaData != null) {
            this.logMetaData("Stopped logging");
            this.metaData.close();
            this.metaData = null;
        }
        this.baseDir = null;
    }

    public synchronized void logMetaData(String meta) {
        this.logMetaData(System.currentTimeMillis(), meta);
    }

    public synchronized void logMetaData(long time, String meta) {
        if (this.metaData != null) {
            this.metaData.println(new Date(time) + " - " + meta);
        }
    }

    public synchronized void connectingConnection(Connection con) {
        if (this.baseDir == null) {
            return;
        }
        try {
            int curNum = ++this.conNum;
            String baseFileName = curNum + "_" + con.getPeerHost() + "_" + String.valueOf(con.getPeerPort());
            File reqLogFile = new File(this.baseDir, baseFileName + ".req");
            File resLogFile = new File(this.baseDir, baseFileName + ".res");
            this.logMetaData("Starting connection [" + baseFileName + "]: " + con.toString());
            ConnectionLog conLog = new ConnectionLog();
            conLog.baseFileName = baseFileName;
            conLog.reqLog = new FileOutputStream(reqLogFile);
            conLog.resLog = new FileOutputStream(resLogFile);
            con.setAttribute(LOGFILE_PROPERTY, conLog);
        }
        catch (IOException ioe) {
            this.logMetaData("Error: " + ioe.getMessage());
        }
    }

    public synchronized void createdConnection(Connection con) {
        ConnectionLog conLog = (ConnectionLog)con.getAttribute(LOGFILE_PROPERTY);
        if (conLog != null && this.metaData != null) {
            this.logMetaData(con.getOpenTime(), "Connected [" + conLog.baseFileName + "]: " + con.toString());
        }
    }

    public synchronized void sslHandshakeCompleted(Connection con) {
        ConnectionLog conLog = (ConnectionLog)con.getAttribute(LOGFILE_PROPERTY);
        if (conLog != null && this.metaData != null) {
            String cert;
            SSLSession ses = con.getSSLSession();
            String cipherSuite = ses.getCipherSuite();
            byte[] id = ses.getId();
            StringBuffer buf = new StringBuffer(id.length * 2);
            for (int i = 0; i < id.length; ++i) {
                buf.append(Integer.toHexString(id[i] & 0xFF));
            }
            try {
                cert = ses.getPeerCertificates()[0].toString();
            }
            catch (SSLPeerUnverifiedException sue) {
                cert = "<Unverified: " + sue.getMessage() + ">";
            }
            this.logMetaData(ses.getCreationTime(), "SSL Handshake [" + conLog.baseFileName + "]: " + "id=" + buf.toString() + ", cipher=" + cipherSuite + ", cert=" + cert);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closedConnection(Connection con) {
        ConnectionLog conLog = (ConnectionLog)con.getAttribute(LOGFILE_PROPERTY);
        if (conLog != null) {
            switch (con.getConnectStatus()) {
                case -2: {
                    this.logMetaData("Unknown Host [" + conLog.baseFileName + "]");
                    break;
                }
                case -1: {
                    this.logMetaData("Connection Refused [" + conLog.baseFileName + "]");
                    break;
                }
                default: {
                    this.logMetaData("Closed Connection [" + conLog.baseFileName + "]");
                }
            }
            ConnectionLog connectionLog = conLog;
            synchronized (connectionLog) {
                try {
                    if (conLog.reqLog != null) {
                        conLog.reqLog.close();
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                try {
                    if (conLog.resLog != null) {
                        conLog.resLog.close();
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                conLog.reqLog = null;
                conLog.resLog = null;
            }
        }
    }

    public void readClosedConnection(Connection con) {
    }

    public void writeClosedConnection(Connection con) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void headers(HttpMessage msg, boolean hasBody, int state) {
        block11: {
            Message.Info info = msg.getSrcInfo();
            Connection con = info.getCon();
            ConnectionLog conLog = null;
            if (con != null) {
                conLog = (ConnectionLog)con.getAttribute(LOGFILE_PROPERTY);
            }
            if (conLog == null && (con = (info = msg.getDstInfo()).getCon()) != null) {
                conLog = (ConnectionLog)con.getAttribute(LOGFILE_PROPERTY);
            }
            try {
                if (conLog == null) break block11;
                ConnectionLog connectionLog = conLog;
                synchronized (connectionLog) {
                    if (msg instanceof HttpRequest) {
                        this.logMetaData(info.getBeginTime(), "Request [" + conLog.baseFileName + "] (" + info.getSeq() + ")");
                        if (conLog.reqLog != null) {
                            conLog.reqLog.write(msg.getRawHeaders().getBytes());
                        }
                    } else {
                        this.logMetaData(info.getBeginTime(), "Response [" + conLog.baseFileName + "] (" + info.getSeq() + ")");
                        if (conLog.resLog != null) {
                            conLog.resLog.write(msg.getRawHeaders().getBytes());
                        }
                    }
                }
            }
            catch (IOException ioe) {
                this.logMetaData("Error logging message: " + ioe.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logMessageData(HttpMessage msg, byte[] buf, int off, int len) {
        block11: {
            Message.Info info = msg.getSrcInfo();
            Connection con = info.getCon();
            ConnectionLog conLog = null;
            if (con != null) {
                conLog = (ConnectionLog)con.getAttribute(LOGFILE_PROPERTY);
            }
            if (conLog == null && (con = (info = msg.getDstInfo()).getCon()) != null) {
                conLog = (ConnectionLog)con.getAttribute(LOGFILE_PROPERTY);
            }
            try {
                if (conLog == null) break block11;
                ConnectionLog connectionLog = conLog;
                synchronized (connectionLog) {
                    if (msg instanceof HttpRequest) {
                        if (conLog.reqLog != null) {
                            conLog.reqLog.write(buf, off, len);
                        }
                    } else if (conLog.resLog != null) {
                        conLog.resLog.write(buf, off, len);
                    }
                }
            }
            catch (IOException ioe) {
                this.logMetaData("Error logging message data: " + ioe.getMessage());
            }
        }
    }

    public void startBodyPart(HttpMessage msg, int seq, int state) {
    }

    public void startBodyPartData(HttpMessage msg, int len, int state) {
    }

    public void bodyPrefixData(HttpMessage msg, byte[] buf, int off, int len, int state) {
        this.logMessageData(msg, buf, off, len);
    }

    public void bodyPartData(HttpMessage msg, byte[] buf, int off, int len, int state) {
        this.logMessageData(msg, buf, off, len);
    }

    public void bodySuffixData(HttpMessage msg, byte[] buf, int off, int len, int state) {
        this.logMessageData(msg, buf, off, len);
    }

    public void endBodyPart(HttpMessage msg, boolean hasMoreBody, int state) {
    }

    static class ConnectionLog {
        String baseFileName;
        OutputStream reqLog;
        OutputStream resLog;

        ConnectionLog() {
        }
    }
}

