/*
 * Decompiled with CFR 0.152.
 */
package webshadow.js;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import webshadow.http.HttpRequest;
import webshadow.http.HttpResponse;
import webshadow.js.JSHttpRequest;
import webshadow.js.JSHttpResponse;
import webshadow.ui.SpoxyPrefs;

public class RuleContext {
    static final int ACTION_NONE = 0;
    static final int ACTION_HOLD = 1;
    static final int ACTION_PASS = 2;
    static final int ACTION_DELETE = 3;
    Scriptable scope;
    ErrorReporter errorReporter;
    ArrayList funcs = new ArrayList();
    ArrayList funcNames = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RuleContext(InputStream in, String fileName) throws IOException {
        this.errorReporter = new SpoxyErrorReporter();
        try {
            Context cx = Context.enter();
            cx.setErrorReporter(this.errorReporter);
            this.scope = cx.initStandardObjects(null);
            this.scope.put("ACTION_NONE", this.scope, (Object)new Integer(0));
            this.scope.put("ACTION_HOLD", this.scope, (Object)new Integer(1));
            this.scope.put("ACTION_PASS", this.scope, (Object)new Integer(2));
            this.scope.put("ACTION_DELETE", this.scope, (Object)new Integer(3));
            this.scope.put("alert", this.scope, (Object)new JSAlerter());
            InputStreamReader inr = new InputStreamReader(in);
            Script scr = cx.compileReader(this.scope, (Reader)inr, fileName, 1, null);
            try {
                scr.exec(cx, this.scope);
            }
            catch (Exception err) {
                this.handleError(err);
            }
            this.findFunctions();
        }
        finally {
            Context.exit();
        }
    }

    private void findFunctions() {
        this.funcs.clear();
        this.funcNames.clear();
        Object[] ids = this.scope.getIds();
        for (int i = 0; i < ids.length; ++i) {
            Object prop;
            String name;
            if (!(ids[i] instanceof String) || (name = (String)ids[i]).equals("alert") || !((prop = this.scope.get(name, this.scope)) instanceof Function)) continue;
            this.funcs.add(prop);
            this.funcNames.add(name);
        }
    }

    public void handleError(Exception err) {
        SpoxyErrorReporter.reportError("Exception in JavaScript", err.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int callFunction(int funcIndex, HttpRequest req, HttpResponse res, boolean wasHeld) {
        if (funcIndex < 0 || funcIndex >= this.funcs.size()) {
            return 0;
        }
        try {
            Context cx = Context.enter();
            cx.setErrorReporter(this.errorReporter);
            Function func = (Function)this.funcs.get(funcIndex);
            Object[] args = new Object[3];
            if (req != null) {
                args[0] = new JSHttpRequest(req);
            }
            if (res != null) {
                args[1] = new JSHttpResponse(res);
            }
            args[2] = new Boolean(wasHeld);
            Object result = func.call(cx, this.scope, this.scope, args);
            if (result instanceof Scriptable) {
                result = ((Scriptable)result).getDefaultValue(Number.class);
            }
            if (result instanceof Number) {
                int n = ((Number)result).intValue();
                return n;
            }
            if (result instanceof String) {
                String str = (String)result;
                if (str.equalsIgnoreCase("HOLD") || str.equalsIgnoreCase("ACTION_HOLD")) {
                    int n = 1;
                    return n;
                }
                if (str.equalsIgnoreCase("PASS") || str.equalsIgnoreCase("ACTION_PASS")) {
                    int n = 2;
                    return n;
                }
                if (str.equalsIgnoreCase("DELETE") || str.equalsIgnoreCase("ACTION_DELETE")) {
                    int n = 3;
                    return n;
                }
                int n = Integer.parseInt(str);
                return n;
            }
            if (result instanceof Boolean) {
                boolean hold = (Boolean)result;
                if (hold) {
                    int n = 1;
                    return n;
                }
                int n = 2;
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception err) {
            this.handleError(err);
            int n = 0;
            return n;
        }
        finally {
            Context.exit();
        }
    }

    public List getFunctionNames() {
        return this.funcNames;
    }

    static class SpoxyErrorReporter
    implements ErrorReporter {
        static String getErrorMessage(String prefix, String message, String sourceName, int line, String lineSource, int lineOffset) {
            StringBuffer buf = new StringBuffer(prefix.length() + message.length() + sourceName.length() + lineSource.length() * 2 + 128);
            buf.append(prefix);
            buf.append(" in file ");
            buf.append(sourceName);
            buf.append(", line ");
            buf.append(line);
            buf.append(":\n");
            buf.append(lineSource);
            buf.append("\n");
            for (int i = 0; i < lineOffset - 1; ++i) {
                buf.append("_");
            }
            buf.append("/\\\n");
            buf.append(message);
            return buf.toString();
        }

        public static String reportError(String prefix, String message, String sourceName, int line, String lineSource, int lineOffset) {
            String errMsg = SpoxyErrorReporter.getErrorMessage(prefix, message, sourceName, line, lineSource, lineOffset);
            String errTitle = "JavaScript " + prefix;
            SpoxyErrorReporter.reportError(errTitle, errMsg);
            return errMsg;
        }

        public static void reportError(String title, String msg) {
            final String fMsg = msg;
            final String fTitle = title;
            if (SpoxyPrefs.getBoolean(6)) {
                new Thread(){

                    public void run() {
                        JOptionPane.showMessageDialog(null, fMsg, fTitle, 0);
                    }
                }.start();
            } else {
                System.err.println(fMsg);
            }
        }

        public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
            SpoxyErrorReporter.reportError("Error", message, sourceName, line, lineSource, lineOffset);
        }

        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
            return new EvaluatorException(SpoxyErrorReporter.reportError("Runtime Error", message, sourceName, line, lineSource, lineOffset));
        }

        public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
            SpoxyErrorReporter.reportError("Warning", message, sourceName, line, lineSource, lineOffset);
        }
    }

    class JSAlerter
    extends ScriptableObject
    implements Function {
        JSAlerter() {
        }

        public Object call(Context context, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
            String msg = "Alert!";
            if (args.length > 0 && args[0] != null) {
                msg = args[0].toString();
            }
            final String fmsg = msg;
            new Thread(){

                public void run() {
                    JOptionPane.showMessageDialog(null, fmsg);
                }
            }.start();
            return Boolean.TRUE;
        }

        public Scriptable construct(Context context, Scriptable scriptable, Object[] obj) throws JavaScriptException {
            return null;
        }

        public String getClassName() {
            return "Function";
        }
    }
}

