/*
 * Decompiled with CFR 0.152.
 */
package webshadow.js;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.TimeZone;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NotAFunctionException;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.Scriptable;
import webshadow.http.HttpResponse;
import webshadow.http.ResponseParsedHeaders;
import webshadow.js.AbstractScriptable;

public class JSResCookies
implements Scriptable {
    HttpResponse res;
    ResponseParsedHeaders headers;
    private Scriptable parent;
    private Scriptable prototype;

    public JSResCookies(HttpResponse res) {
        this.res = res;
        this.headers = res.getRespHeaders();
    }

    public String getClassName() {
        return "ResponseCookies";
    }

    public void delete(String str) {
        for (int i = 0; i < this.headers.cookies.size(); ++i) {
            ResponseParsedHeaders.ResCookie cookie = (ResponseParsedHeaders.ResCookie)this.headers.cookies.get(i);
            if (!cookie.name.equals(str)) continue;
            this.headers.cookies.remove(i);
            --i;
        }
        this.headers.composeCookies();
        this.res.composeHeaders();
    }

    public void delete(int idx) {
        if (idx >= 0 && idx < this.headers.cookies.size()) {
            this.headers.cookies.remove(idx);
            this.headers.composeCookies();
            this.res.composeHeaders();
        }
    }

    public Object get(String str, Scriptable scope) {
        if (str.equals("length")) {
            return new Integer(this.headers.cookies.size());
        }
        ResponseParsedHeaders.ResCookie cookie = this.headers.getCookie(str);
        if (cookie == null) {
            return NOT_FOUND;
        }
        return cookie.value;
    }

    public Object get(int idx, Scriptable scope) {
        if (idx >= 0 && idx < this.headers.cookies.size()) {
            ResponseParsedHeaders.ResCookie cookie = (ResponseParsedHeaders.ResCookie)this.headers.cookies.get(idx);
            return new JSResCookie(cookie);
        }
        return NOT_FOUND;
    }

    public Object getDefaultValue(Class hint) {
        if (hint == Scriptable.class) {
            return this;
        }
        if (hint == String.class) {
            return this.headers.getHeaderValue("Set-Cookie");
        }
        if (hint == Number.class) {
            return new Integer(this.headers.cookies.size());
        }
        if (hint == Boolean.class) {
            return Boolean.TRUE;
        }
        return "[ResponseCookies]";
    }

    public Object[] getIds() {
        Object[] ids = new Object[this.headers.cookies.size()];
        for (int i = 0; i < ids.length; ++i) {
            ResponseParsedHeaders.ResCookie cookie = (ResponseParsedHeaders.ResCookie)this.headers.cookies.get(i);
            ids[i] = cookie.name;
        }
        return ids;
    }

    public boolean has(int idx, Scriptable scope) {
        return idx >= 0 && idx < this.headers.cookies.size();
    }

    public boolean has(String str, Scriptable scope) {
        return this.headers.getCookie(str) != null;
    }

    public void put(String str, Scriptable scope, Object obj) {
        ResponseParsedHeaders.ResCookie cookie = this.headers.getCookie(str);
        if (cookie == null) {
            cookie = obj != null ? new ResponseParsedHeaders.ResCookie(str.trim() + "=" + Context.toString((Object)obj).trim()) : new ResponseParsedHeaders.ResCookie(str.trim());
            this.headers.cookies.add(cookie);
        } else if (obj != null) {
            cookie.set(str.trim() + "=" + Context.toString((Object)obj).trim());
        } else {
            cookie.value = null;
        }
        this.headers.composeCookies();
        this.res.composeHeaders();
    }

    public void put(int idx, Scriptable scope, Object obj) {
        ResponseParsedHeaders.ResCookie cookie;
        if (idx < 0 || idx > this.headers.cookies.size()) {
            return;
        }
        if (obj instanceof JSResCookie) {
            JSResCookie other = (JSResCookie)obj;
            cookie = new ResponseParsedHeaders.ResCookie(other.toString());
        } else if (obj != null) {
            String str = Context.toString((Object)obj).trim();
            cookie = new ResponseParsedHeaders.ResCookie(str);
        } else {
            return;
        }
        if (idx == this.headers.cookies.size()) {
            this.headers.cookies.add(cookie);
        } else {
            this.headers.cookies.set(idx, cookie);
        }
        this.headers.composeCookies();
        this.res.composeHeaders();
    }

    public boolean hasInstance(Scriptable value) {
        for (Scriptable proto = value.getPrototype(); proto != null; proto = proto.getPrototype()) {
            if (!proto.equals(this)) continue;
            return true;
        }
        return false;
    }

    public void setParentScope(Scriptable parent) {
        this.parent = parent;
    }

    public void setPrototype(Scriptable prototype) {
        this.prototype = prototype;
    }

    public Scriptable getParentScope() {
        return this.parent;
    }

    public Scriptable getPrototype() {
        return this.prototype;
    }

    class JSResCookie
    extends AbstractScriptable {
        ResponseParsedHeaders.ResCookie cookie;

        JSResCookie(ResponseParsedHeaders.ResCookie cookie1) {
            this.cookie = cookie1;
            this.namedProps.add("name");
            this.propActions.add(new AbstractScriptable.PropActionAdapter(){

                public Object get(Scriptable scope) {
                    return JSResCookie.this.cookie.name;
                }

                public void put(Scriptable scope, Object val) {
                    JSResCookie.this.cookie.name = val != null ? Context.toString((Object)val).trim() : null;
                    ((JSResCookie)JSResCookie.this).JSResCookies.this.headers.composeCookies();
                    ((JSResCookie)JSResCookie.this).JSResCookies.this.res.composeHeaders();
                }
            });
            this.namedProps.add("value");
            this.propActions.add(new AbstractScriptable.PropActionAdapter(){

                public Object get(Scriptable scope) {
                    return JSResCookie.this.cookie.value;
                }

                public void put(Scriptable scope, Object val) {
                    JSResCookie.this.cookie.value = val != null ? Context.toString((Object)val).trim() : null;
                    ((JSResCookie)JSResCookie.this).JSResCookies.this.headers.composeCookies();
                    ((JSResCookie)JSResCookie.this).JSResCookies.this.res.composeHeaders();
                }
            });
            this.namedProps.add("path");
            this.propActions.add(new AbstractScriptable.PropActionAdapter(){

                public Object get(Scriptable scope) {
                    return JSResCookie.this.cookie.path;
                }

                public void put(Scriptable scope, Object val) {
                    JSResCookie.this.cookie.path = val != null ? Context.toString((Object)val).trim() : null;
                    ((JSResCookie)JSResCookie.this).JSResCookies.this.headers.composeCookies();
                    ((JSResCookie)JSResCookie.this).JSResCookies.this.res.composeHeaders();
                }
            });
            this.namedProps.add("domain");
            this.propActions.add(new AbstractScriptable.PropActionAdapter(){

                public Object get(Scriptable scope) {
                    return JSResCookie.this.cookie.domain;
                }

                public void put(Scriptable scope, Object val) {
                    JSResCookie.this.cookie.domain = val != null ? Context.toString((Object)val).trim() : null;
                    ((JSResCookie)JSResCookie.this).JSResCookies.this.headers.composeCookies();
                    ((JSResCookie)JSResCookie.this).JSResCookies.this.res.composeHeaders();
                }
            });
            this.namedProps.add("secure");
            this.propActions.add(new AbstractScriptable.PropActionAdapter(){

                public Object get(Scriptable scope) {
                    return new Boolean(JSResCookie.this.cookie.secure);
                }

                public void put(Scriptable scope, Object val) {
                    JSResCookie.this.cookie.secure = val instanceof Boolean ? (Boolean)val : (val instanceof Number ? ((Number)val).intValue() != 0 : (val != null ? Context.toString((Object)val).equalsIgnoreCase("true") : false));
                    ((JSResCookie)JSResCookie.this).JSResCookies.this.headers.composeCookies();
                    ((JSResCookie)JSResCookie.this).JSResCookies.this.res.composeHeaders();
                }
            });
            this.namedProps.add("expires");
            this.propActions.add(new AbstractScriptable.PropActionAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object get(Scriptable scope) {
                    if (JSResCookie.this.cookie.expires >= 0L) {
                        Context cx = Context.enter();
                        try {
                            Object[] args = new Object[]{new Long(JSResCookie.this.cookie.expires)};
                            Scriptable scriptable = cx.newObject(scope, "Date", args);
                            return scriptable;
                        }
                        catch (PropertyException pe) {
                            pe.printStackTrace();
                        }
                        catch (NotAFunctionException nfe) {
                            nfe.printStackTrace();
                        }
                        catch (JavaScriptException jse) {
                            jse.printStackTrace();
                        }
                        finally {
                            Context.exit();
                        }
                    }
                    return Scriptable.NOT_FOUND;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void put(Scriptable scope, Object val) {
                    if (val instanceof Scriptable) {
                        Scriptable sval = (Scriptable)val;
                        Object func = sval.get("getUTCMilliseconds", scope);
                        if (func instanceof Function) {
                            Context cx = Context.enter();
                            try {
                                val = ((Function)func).call(cx, scope, sval, new Object[0]);
                            }
                            catch (JavaScriptException jse) {
                                jse.printStackTrace();
                            }
                            finally {
                                Context.exit();
                            }
                        } else {
                            val = sval.getDefaultValue(class$java$lang$Number == null ? (class$java$lang$Number = JSResCookies.class$("java.lang.Number")) : class$java$lang$Number);
                        }
                    }
                    if (val instanceof Number) {
                        JSResCookie.this.cookie.expires = ((Number)val).longValue();
                    } else if (val != null) {
                        DateFormat format = DateFormat.getInstance();
                        format.setLenient(true);
                        format.setTimeZone(TimeZone.getTimeZone("GMT"));
                        try {
                            JSResCookie.this.cookie.expires = format.parse(Context.toString((Object)val)).getTime();
                        }
                        catch (ParseException pe) {
                            JSResCookie.this.cookie.expires = -1L;
                        }
                    } else {
                        JSResCookie.this.cookie.expires = -1L;
                    }
                    ((JSResCookie)JSResCookie.this).JSResCookies.this.headers.composeCookies();
                    ((JSResCookie)JSResCookie.this).JSResCookies.this.res.composeHeaders();
                }
            });
        }

        public String getClassName() {
            return "ResCookie";
        }

        public Object getDefaultValue(Class hint) {
            return this.cookie.toString();
        }
    }
}

