/*
 * Decompiled with CFR 0.152.
 */
package webshadow.js;

import org.mozilla.javascript.Scriptable;
import webshadow.http.HttpRequest;
import webshadow.http.ParsedHeaders;
import webshadow.http.RequestParsedHeaders;
import webshadow.js.AbstractScriptable;

public class JSReqCookies
implements Scriptable {
    HttpRequest req;
    RequestParsedHeaders headers;
    private Scriptable parent;
    private Scriptable prototype;

    public JSReqCookies(HttpRequest req) {
        this.req = req;
        this.headers = req.getReqHeaders();
    }

    public String getClassName() {
        return "Headers";
    }

    public void delete(String str) {
        this.headers.setCookieValue(str, null);
        this.headers.composeCookies();
        this.req.composeHeaders();
    }

    public void delete(int idx) {
        if (idx >= 0 && idx < this.headers.cookies.size()) {
            this.headers.cookies.remove(idx);
            this.headers.composeCookies();
            this.req.composeHeaders();
        }
    }

    public Object get(String str, Scriptable scope) {
        if (str.equals("length")) {
            return new Integer(this.headers.cookies.size());
        }
        String val = this.headers.getCookie(str);
        if (val == null) {
            return NOT_FOUND;
        }
        return val;
    }

    public Object get(int idx, Scriptable scope) {
        if (idx >= 0 && idx < this.headers.cookies.size()) {
            ParsedHeaders.NameValue nv = (ParsedHeaders.NameValue)this.headers.cookies.get(idx);
            return new JSReqCookie(nv);
        }
        return NOT_FOUND;
    }

    public Object getDefaultValue(Class hint) {
        if (hint == Scriptable.class) {
            return this;
        }
        if (hint == String.class) {
            return this.headers.getHeaderValue("Cookie");
        }
        if (hint == Number.class) {
            return new Integer(this.headers.cookies.size());
        }
        if (hint == Boolean.class) {
            return Boolean.TRUE;
        }
        return "[RequestCookies]";
    }

    public Object[] getIds() {
        Object[] ids = new Object[this.headers.cookies.size()];
        for (int i = 0; i < ids.length; ++i) {
            ParsedHeaders.NameValue nv = (ParsedHeaders.NameValue)this.headers.cookies.get(i);
            ids[i] = nv.name;
        }
        return ids;
    }

    public boolean has(int idx, Scriptable scope) {
        return idx >= 0 && idx < this.headers.cookies.size();
    }

    public boolean has(String str, Scriptable scope) {
        return this.headers.getCookie(str) != null;
    }

    public void put(String str, Scriptable scope, Object obj) {
        this.headers.setCookieValue(str, obj.toString().trim());
        this.headers.composeCookies();
        this.req.composeHeaders();
    }

    public void put(int idx, Scriptable scope, Object obj) {
        ParsedHeaders.NameValue nv;
        if (idx < 0 || idx > this.headers.cookies.size()) {
            return;
        }
        if (obj instanceof JSReqCookie) {
            JSReqCookie cookie = (JSReqCookie)obj;
            nv = new ParsedHeaders.NameValue(cookie.nv.name, cookie.nv.value);
        } else {
            String str = obj.toString().trim();
            int col = str.indexOf(61);
            if (col < 0) {
                return;
            }
            String name = str.substring(0, col).trim();
            String val = str.substring(col + 1).trim();
            nv = new ParsedHeaders.NameValue(name, val);
        }
        if (idx == this.headers.cookies.size()) {
            this.headers.cookies.add(nv);
        } else {
            this.headers.cookies.set(idx, nv);
        }
        this.headers.composeCookies();
        this.req.composeHeaders();
    }

    public boolean hasInstance(Scriptable value) {
        for (Scriptable proto = value.getPrototype(); proto != null; proto = proto.getPrototype()) {
            if (!proto.equals(this)) continue;
            return true;
        }
        return false;
    }

    public void setParentScope(Scriptable parent) {
        this.parent = parent;
    }

    public void setPrototype(Scriptable prototype) {
        this.prototype = prototype;
    }

    public Scriptable getParentScope() {
        return this.parent;
    }

    public Scriptable getPrototype() {
        return this.prototype;
    }

    class JSReqCookie
    extends AbstractScriptable {
        ParsedHeaders.NameValue nv;

        JSReqCookie(ParsedHeaders.NameValue nv1) {
            this.nv = nv1;
            this.namedProps.add("name");
            this.propActions.add(new AbstractScriptable.PropActionAdapter(){

                public Object get(Scriptable scope) {
                    return JSReqCookie.this.nv.name;
                }

                public void put(Scriptable scope, Object val) {
                    JSReqCookie.this.nv.name = val.toString().trim();
                    ((JSReqCookie)JSReqCookie.this).JSReqCookies.this.headers.composeCookies();
                    ((JSReqCookie)JSReqCookie.this).JSReqCookies.this.req.composeHeaders();
                }
            });
            this.namedProps.add("value");
            this.propActions.add(new AbstractScriptable.PropActionAdapter(){

                public Object get(Scriptable scope) {
                    return JSReqCookie.this.nv.value;
                }

                public void put(Scriptable scope, Object val) {
                    JSReqCookie.this.nv.value = val.toString().trim();
                    ((JSReqCookie)JSReqCookie.this).JSReqCookies.this.headers.composeCookies();
                    ((JSReqCookie)JSReqCookie.this).JSReqCookies.this.req.composeHeaders();
                }
            });
        }

        public String getClassName() {
            return "ReqCookie";
        }

        public Object getDefaultValue(Class hint) {
            return this.nv.name + "=" + this.nv.value;
        }
    }
}

