/*
 * Decompiled with CFR 0.152.
 */
package webshadow.js;

import java.io.IOException;
import java.util.ArrayList;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import webshadow.http.HttpRequest;
import webshadow.js.AbstractScriptable;

public class JSParams
implements Scriptable {
    ArrayList params;
    HttpRequest req;
    private Scriptable parent;
    private Scriptable prototype;

    public JSParams(HttpRequest req) {
        this.req = req;
        this.params = req.parseParams();
    }

    public String getClassName() {
        return "Params";
    }

    public void delete(String str) {
        for (int i = 0; i < this.params.size(); ++i) {
            HttpRequest.Param param = (HttpRequest.Param)this.params.get(i);
            if (!param.name.equals(str)) continue;
            this.params.remove(i);
            --i;
        }
        this.req.composeParams(this.params);
        this.req.composeHeaders();
    }

    public void delete(int idx) {
        if (idx >= 0 && idx < this.params.size()) {
            this.params.remove(idx);
            this.req.composeParams(this.params);
            this.req.composeHeaders();
        }
    }

    public Object get(String str, Scriptable scope) {
        if (str.equals("length")) {
            return new Integer(this.params.size());
        }
        for (int i = 0; i < this.params.size(); ++i) {
            HttpRequest.Param param = (HttpRequest.Param)this.params.get(i);
            if (!param.name.equals(str)) continue;
            return new JSParam(param);
        }
        return NOT_FOUND;
    }

    public Object get(int idx, Scriptable scope) {
        if (idx >= 0 && idx < this.params.size()) {
            HttpRequest.Param param = (HttpRequest.Param)this.params.get(idx);
            return new JSParam(param);
        }
        return NOT_FOUND;
    }

    public Object getDefaultValue(Class hint) {
        if (hint == Scriptable.class) {
            return this;
        }
        if (hint == String.class) {
            String method = this.req.getReqHeaders().method;
            if (method == null) {
                return null;
            }
            if (method.equalsIgnoreCase("POST")) {
                try {
                    return new String(this.req.getBody(true));
                }
                catch (IOException ioe) {
                    try {
                        return new String(this.req.getBody(false));
                    }
                    catch (IOException ioe2) {
                        return null;
                    }
                }
            }
            return this.req.getReqHeaders().getQuery();
        }
        if (hint == Number.class) {
            return new Integer(this.params.size());
        }
        if (hint == Boolean.class) {
            return Boolean.TRUE;
        }
        return "[object Params]";
    }

    public Object[] getIds() {
        Object[] ids = new Object[this.params.size()];
        for (int i = 0; i < ids.length; ++i) {
            HttpRequest.Param param = (HttpRequest.Param)this.params.get(i);
            ids[i] = param.name;
        }
        return ids;
    }

    public boolean has(int idx, Scriptable scope) {
        return idx >= 0 && idx < this.params.size();
    }

    public boolean has(String str, Scriptable scope) {
        for (int i = 0; i < this.params.size(); ++i) {
            HttpRequest.Param param = (HttpRequest.Param)this.params.get(i);
            if (!param.name.equals(str)) continue;
            return true;
        }
        return false;
    }

    public void put(String str, Scriptable scope, Object obj) {
        HttpRequest.Param param = null;
        for (int i = 0; i < this.params.size(); ++i) {
            HttpRequest.Param test = (HttpRequest.Param)this.params.get(i);
            if (!test.name.equals(str)) continue;
            param = test;
            break;
        }
        if (param == null) {
            if (obj != null) {
                param = new HttpRequest.Param();
                param.name = str;
                param.value = Context.toString((Object)obj).getBytes();
                param.hasValue = true;
                this.params.add(param);
            }
        } else if (obj != null) {
            param.value = Context.toString((Object)obj).getBytes();
            param.hasValue = true;
        } else {
            param.value = null;
            param.hasValue = false;
        }
        this.req.composeParams(this.params);
        this.req.composeHeaders();
    }

    public void put(int idx, Scriptable scope, Object obj) {
        if (idx < 0 || idx > this.params.size()) {
            return;
        }
        if (obj instanceof JSParam) {
            JSParam other = (JSParam)obj;
            HttpRequest.Param param = new HttpRequest.Param(other.param);
            if (idx < this.params.size()) {
                this.params.set(idx, param);
            } else {
                this.params.add(param);
            }
        } else if (obj != null) {
            String str = Context.toString((Object)obj).trim();
            if (idx < this.params.size()) {
                ArrayList newParam = new ArrayList(1);
                HttpRequest.parseFormUrlEncoded(str, newParam, 0);
                this.params.set(idx, newParam.get(0));
            } else {
                HttpRequest.parseFormUrlEncoded(str, this.params, 0);
            }
        } else if (idx < this.params.size()) {
            this.params.remove(idx);
        } else {
            return;
        }
        this.req.composeParams(this.params);
        this.req.composeHeaders();
    }

    public boolean hasInstance(Scriptable value) {
        for (Scriptable proto = value.getPrototype(); proto != null; proto = proto.getPrototype()) {
            if (!proto.equals(this)) continue;
            return true;
        }
        return false;
    }

    public void setParentScope(Scriptable parent) {
        this.parent = parent;
    }

    public void setPrototype(Scriptable prototype) {
        this.prototype = prototype;
    }

    public Scriptable getParentScope() {
        return this.parent;
    }

    public Scriptable getPrototype() {
        return this.prototype;
    }

    class JSParam
    extends AbstractScriptable {
        HttpRequest.Param param;

        JSParam(HttpRequest.Param param1) {
            this.param = param1;
            this.namedProps.add("name");
            this.propActions.add(new AbstractScriptable.PropActionAdapter(){

                public Object get(Scriptable scope) {
                    return JSParam.this.param.name;
                }

                public void put(Scriptable scope, Object val) {
                    JSParam.this.param.name = val != null ? Context.toString((Object)val).trim() : null;
                    ((JSParam)JSParam.this).JSParams.this.req.composeParams(((JSParam)JSParam.this).JSParams.this.params);
                    ((JSParam)JSParam.this).JSParams.this.req.composeHeaders();
                }
            });
            this.namedProps.add("contentType");
            this.propActions.add(new AbstractScriptable.PropActionAdapter(){

                public Object get(Scriptable scope) {
                    return JSParam.this.param.contentType;
                }

                public void put(Scriptable scope, Object val) {
                    JSParam.this.param.contentType = val != null ? Context.toString((Object)val).trim() : null;
                    ((JSParam)JSParam.this).JSParams.this.req.composeParams(((JSParam)JSParam.this).JSParams.this.params);
                    ((JSParam)JSParam.this).JSParams.this.req.composeHeaders();
                }
            });
            this.namedProps.add("fileName");
            this.propActions.add(new AbstractScriptable.PropActionAdapter(){

                public Object get(Scriptable scope) {
                    return JSParam.this.param.fileName;
                }

                public void put(Scriptable scope, Object val) {
                    JSParam.this.param.fileName = val != null ? Context.toString((Object)val).trim() : null;
                    ((JSParam)JSParam.this).JSParams.this.req.composeParams(((JSParam)JSParam.this).JSParams.this.params);
                    ((JSParam)JSParam.this).JSParams.this.req.composeHeaders();
                }
            });
            this.namedProps.add("value");
            this.propActions.add(new AbstractScriptable.PropActionAdapter(){

                public Object get(Scriptable scope) {
                    return new String(JSParam.this.param.value);
                }

                public void put(Scriptable scope, Object val) {
                    if (val != null) {
                        JSParam.this.param.value = Context.toString((Object)val).getBytes();
                        JSParam.this.param.hasValue = true;
                    } else {
                        JSParam.this.param.value = null;
                        JSParam.this.param.hasValue = false;
                    }
                    ((JSParam)JSParam.this).JSParams.this.req.composeParams(((JSParam)JSParam.this).JSParams.this.params);
                    ((JSParam)JSParam.this).JSParams.this.req.composeHeaders();
                }
            });
            this.namedProps.add("location");
            this.propActions.add(new AbstractScriptable.PropActionAdapter(){

                public Object get(Scriptable scope) {
                    switch (JSParam.this.param.location) {
                        case 1: {
                            return "BODY";
                        }
                        case 0: {
                            return "QUERY";
                        }
                    }
                    return "ERROR";
                }

                public void put(Scriptable scope, Object val) {
                    String str;
                    JSParam.this.param.location = 0;
                    if (val != null && (str = Context.toString((Object)val).trim()).equalsIgnoreCase("BODY")) {
                        JSParam.this.param.location = 1;
                    }
                    ((JSParam)JSParam.this).JSParams.this.req.composeParams(((JSParam)JSParam.this).JSParams.this.params);
                    ((JSParam)JSParam.this).JSParams.this.req.composeHeaders();
                }
            });
        }

        public Object getDefaultValue(Class hint) {
            if (hint == (class$org$mozilla$javascript$Scriptable == null ? (class$org$mozilla$javascript$Scriptable = JSParams.class$("org.mozilla.javascript.Scriptable")) : class$org$mozilla$javascript$Scriptable)) {
                return this;
            }
            return new String(this.param.value);
        }

        public String getClassName() {
            return "Param";
        }
    }
}

