/*
 * Decompiled with CFR 0.152.
 */
package webshadow.js;

import java.io.IOException;
import java.util.zip.ZipException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import webshadow.http.HttpMessage;
import webshadow.js.AbstractScriptable;
import webshadow.js.JSConnection;
import webshadow.js.JSHeaders;

public class JSHttpMessage
extends AbstractScriptable {
    HttpMessage msg;
    ReadBody bodyReader = new ReadBody();

    JSHttpMessage(HttpMessage msg1) {
        this.msg = msg1;
        this.namedProps.add("headers");
        this.propActions.add(new AbstractScriptable.PropActionAdapter(){

            public Object get(Scriptable scope) {
                return new JSHeaders(JSHttpMessage.this.msg);
            }

            public void put(Scriptable scope, Object val) {
                if (val instanceof JSHeaders) {
                    JSHeaders hdrs = (JSHeaders)val;
                    JSHttpMessage.this.msg.setRawHeaders(hdrs.msg.getRawHeaders());
                } else {
                    JSHttpMessage.this.msg.setRawHeaders(val.toString());
                }
                JSHttpMessage.this.msg.parseHeaders();
            }
        });
        this.namedProps.add("body");
        this.propActions.add(new AbstractScriptable.PropActionAdapter(){

            public Object get(Scriptable scope) {
                try {
                    return new String(JSHttpMessage.this.msg.getBody(true));
                }
                catch (ZipException ze) {
                    try {
                        return new String(JSHttpMessage.this.msg.getBody(false));
                    }
                    catch (ZipException zipException) {
                        return Scriptable.NOT_FOUND;
                    }
                }
            }

            public void put(Scriptable scope, Object val) {
                if (val instanceof byte[]) {
                    JSHttpMessage.this.msg.setBody((byte[])val, true);
                } else if (val != null) {
                    String str = Context.toString((Object)val);
                    JSHttpMessage.this.msg.setBody(str.getBytes(), true);
                }
            }
        });
        this.namedProps.add("hasMoreBody");
        this.propActions.add(new AbstractScriptable.PropActionAdapter(){

            public Object get(Scriptable scope) {
                return new Boolean(JSHttpMessage.this.msg.hasMoreBody());
            }
        });
        this.namedProps.add("readBody");
        this.propActions.add(new AbstractScriptable.PropActionAdapter(){

            public Object get(Scriptable scope) {
                return JSHttpMessage.this.bodyReader;
            }
        });
        this.namedProps.add("contentLength");
        this.propActions.add(new AbstractScriptable.PropActionAdapter(){

            public Object get(Scriptable scope) {
                return new Integer(JSHttpMessage.this.msg.getParsedHeaders().contentLength);
            }
        });
        this.namedProps.add("contentType");
        this.propActions.add(new AbstractScriptable.PropActionAdapter(){

            public Object get(Scriptable scope) {
                return JSHttpMessage.this.msg.getParsedHeaders().contentType;
            }
        });
        this.namedProps.add("boundary");
        this.propActions.add(new AbstractScriptable.PropActionAdapter(){

            public Object get(Scriptable scope) {
                return JSHttpMessage.this.msg.getParsedHeaders().boundary;
            }
        });
        this.namedProps.add("src");
        this.propActions.add(new AbstractScriptable.PropActionAdapter(){

            public Object get(Scriptable scope) {
                return new JSConnection(JSHttpMessage.this.msg.getSrcInfo().getCon());
            }
        });
        this.namedProps.add("dst");
        this.propActions.add(new AbstractScriptable.PropActionAdapter(){

            public Object get(Scriptable scope) {
                return new JSConnection(JSHttpMessage.this.msg.getSrcInfo().getCon().getTargetConnection());
            }

            public void put(Scriptable scope, Object val) {
            }
        });
    }

    public String getClassName() {
        return "HttpMessage";
    }

    public Object getDefaultValue(Class hint) {
        if (hint == Scriptable.class) {
            return this;
        }
        return "[object HttpMessage]";
    }

    class ReadBody
    extends ScriptableObject
    implements Function {
        ReadBody() {
        }

        public Object call(Context context, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
            if (JSHttpMessage.this.msg == null) {
                return Boolean.FALSE;
            }
            if (!JSHttpMessage.this.msg.hasMoreBody()) {
                return Boolean.FALSE;
            }
            try {
                JSHttpMessage.this.msg.readBody();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return Boolean.TRUE;
        }

        public Scriptable construct(Context context, Scriptable scriptable, Object[] obj) throws JavaScriptException {
            return null;
        }

        public String getClassName() {
            return "Function";
        }
    }
}

