/*
 * Decompiled with CFR 0.152.
 */
package webshadow.js;

import org.mozilla.javascript.Scriptable;
import webshadow.http.HttpMessage;
import webshadow.http.ParsedHeaders;
import webshadow.js.JSHeader;

public class JSHeaders
implements Scriptable {
    HttpMessage msg;
    ParsedHeaders headers;
    private Scriptable parent;
    private Scriptable prototype;

    public JSHeaders(HttpMessage msg) {
        this.msg = msg;
        if (msg != null) {
            this.headers = msg.getParsedHeaders();
        }
    }

    public String getClassName() {
        return "Headers";
    }

    public void delete(String str) {
        if (this.msg == null) {
            return;
        }
        this.headers.setHeaderValue(str, null);
        this.msg.composeHeaders();
    }

    public void delete(int idx) {
        if (this.msg == null) {
            return;
        }
        if (idx >= 0 && idx < this.headers.headers.size()) {
            this.headers.headers.remove(idx);
            this.msg.composeHeaders();
        }
    }

    public Object get(String str, Scriptable scope) {
        if (this.msg == null) {
            return NOT_FOUND;
        }
        if (str.equals("length")) {
            return new Integer(this.headers.headers.size());
        }
        String val = this.headers.getHeaderValue(str);
        if (val == null) {
            return NOT_FOUND;
        }
        return val;
    }

    public Object get(int idx, Scriptable scope) {
        if (this.msg == null) {
            return NOT_FOUND;
        }
        if (idx >= 0 && idx < this.headers.headers.size()) {
            ParsedHeaders.NameValue nv = (ParsedHeaders.NameValue)this.headers.headers.get(idx);
            return new JSHeader(this.msg, nv);
        }
        return NOT_FOUND;
    }

    public Object getDefaultValue(Class hint) {
        if (hint == Scriptable.class) {
            return this;
        }
        if (this.msg == null) {
            return null;
        }
        if (hint == String.class) {
            return this.msg.getRawHeaders();
        }
        if (hint == Number.class) {
            return new Integer(this.headers.headers.size());
        }
        if (hint == Boolean.class) {
            return Boolean.TRUE;
        }
        return "[Headers]";
    }

    public Object[] getIds() {
        if (this.msg == null) {
            return new Object[0];
        }
        Object[] ids = new Object[this.headers.headers.size()];
        for (int i = 0; i < ids.length; ++i) {
            ParsedHeaders.NameValue nv = (ParsedHeaders.NameValue)this.headers.headers.get(i);
            ids[i] = nv.name;
        }
        return ids;
    }

    public boolean has(int idx, Scriptable scope) {
        if (this.msg == null) {
            return false;
        }
        return idx >= 0 && idx < this.headers.headers.size();
    }

    public boolean has(String str, Scriptable scope) {
        if (this.msg == null) {
            return false;
        }
        return this.headers.getHeaderValue(str) != null;
    }

    public void put(String str, Scriptable scope, Object obj) {
        if (this.msg == null) {
            return;
        }
        this.headers.setHeaderValue(str, obj.toString().trim());
        this.msg.composeHeaders();
    }

    public void put(int idx, Scriptable scope, Object obj) {
        ParsedHeaders.NameValue nv;
        if (this.msg == null) {
            return;
        }
        if (idx < 0 || idx > this.headers.headers.size()) {
            return;
        }
        if (obj instanceof JSHeader) {
            JSHeader hdr = (JSHeader)obj;
            nv = new ParsedHeaders.NameValue(hdr.nv.name, hdr.nv.value);
        } else {
            String str = obj.toString().trim();
            int col = str.indexOf(58);
            if (col < 0) {
                return;
            }
            String name = str.substring(0, col).trim();
            String val = str.substring(col + 1).trim();
            nv = new ParsedHeaders.NameValue(name, val);
        }
        if (idx == this.headers.headers.size()) {
            this.headers.headers.add(nv);
        } else {
            this.headers.headers.set(idx, nv);
        }
        this.msg.composeHeaders();
    }

    public boolean hasInstance(Scriptable value) {
        for (Scriptable proto = value.getPrototype(); proto != null; proto = proto.getPrototype()) {
            if (!proto.equals(this)) continue;
            return true;
        }
        return false;
    }

    public void setParentScope(Scriptable parent) {
        this.parent = parent;
    }

    public void setPrototype(Scriptable prototype) {
        this.prototype = prototype;
    }

    public Scriptable getParentScope() {
        return this.parent;
    }

    public Scriptable getPrototype() {
        return this.prototype;
    }
}

