/*
 * Decompiled with CFR 0.152.
 */
package webshadow.js;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import webshadow.comm.Connection;
import webshadow.comm.HostPort;
import webshadow.js.AbstractScriptable;
import webshadow.js.JSAddress;

public class JSConnection
extends AbstractScriptable {
    Connection con;
    Closer closer = new Closer();

    public JSConnection(Connection con1) {
        this.con = con1;
        this.namedProps.add("peerAddress");
        this.propActions.add(new AbstractScriptable.PropActionAdapter(){

            public Object get(Scriptable scope) {
                HostPort peerAddr = JSConnection.this.con.getPeerAddress();
                if (peerAddr != null) {
                    return new JSAddress(peerAddr);
                }
                return null;
            }

            public void put(Scriptable scope, Object val) {
                if (JSConnection.this.con.wasConnected()) {
                    return;
                }
                if (val == null) {
                    JSConnection.this.con.setPeerAddress(null);
                }
                HostPort addr = JSConnection.this.con.getPeerAddress();
                if (val instanceof JSAddress) {
                    if (addr != null) {
                        addr.set(((JSAddress)val).addr);
                    } else {
                        addr = new HostPort(((JSAddress)val).addr);
                    }
                } else if (addr != null) {
                    addr.set(Context.toString((Object)val));
                } else {
                    addr = new HostPort(Context.toString((Object)val));
                }
            }
        });
        this.namedProps.add("localAddress");
        this.propActions.add(new AbstractScriptable.PropActionAdapter(){

            public Object get(Scriptable scope) {
                HostPort localAddr = JSConnection.this.con.getLocalAddress();
                if (localAddr != null) {
                    return new JSAddress(localAddr);
                }
                return null;
            }

            public void put(Scriptable scope, Object val) {
            }
        });
        this.namedProps.add("close");
        this.propActions.add(new AbstractScriptable.PropActionAdapter(){

            public Object get(Scriptable scope) {
                return JSConnection.this.closer;
            }

            public void put(Scriptable scope, Object val) {
            }
        });
        this.namedProps.add("isConnected");
        this.propActions.add(new AbstractScriptable.PropActionAdapter(){

            public Object get(Scriptable scope) {
                return new Boolean(JSConnection.this.con.getConnectStatus() == 2 || JSConnection.this.con.getConnectStatus() == 1);
            }

            public void put(Scriptable scope, Object val) {
            }
        });
        this.namedProps.add("wasConnected");
        this.propActions.add(new AbstractScriptable.PropActionAdapter(){

            public Object get(Scriptable scope) {
                return new Boolean(JSConnection.this.con.wasConnected());
            }

            public void put(Scriptable scope, Object val) {
            }
        });
        this.namedProps.add("ssl");
        this.propActions.add(new AbstractScriptable.PropActionAdapter(){

            public Object get(Scriptable scope) {
                if (JSConnection.this.con.wasConnected()) {
                    return new Boolean(JSConnection.this.con.isSSL());
                }
                return new Boolean(JSConnection.this.con.getAttribute("SSL") != null);
            }

            public void put(Scriptable scope, Object val) {
                if (JSConnection.this.con.wasConnected()) {
                    return;
                }
                HostPort peerAddr = JSConnection.this.con.getPeerAddress();
                if (Context.toBoolean((Object)val)) {
                    JSConnection.this.con.setAttribute("SSL", Boolean.TRUE);
                    if (peerAddr != null && peerAddr.getPort() == 80) {
                        peerAddr.setPort(443);
                    }
                } else {
                    JSConnection.this.con.removeAttribute("SSL");
                    if (peerAddr != null && peerAddr.getPort() == 443) {
                        peerAddr.setPort(80);
                    }
                }
            }
        });
        this.namedProps.add("sslSession");
        this.propActions.add(new AbstractScriptable.PropActionAdapter(){

            public Object get(Scriptable scope) {
                if (!JSConnection.this.con.isSSL()) {
                    return Scriptable.NOT_FOUND;
                }
                return JSConnection.this.con.getSSLSession();
            }

            public void put(Scriptable scope, Object val) {
            }
        });
    }

    public String getClassName() {
        return "Connection";
    }

    public Object getDefaultValue(Class hint) {
        if (hint == Scriptable.class) {
            return this;
        }
        if (hint == Boolean.class) {
            switch (this.con.getConnectStatus()) {
                case 1: 
                case 2: {
                    return Boolean.TRUE;
                }
            }
            return Boolean.FALSE;
        }
        return this.con.toString();
    }

    class Closer
    extends ScriptableObject
    implements Function {
        Closer() {
        }

        public Object call(Context context, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
            JSConnection.this.con.close();
            return null;
        }

        public Scriptable construct(Context context, Scriptable scriptable, Object[] obj) throws JavaScriptException {
            return null;
        }

        public String getClassName() {
            return "Function";
        }
    }
}

