/*
 * Decompiled with CFR 0.152.
 */
package webshadow.http;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import webshadow.http.ParsedHeaders;

public class ResponseParsedHeaders
extends ParsedHeaders {
    public static Pattern respLinePattern = Pattern.compile("(\\S+)\\s+(\\S+)\\s+(\\S.*\\S)");
    public static Pattern respCookiePattern;
    public String protocol;
    public int code;
    public String codeMsg;
    public ArrayList cookies;

    public ResponseParsedHeaders() {
    }

    public void reset() {
        super.reset();
        this.cookies = new ArrayList();
        this.protocol = null;
        this.code = 0;
        this.codeMsg = null;
    }

    public ResponseParsedHeaders(String rawHeaders) {
        super(rawHeaders);
        if (this.reqLine == null) {
            return;
        }
        Matcher respLineMatcher = respLinePattern.matcher(this.reqLine);
        if (respLineMatcher.matches()) {
            this.protocol = respLineMatcher.group(1);
            String codeStr = respLineMatcher.group(2);
            this.codeMsg = respLineMatcher.group(3);
            try {
                this.code = Integer.parseInt(codeStr);
                if (this.code < 200 && this.code >= 100) {
                    this.contentLength = 0;
                } else {
                    switch (this.code) {
                        case 204: 
                        case 304: {
                            this.contentLength = 0;
                        }
                    }
                }
            }
            catch (NumberFormatException e) {
                this.code = -1;
                this.good = false;
                this.parseErrors.add("Invalid response code: " + codeStr);
            }
        }
    }

    public void parseSignificantHeader(String name, String value, boolean add) {
        super.parseSignificantHeader(name, value, add);
        if (name.equalsIgnoreCase("Set-Cookie")) {
            if (!add) {
                this.cookies.clear();
            }
            if (value != null) {
                this.cookies.add(new ResCookie(value));
            }
        }
    }

    public ResCookie getCookie(String name) {
        Iterator it = this.cookies.iterator();
        while (it.hasNext()) {
            ResCookie cookie = (ResCookie)it.next();
            if (!cookie.name.equalsIgnoreCase(name)) continue;
            return cookie;
        }
        return null;
    }

    public void composeCookies() {
        if (this.cookies.isEmpty()) {
            this.setHeaderValue("Set-Cookie", null);
        } else {
            ParsedHeaders.NameValue hdr;
            int h = 0;
            Iterator it = this.cookies.iterator();
            ResCookie cookie = (ResCookie)it.next();
            for (h = 0; h < this.headers.size(); ++h) {
                hdr = (ParsedHeaders.NameValue)this.headers.get(h);
                if (!hdr.name.equalsIgnoreCase("Set-Cookie")) continue;
                hdr.value = cookie.toString();
                if (!it.hasNext()) break;
                cookie = (ResCookie)it.next();
            }
            if (h < this.headers.size()) {
                while (h < this.headers.size()) {
                    hdr = (ParsedHeaders.NameValue)this.headers.get(h);
                    if (hdr.name.equalsIgnoreCase("Set-Cookie")) {
                        this.headers.remove(h);
                        --h;
                    }
                    ++h;
                }
            } else {
                this.headers.add(new ParsedHeaders.NameValue("Set-Cookie", cookie.toString()));
                while (it.hasNext()) {
                    cookie = (ResCookie)it.next();
                    this.headers.add(new ParsedHeaders.NameValue("Set-Cookie", cookie.toString()));
                }
            }
        }
    }

    public String getReqLineString() {
        if (this.protocol != null) {
            return this.protocol + " " + String.valueOf(this.code) + " " + this.codeMsg + "\r\n";
        }
        return this.reqLine;
    }

    public static class ResCookie {
        public static DateFormat dateFormat = DateFormat.getInstance();
        public String name;
        public String value;
        public long expires = -1L;
        public String path;
        public String domain;
        public boolean secure = false;

        public ResCookie() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(String cookie) {
            String[] parts = cookie.split(";");
            if (parts.length > 0) {
                int eq = parts[0].indexOf(61);
                if (eq >= 0) {
                    this.name = parts[0].substring(0, eq);
                    this.value = parts[0].substring(eq + 1);
                } else {
                    this.name = parts[0];
                }
                for (int i = 1; i < parts.length; ++i) {
                    String str = parts[i].trim();
                    if (str.startsWith("expires=")) {
                        String exp = str.substring("expires=".length());
                        try {
                            DateFormat dateFormat = ResCookie.dateFormat;
                            synchronized (dateFormat) {
                                this.expires = ResCookie.dateFormat.parse(exp).getTime();
                            }
                        }
                        catch (ParseException pe) {}
                        continue;
                    }
                    if (str.startsWith("path=")) {
                        this.path = str.substring("path=".length());
                        continue;
                    }
                    if (str.startsWith("domain=")) {
                        this.domain = str.substring("domain=".length());
                        continue;
                    }
                    if (!str.equals("secure")) continue;
                    this.secure = true;
                }
            }
        }

        public ResCookie(String cookie) {
            this.set(cookie);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            StringBuffer buf = new StringBuffer(this.name);
            if (this.value != null) {
                buf.append("=" + this.value);
            }
            if (this.path != null) {
                buf.append("; path=" + this.path);
            }
            if (this.expires >= 0L) {
                DateFormat dateFormat = ResCookie.dateFormat;
                synchronized (dateFormat) {
                    buf.append("; expires=" + ResCookie.dateFormat.format(new Date(this.expires)));
                }
            }
            if (this.domain != null) {
                buf.append("; domain=" + this.domain);
            }
            if (this.secure) {
                buf.append("; secure");
            }
            return buf.toString();
        }

        static {
            dateFormat.setLenient(true);
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
    }
}

