/*
 * Decompiled with CFR 0.152.
 */
package webshadow.http;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import webshadow.http.ParsedHeaders;

public class RequestParsedHeaders
extends ParsedHeaders {
    public String method;
    public String action;
    public int queryStart;
    public String protocol;
    public String host;
    public int port;
    public ArrayList cookies;
    public int defaultPort;
    public static Pattern reqLinePattern = Pattern.compile("(\\S+)\\s+(\\S+)\\s+(\\S+)");
    public static Pattern connectPattern = Pattern.compile("([-_a-zA-Z0-9.]+)(:([0-9]+))");
    public static Pattern proxyHttpPattern = Pattern.compile("http://([-_a-zA-Z0-9.]+)(:([0-9]+))?(.*)");
    public static Pattern hostPattern = Pattern.compile("([-_a-zA-Z0-9.]+)(:([0-9]+))?");
    public static Pattern cookiePattern = Pattern.compile("([^=]*)=([^;]*);?\\s*");
    public boolean ignoreHostHeader;
    public boolean outProxy;

    public void setAction(String action) {
        this.action = action;
        this.queryStart = action != null ? action.indexOf(63) : -1;
    }

    public String getPath() {
        if (this.queryStart < 0) {
            return this.action;
        }
        return this.action.substring(0, this.queryStart);
    }

    public void setPath(String path) {
        if (path == null) {
            path = "/";
        }
        String query = this.getQuery();
        if (this.queryStart < 0) {
            this.action = path;
        } else {
            this.action = path + "?" + query;
            this.queryStart = path.length();
        }
    }

    public String getQuery() {
        if (this.queryStart < 0) {
            return null;
        }
        return this.action.substring(this.queryStart + 1);
    }

    public void setQuery(String query) {
        if (query == null) {
            this.action = this.getPath();
            this.queryStart = -1;
        } else {
            this.action = this.getPath() + "?" + query;
        }
    }

    public void setCookieValue(String name, String value) {
        boolean first = true;
        for (int i = 0; i < this.cookies.size(); ++i) {
            ParsedHeaders.NameValue hdr = (ParsedHeaders.NameValue)this.cookies.get(i);
            if (!hdr.name.equalsIgnoreCase(name)) continue;
            if (first && value != null) {
                hdr.value = value;
                first = false;
                continue;
            }
            this.cookies.remove(i);
            --i;
        }
        if (first && value != null) {
            this.cookies.add(new ParsedHeaders.NameValue(name, value));
        }
    }

    public void parseSignificantHeader(String name, String value, boolean add) {
        block7: {
            block6: {
                block8: {
                    block9: {
                        super.parseSignificantHeader(name, value, add);
                        if (this.host != null || !name.equalsIgnoreCase("Host")) break block6;
                        if (value == null) break block7;
                        Matcher hostMatcher = hostPattern.matcher(value);
                        if (!hostMatcher.matches()) break block8;
                        this.host = hostMatcher.group(1);
                        if (hostMatcher.start(2) == -1) break block9;
                        String portStr = hostMatcher.group(3);
                        try {
                            this.port = Integer.parseInt(portStr);
                        }
                        catch (NumberFormatException e) {}
                        break block7;
                    }
                    if (this.port == 0) break block7;
                    this.port = this.defaultPort;
                    break block7;
                }
                this.good = false;
                this.parseErrors.add("Invalid host header: " + value);
                break block7;
            }
            if (name.equalsIgnoreCase("Cookie")) {
                if (!add) {
                    this.cookies.clear();
                }
                if (value != null) {
                    value = value.replaceAll("\\s+", "");
                    Matcher cookieMatcher = cookiePattern.matcher(value);
                    while (cookieMatcher.find()) {
                        this.cookies.add(new ParsedHeaders.NameValue(cookieMatcher.group(1), cookieMatcher.group(2)));
                    }
                }
            }
        }
    }

    public void parseAllSignificantHeaders() {
        this.cookies.clear();
        super.parseAllSignificantHeaders();
    }

    public void reset() {
        super.reset();
        this.queryStart = -1;
        this.action = null;
        this.method = null;
        this.protocol = null;
        this.host = null;
        this.cookies = new ArrayList();
        this.port = 0;
        this.defaultPort = 80;
        this.ignoreHostHeader = false;
        this.outProxy = false;
    }

    public RequestParsedHeaders(String rawHeaders, int defaultPort) {
        super(rawHeaders);
        if (this.contentLength < 0) {
            this.contentLength = 0;
        }
        this.defaultPort = defaultPort;
        if (this.port == 0) {
            this.port = defaultPort;
        }
        if (this.reqLine == null) {
            return;
        }
        Matcher reqLineMatcher = reqLinePattern.matcher(this.reqLine);
        if (reqLineMatcher.matches()) {
            this.method = reqLineMatcher.group(1);
            this.action = reqLineMatcher.group(2);
            this.protocol = reqLineMatcher.group(3);
            if (this.method.equalsIgnoreCase("CONNECT")) {
                Matcher connectMatcher = connectPattern.matcher(this.action);
                if (connectMatcher.lookingAt()) {
                    this.host = connectMatcher.group(1);
                    if (connectMatcher.start(2) != -1) {
                        String portStr = connectMatcher.group(3);
                        try {
                            this.port = Integer.parseInt(portStr);
                        }
                        catch (NumberFormatException e) {}
                    } else {
                        this.port = 443;
                    }
                } else {
                    this.good = false;
                    this.parseErrors.add("Invalid CONNECT syntax");
                }
            } else {
                Matcher proxyHttpMatcher = proxyHttpPattern.matcher(this.action);
                if (proxyHttpMatcher.matches()) {
                    this.host = proxyHttpMatcher.group(1);
                    if (proxyHttpMatcher.start(2) != -1) {
                        String portStr = proxyHttpMatcher.group(3);
                        try {
                            this.port = Integer.parseInt(portStr);
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                    this.action = proxyHttpMatcher.group(4);
                }
            }
        } else {
            this.action = this.reqLine.trim();
            this.good = false;
            this.parseErrors.add("Invalid request line");
        }
        if (this.action != null) {
            this.queryStart = this.action.indexOf(63);
        }
    }

    public String getCookie(String name) {
        Iterator it = this.cookies.iterator();
        while (it.hasNext()) {
            ParsedHeaders.NameValue cookie = (ParsedHeaders.NameValue)it.next();
            if (!cookie.name.equalsIgnoreCase(name)) continue;
            return cookie.value;
        }
        return null;
    }

    public void composeCookies() {
        if (this.cookies.isEmpty()) {
            this.setHeaderValue("Cookie", null);
        } else {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < this.cookies.size() - 1; ++i) {
                ParsedHeaders.NameValue cookie = (ParsedHeaders.NameValue)this.cookies.get(i);
                buf.append(cookie.name + "=" + cookie.value + "; ");
            }
            ParsedHeaders.NameValue cookie = (ParsedHeaders.NameValue)this.cookies.get(this.cookies.size() - 1);
            buf.append(cookie.name + "=" + cookie.value + "\r\n");
            this.setHeaderValue("Cookie", buf.toString());
        }
    }

    public String getReqLineString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.method == null ? "" : this.method + " ");
        if (this.outProxy && !this.method.equalsIgnoreCase("CONNECT")) {
            buf.append("http://" + this.host);
            if (this.port != 80) {
                buf.append(":" + String.valueOf(this.port));
            }
        }
        buf.append(this.action == null ? "" : this.action);
        if (this.protocol != null) {
            buf.append(" " + this.protocol);
        }
        buf.append("\r\n");
        return buf.toString();
    }

    public boolean shouldAddContentLengthHeader() {
        if (this.method == null) {
            return false;
        }
        if (this.method.equalsIgnoreCase("GET") && this.contentLength == 0) {
            return false;
        }
        return super.shouldAddContentLengthHeader();
    }

    protected String getSpecialHeaders() {
        StringBuffer buf = new StringBuffer();
        if (this.ignoreHostHeader && this.host != null) {
            buf.append("Host: " + this.host);
            if (this.port != this.defaultPort) {
                buf.append(":" + String.valueOf(this.port));
            }
            buf.append("\r\n");
        }
        buf.append(super.getSpecialHeaders());
        return buf.toString();
    }

    protected boolean ignoreHeader(String header) {
        return super.ignoreHeader(header) || this.ignoreHostHeader && header.equalsIgnoreCase("Host");
    }
}

