/*
 * Decompiled with CFR 0.152.
 */
package webshadow.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParsedHeaders {
    static final int DEFAULT_CONTENT_LENGTH = -1;
    public String reqLine;
    public ArrayList headers;
    public String contentType;
    public String boundary;
    public int contentLength;
    public boolean chunked;
    public boolean multipart;
    public boolean good;
    public List parseErrors;
    public static Pattern headerPattern = Pattern.compile("(\\S+):\\s*(.*)");
    public static Pattern contentBoundaryPattern = Pattern.compile("([^;]+);\\s*boundary=(\\S+)", 2);
    public boolean ignoreContentLengthHeader;

    public void reset() {
        this.contentLength = -1;
        this.chunked = false;
        this.multipart = false;
        this.boundary = null;
        this.contentType = null;
        this.good = true;
        this.headers = new ArrayList();
        this.parseErrors = new ArrayList();
        this.ignoreContentLengthHeader = true;
    }

    public ParsedHeaders() {
        this.reset();
    }

    public void parseSignificantHeader(String name, String value, boolean add) {
        if (name.equalsIgnoreCase("Content-Length")) {
            if (value != null) {
                try {
                    this.contentLength = Integer.parseInt(value);
                }
                catch (NumberFormatException nfe) {
                    this.good = false;
                    this.parseErrors.add("Invalid content-length: " + value);
                }
            } else {
                this.contentLength = -1;
            }
        } else if (name.equalsIgnoreCase("Transfer-Encoding")) {
            this.chunked = value != null && value.equalsIgnoreCase("chunked");
        } else if (name.equalsIgnoreCase("Content-Type")) {
            this.contentType = value;
            if (value != null) {
                Matcher contentBoundaryMatcher = contentBoundaryPattern.matcher(this.contentType);
                if (contentBoundaryMatcher.matches()) {
                    this.contentType = contentBoundaryMatcher.group(1).trim();
                    this.boundary = contentBoundaryMatcher.group(2).trim();
                    if (this.boundary.startsWith("\"") && this.boundary.endsWith("\"")) {
                        this.boundary = this.boundary.substring(1, this.boundary.length() - 1);
                    }
                }
                this.multipart = this.contentType.startsWith("multipart/");
            } else {
                this.multipart = false;
            }
        }
    }

    public void parseAllSignificantHeaders() {
        Iterator it = this.headers.iterator();
        while (it.hasNext()) {
            NameValue hdr = (NameValue)it.next();
            this.parseSignificantHeader(hdr.name, hdr.value, true);
        }
    }

    public ParsedHeaders(String rawHeaders) {
        this.reset();
        if (rawHeaders == null) {
            this.good = false;
            this.parseErrors.add("Null header section");
            return;
        }
        try {
            BufferedReader in = new BufferedReader(new StringReader(rawHeaders));
            this.reqLine = in.readLine();
            String line = in.readLine();
            while (line != null && !line.equals("")) {
                Matcher headerMatcher = headerPattern.matcher(line);
                if (!headerMatcher.matches()) {
                    this.good = false;
                    this.parseErrors.add("Invalid header line: " + line);
                } else {
                    this.headers.add(new NameValue(headerMatcher.group(1), headerMatcher.group(2).trim()));
                }
                line = in.readLine();
            }
            this.parseAllSignificantHeaders();
        }
        catch (IOException e) {
            this.good = false;
            this.parseErrors.add("Unexpected end of headers");
        }
    }

    public String getReqLineString() {
        return this.reqLine;
    }

    public boolean shouldAddContentLengthHeader() {
        return this.ignoreContentLengthHeader && this.contentLength >= 0;
    }

    protected String getSpecialHeaders() {
        StringBuffer buf = new StringBuffer();
        if (this.shouldAddContentLengthHeader()) {
            buf.append("Content-Length: " + String.valueOf(this.contentLength) + "\r\n");
        }
        if (this.chunked) {
            buf.append("Transfer-Encoding: chunked\r\n");
        }
        return buf.toString();
    }

    protected boolean ignoreHeader(String header) {
        return this.ignoreContentLengthHeader && header.equalsIgnoreCase("Content-Length") || header.equalsIgnoreCase("Transfer-Encoding");
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String reqLine = this.getReqLineString();
        if (reqLine != null && reqLine.length() > 0) {
            buf.append(reqLine);
        }
        Iterator it = this.headers.iterator();
        while (it.hasNext()) {
            NameValue hdr = (NameValue)it.next();
            if (this.ignoreHeader(hdr.name)) continue;
            buf.append(hdr.name + ": " + hdr.value + "\r\n");
        }
        if (buf.length() > 0) {
            String special = this.getSpecialHeaders();
            if (special != null) {
                buf.append(special);
            }
            buf.append("\r\n");
            return buf.toString();
        }
        return "";
    }

    public List getParseErrors() {
        return this.parseErrors;
    }

    public String getHeaderValue(String header) {
        StringBuffer val = null;
        Iterator it = this.headers.iterator();
        while (it.hasNext()) {
            NameValue hdr = (NameValue)it.next();
            if (!hdr.name.equalsIgnoreCase(header)) continue;
            if (val == null) {
                val = new StringBuffer(hdr.value);
                continue;
            }
            val.append(", ");
            val.append(hdr.value);
        }
        if (val != null) {
            return val.toString();
        }
        return null;
    }

    public void setHeaderValue(String name, String value) {
        boolean first = true;
        for (int i = 0; i < this.headers.size(); ++i) {
            NameValue hdr = (NameValue)this.headers.get(i);
            if (!hdr.name.equalsIgnoreCase(name)) continue;
            if (first && value != null) {
                hdr.value = value;
                first = false;
                continue;
            }
            this.headers.remove(i);
            --i;
        }
        if (first && value != null) {
            this.headers.add(new NameValue(name, value));
        }
        this.parseSignificantHeader(name, value, false);
    }

    public String normalizeHeader(String header) {
        if (header == null) {
            return null;
        }
        if (header.length() == 1) {
            return header.toUpperCase();
        }
        return header.substring(0, 1).toUpperCase() + header.substring(1).toLowerCase();
    }

    public static class NameValue {
        public String name;
        public String value;

        public NameValue(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

