/*
 * Decompiled with CFR 0.152.
 */
package webshadow.http;

import java.io.IOException;
import webshadow.comm.Connection;
import webshadow.http.HttpMessage;
import webshadow.http.HttpMessageObserver;
import webshadow.http.HttpRequest;
import webshadow.http.ResponseParsedHeaders;

public class HttpResponse
extends HttpMessage {
    public ResponseParsedHeaders respHeaders;
    HttpRequest req;

    public ResponseParsedHeaders getRespHeaders() {
        return this.respHeaders;
    }

    public void parseHeaders() {
        this.respHeaders = new ResponseParsedHeaders(this.rawHeaders);
        this.headers = this.respHeaders;
    }

    public void readFrom(Connection con) throws IOException {
        try {
            super.readFrom(con);
        }
        catch (IOException ioe) {
            if (!con.wasConnected()) {
                this.respHeaders.code = 503;
                this.respHeaders.protocol = "HTTP/1.0";
                this.respHeaders.codeMsg = "Connection refused";
                this.respHeaders.setHeaderValue("Server", "HttpProxy");
                this.respHeaders.setHeaderValue("Content-Type", "text/html");
                this.composeHeaders();
                this.setBody("<html><head><title>HttpProxy: Connection Refused</title></head><body><h1>HttpProxy: Connection refused</h1><p>The connection to  the server was refused</p></body></html>".getBytes());
            }
            throw ioe;
        }
        finally {
            try {
                if (con.getSentQueue().getSize() > 0) {
                    HttpRequest req = (HttpRequest)con.getSentQueue().get();
                    if (this.respHeaders.code == 100) {
                        con.getSentQueue().unget(req);
                    }
                    this.setRequest(req);
                }
            }
            catch (InterruptedException ie) {}
        }
    }

    public HttpResponse(HttpMessageObserver readObserver) {
        super(readObserver, null);
    }

    public HttpResponse() {
    }

    public void setRequest(HttpRequest req) {
        this.req = req;
        if (req != null && req.reqHeaders != null && req.reqHeaders.method != null && req.reqHeaders.method.equalsIgnoreCase("HEAD")) {
            this.hasMoreBody = false;
            this.observeMessageReadDone(this.messageObservers);
        }
    }

    public HttpRequest getRequest() {
        return this.req;
    }
}

