/*
 * Decompiled with CFR 0.152.
 */
package webshadow.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import webshadow.comm.Connection;
import webshadow.comm.HostPort;
import webshadow.http.HttpMessage;
import webshadow.http.HttpMessageObserver;
import webshadow.http.ParsedHeaders;
import webshadow.http.RequestParsedHeaders;
import webshadow.util.ByteSearch;

public class HttpRequest
extends HttpMessage {
    public static final int LOCATION_QUERY = 0;
    public static final int LOCATION_BODY = 1;
    public static final byte[] CRLF2 = new byte[]{13, 10, 13, 10};
    public static Pattern queryParamPattern = Pattern.compile("(?:^|&)(?:([^=&]*)(?:=([^&]*))?)?");
    public static Pattern contentDispositionPattern = Pattern.compile("form-data\\s*;\\s*name=([^;]+)(?:;\\s*filename=([^;]*))?");
    RequestParsedHeaders reqHeaders;

    public static void parseFormUrlEncoded(String query, ArrayList params, int location) {
        try {
            Matcher queryMatcher = queryParamPattern.matcher(query);
            while (queryMatcher.find()) {
                String name = queryMatcher.group(1);
                String val = queryMatcher.group(2);
                Param param = new Param();
                param.location = location;
                if (name != null) {
                    param.name = URLDecoder.decode(name, "UTF-8");
                }
                if (val != null) {
                    param.value = URLDecoder.decode(val, "UTF-8").getBytes();
                    param.hasValue = true;
                }
                params.add(param);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public ArrayList parseParams() {
        ArrayList<Param> params;
        block11: {
            params = new ArrayList<Param>();
            String query = this.reqHeaders.getQuery();
            if (query != null) {
                HttpRequest.parseFormUrlEncoded(query, params, 0);
            }
            if (this.bodyLength <= 0) break block11;
            if (!this.reqHeaders.multipart) {
                Iterator it = this.body.iterator();
                while (it.hasNext()) {
                    HttpMessage.BodyPart part = (HttpMessage.BodyPart)it.next();
                    HttpRequest.parseFormUrlEncoded(new String(part.rawBodyPart), params, 1);
                }
            } else {
                Matcher dispMatch;
                ParsedHeaders partHeaders;
                String disposition;
                int endHeaders;
                byte[] boundary = ("\r\n--" + this.reqHeaders.boundary).getBytes();
                byte[] body = this.getBodyPart((int)0).rawBodyPart;
                int pos = boundary.length - 2;
                int nextPos = -1;
                if (ByteSearch.find(boundary, 2, boundary.length, body, 0, boundary.length - 2) < 0 && (pos = ByteSearch.find(boundary, body, 0, body.length)) >= 0) {
                    pos += boundary.length;
                }
                if (pos >= 0) {
                    nextPos = ByteSearch.find(boundary, body, pos, body.length);
                }
                while (nextPos >= 0 && (body[pos] != 45 || body[pos + 1] != 45) && (pos = ByteSearch.indexOf((byte)13, body, pos, body.length)) >= 0 && (endHeaders = ByteSearch.find(CRLF2, body, pos, nextPos)) >= 0 && (disposition = (partHeaders = new ParsedHeaders(new String(body, pos, (endHeaders += 4) - pos))).getHeaderValue("Content-Disposition")) != null && (dispMatch = contentDispositionPattern.matcher(disposition)).find()) {
                    Param param = new Param();
                    param.name = dispMatch.group(1);
                    if (param.name.startsWith("\"") && param.name.endsWith("\"")) {
                        param.name = param.name.substring(1, param.name.length() - 1);
                    }
                    param.fileName = dispMatch.group(2);
                    if (param.fileName != null && param.fileName.startsWith("\"") && param.fileName.endsWith("\"")) {
                        param.fileName = param.fileName.substring(1, param.fileName.length() - 1);
                    }
                    param.location = 1;
                    if (nextPos > endHeaders) {
                        param.value = new byte[nextPos - endHeaders];
                        System.arraycopy(body, endHeaders, param.value, 0, nextPos - endHeaders);
                        param.hasValue = true;
                    }
                    if (partHeaders.contentType != null) {
                        param.contentType = partHeaders.contentType;
                    }
                    params.add(param);
                    pos = nextPos + boundary.length;
                    nextPos = ByteSearch.find(boundary, body, pos, body.length);
                }
            }
        }
        return params;
    }

    public void composeParams(ArrayList params) {
        if (params == null) {
            return;
        }
        StringBuffer query = new StringBuffer();
        ByteArrayOutputStream newBody = new ByteArrayOutputStream();
        boolean firstBodyParam = true;
        boolean firstQueryParam = true;
        try {
            Iterator it = params.iterator();
            while (it.hasNext()) {
                Param param = (Param)it.next();
                if (param.location == 0) {
                    if (firstQueryParam) {
                        firstQueryParam = false;
                    } else {
                        query.append("&");
                    }
                    if (param.name != null) {
                        query.append(URLEncoder.encode(param.name, "UTF-8"));
                    }
                    if (!param.hasValue) continue;
                    query.append("=");
                    if (param.value == null) continue;
                    query.append(URLEncoder.encode(new String(param.value), "UTF-8"));
                    continue;
                }
                try {
                    if (!this.reqHeaders.multipart || this.reqHeaders.boundary == null) {
                        if (!firstBodyParam) {
                            newBody.write(38);
                        } else {
                            firstBodyParam = false;
                        }
                        if (param.name == null) continue;
                        newBody.write(URLEncoder.encode(param.name, "UTF-8").getBytes());
                        if (param.hasValue) {
                            newBody.write(61);
                        }
                        if (param.value == null) continue;
                        newBody.write(URLEncoder.encode(new String(param.value), "UTF-8").getBytes());
                        continue;
                    }
                    if (param.name == null) continue;
                    if (!firstBodyParam) {
                        newBody.write("\r\n".getBytes());
                    } else {
                        firstBodyParam = false;
                    }
                    newBody.write(("--" + this.reqHeaders.boundary + "\r\n").getBytes());
                    newBody.write(("Content-Disposition: form-data; name=\"" + param.name + "\"").getBytes());
                    if (param.fileName != null) {
                        newBody.write(("; filename=\"" + param.fileName + "\"").getBytes());
                    }
                    newBody.write("\r\n".getBytes());
                    if (!param.contentType.equals("text/plain")) {
                        newBody.write(("Content-Type: " + param.contentType + "\r\n").getBytes());
                    }
                    newBody.write("\r\n".getBytes());
                    if (!param.hasValue) continue;
                    newBody.write(param.value);
                }
                catch (IOException ioe) {}
            }
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
        if (firstQueryParam) {
            this.reqHeaders.setQuery(null);
        } else {
            this.reqHeaders.setQuery(query.toString());
        }
        if (this.reqHeaders.multipart && this.reqHeaders.boundary != null && !firstBodyParam) {
            try {
                newBody.write(("\r\n--" + this.reqHeaders.boundary + "--\r\n").getBytes());
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        this.setBody(newBody.toByteArray());
    }

    public RequestParsedHeaders getReqHeaders() {
        return this.reqHeaders;
    }

    public void parseHeaders() {
        int defaultPort = this.getSrcInfo().isSSL() ? 443 : 80;
        this.reqHeaders = new RequestParsedHeaders(this.rawHeaders, defaultPort);
        this.headers = this.reqHeaders;
        Connection con = this.getSrcInfo().getCon();
        Connection targetCon = null;
        if (con != null) {
            targetCon = con.getTargetConnection();
        }
        HostPort targetAddress = null;
        if (targetCon != null) {
            targetAddress = targetCon.getPeerAddress();
            if (targetAddress != null) {
                this.reqHeaders.host = targetAddress.getHostName();
                this.reqHeaders.port = targetAddress.getPort();
            } else if (this.reqHeaders.host != null) {
                targetAddress = new HostPort(this.reqHeaders.host, this.reqHeaders.port);
                targetCon.setPeerAddress(targetAddress);
            }
        }
    }

    public void readFrom(Connection con) throws IOException {
        super.readFrom(con);
    }

    public HttpRequest(HttpMessageObserver writeObserver) {
        super(null, writeObserver);
    }

    public HttpRequest() {
    }

    public String getHost() {
        return this.reqHeaders.host;
    }

    public int getPort() {
        return this.reqHeaders.port;
    }

    public static class Param {
        public String name;
        public String contentType;
        public String fileName;
        public byte[] value;
        public boolean hasValue;
        public int location;

        public Param() {
            this.name = null;
            this.contentType = "text/plain";
            this.fileName = null;
            this.value = null;
            this.hasValue = false;
            this.location = 0;
        }

        public Param(Param other) {
            this.name = other.name;
            this.contentType = other.contentType;
            this.fileName = other.fileName;
            this.value = other.value;
            this.hasValue = other.hasValue;
            this.location = other.location;
        }
    }
}

