/*
 * Decompiled with CFR 0.152.
 */
package webshadow.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import webshadow.comm.Connection;
import webshadow.comm.HostPort;
import webshadow.comm.Message;
import webshadow.comm.MessageObserver;
import webshadow.http.HttpMessageObserver;
import webshadow.http.ParsedHeaders;
import webshadow.util.LineInputStream;

public class HttpMessage
extends Message {
    Set messageObservers = Collections.synchronizedSet(new HashSet());
    Set readObservers = Collections.synchronizedSet(new HashSet());
    Set writeObservers = Collections.synchronizedSet(new HashSet());
    Set allObservers = Collections.synchronizedSet(new HashSet());
    String rawHeaders;
    boolean useRawHeaders;
    ParsedHeaders headers;
    boolean slowMultipart;
    boolean hasMoreBody;
    int nextBodyPartSeq;
    ArrayList body;
    int bodyLength;
    boolean unchunk;

    boolean useFastMultipart() {
        return true;
    }

    public void setUnchunk(boolean unchunk) {
        this.unchunk = unchunk;
    }

    public String getRawHeaders() {
        return this.rawHeaders;
    }

    public void setRawHeaders(String rawHeaders) {
        this.rawHeaders = rawHeaders;
        this.parseHeaders();
    }

    public void setUseRawHeaders(boolean useRawHeaders) {
        this.useRawHeaders = useRawHeaders;
    }

    public ParsedHeaders getParsedHeaders() {
        return this.headers;
    }

    public int getBodyLength() {
        return this.bodyLength;
    }

    public BodyPart getBodyPart(int idx) {
        return (BodyPart)this.body.get(idx);
    }

    public void setBody(byte[] rawBody) {
        if (this.body == null) {
            this.body = new ArrayList();
        } else {
            this.body.clear();
        }
        if (rawBody != null) {
            BodyPart newPart = new BodyPart("", rawBody, "");
            this.body.add(newPart);
            this.bodyLength = rawBody.length;
        } else {
            this.bodyLength = 0;
        }
    }

    public void setBody(byte[] newBody, boolean autoZip) {
        if (!autoZip) {
            this.setBody(newBody);
        }
        try {
            String encoding = this.getParsedHeaders().getHeaderValue("Content-Encoding");
            if (encoding != null) {
                if (encoding.indexOf("gzip") >= 0) {
                    int n;
                    ByteArrayInputStream sis = new ByteArrayInputStream(newBody);
                    ByteArrayOutputStream bao = new ByteArrayOutputStream();
                    GZIPOutputStream gzip = new GZIPOutputStream(bao);
                    byte[] buf = new byte[4096];
                    while ((n = sis.read(buf, 0, buf.length)) > 0) {
                        gzip.write(buf, 0, n);
                    }
                    gzip.close();
                    bao.close();
                    newBody = bao.toByteArray();
                } else if (encoding.indexOf("deflate") >= 0) {
                    int n;
                    ByteArrayInputStream sis = new ByteArrayInputStream(newBody);
                    ByteArrayOutputStream bao = new ByteArrayOutputStream();
                    DeflaterOutputStream deflate = new DeflaterOutputStream(bao);
                    byte[] buf = new byte[4096];
                    while ((n = sis.read(buf, 0, buf.length)) > 0) {
                        deflate.write(buf, 0, n);
                    }
                    deflate.close();
                    bao.close();
                    newBody = bao.toByteArray();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setBody(newBody);
    }

    public byte[] getBody(boolean autoUnzip) throws ZipException {
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        try {
            if (this.getParsedHeaders().multipart) {
                this.writeBody(bao, bao, bao);
            } else {
                this.writeBody(null, bao, null);
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            String encoding;
            if (autoUnzip && (encoding = this.getParsedHeaders().getHeaderValue("Content-Encoding")) != null) {
                if (encoding.indexOf("gzip") >= 0) {
                    int n;
                    byte[] buf = bao.toByteArray();
                    ByteArrayInputStream bai = new ByteArrayInputStream(buf);
                    GZIPInputStream gunzip = new GZIPInputStream(bai);
                    bao = new ByteArrayOutputStream();
                    buf = new byte[4096];
                    while ((n = gunzip.read(buf, 0, buf.length)) > 0) {
                        bao.write(buf, 0, n);
                    }
                    bao.close();
                    gunzip.close();
                } else if (encoding.indexOf("deflate") >= 0) {
                    int n;
                    byte[] buf = bao.toByteArray();
                    ByteArrayInputStream bai = new ByteArrayInputStream(buf);
                    InflaterInputStream inflate = new InflaterInputStream(bai);
                    bao = new ByteArrayOutputStream();
                    buf = new byte[4096];
                    while ((n = inflate.read(buf, 0, buf.length)) > 0) {
                        bao.write(buf, 0, n);
                    }
                    bao.close();
                    inflate.close();
                }
            }
        }
        catch (ZipException ze) {
            throw ze;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bao.toByteArray();
    }

    public void parseHeaders() {
        this.headers = new ParsedHeaders(this.rawHeaders);
        if (!this.headers.good) {
            this.useRawHeaders = true;
        }
    }

    public void composeHeaders() {
        this.rawHeaders = this.headers.toString();
        this.useRawHeaders = false;
    }

    public void readFrom(Connection con) throws IOException {
        String line;
        super.readFrom(con);
        this.nextBodyPartSeq = 0;
        this.hasMoreBody = true;
        StringBuffer headerBuf = new StringBuffer();
        LineInputStream in = con.getInputStream();
        do {
            if ((line = in.readLine()) == null) {
                this.hasMoreBody = false;
                this.getSrcInfo().setLast(true);
                this.observeMessageReadDone(this.messageObservers);
                throw new EOFException("Premature end of HTTP message");
            }
            headerBuf.append(line + "\r\n");
        } while (!line.equals(""));
        this.getSrcInfo().setEndTime(System.currentTimeMillis());
        this.rawHeaders = headerBuf.toString();
        this.parseHeaders();
        boolean bl = this.hasMoreBody = this.headers.chunked || this.headers.multipart || this.headers.contentLength != 0;
        if (this.headers.contentLength < 0 || in.available() == 0 && this.getSrcInfo().getCon().isInputShutdown()) {
            this.getSrcInfo().setLast(true);
        }
        this.observeHeaders(this.readObservers, this.hasMoreBody);
        boolean bl2 = this.slowMultipart = this.headers.multipart && (!this.useFastMultipart() || this.headers.contentLength <= 0);
        if (this.slowMultipart) {
            byte[] tmp = new byte[]{13, 10};
            boolean removeCRLF = true;
            in.unread(tmp);
            in.setBoundary("\r\n--" + this.headers.boundary);
            if (!in.expectBoundary()) {
                in.read(tmp);
                removeCRLF = false;
            }
            this.readBodyPart();
            if (removeCRLF) {
                String oldBodySuffix = this.getBodyPart((int)0).rawBodySuffix;
                this.getBodyPart((int)0).rawBodySuffix = oldBodySuffix.substring(2);
            }
        }
        if (!this.hasMoreBody) {
            this.observeMessageReadDone(this.messageObservers);
        }
    }

    private void localReset() {
        this.nextBodyPartSeq = 0;
        this.hasMoreBody = false;
        this.rawHeaders = "";
        this.useRawHeaders = false;
        this.parseHeaders();
    }

    public void reset() {
        this.localReset();
        super.reset();
    }

    public HttpMessage() {
        this.localReset();
    }

    public HttpMessage(HttpMessageObserver readHmo, HttpMessageObserver writeHmo) {
        this();
        if (readHmo != null) {
            this.addReadObserver(readHmo);
        }
        if (writeHmo != null) {
            this.addWriteObserver(writeHmo);
        }
    }

    public boolean hasMoreBody() {
        return this.hasMoreBody;
    }

    public int getNextBodyPartSeq() {
        return this.nextBodyPartSeq;
    }

    protected int streamBytes(InputStream in, OutputStream out, int len, Collection observers) throws IOException {
        int n;
        byte[] buf = new byte[4096];
        int total = 0;
        for (int left = len; len < 0 || left > 0; left -= n) {
            n = -1;
            try {
                n = in.read(buf, 0, Math.min(buf.length, left < 0 ? buf.length : left));
            }
            catch (IOException ioe) {
                this.getSrcInfo().getCon().closeRead();
                throw ioe;
            }
            if (n > 0) {
                if (out != null) {
                    out.write(buf, 0, n);
                }
                this.observeBodyPartData(observers, buf, 0, n);
                total += n;
                continue;
            }
            this.getSrcInfo().getCon().closeRead();
            if (len <= 0) break;
            throw new EOFException("Premature end of body (need " + String.valueOf(left) + " of " + String.valueOf(len) + ")");
        }
        return total;
    }

    protected int streamBytes(LineInputStream in, OutputStream out, Collection observers) throws IOException {
        int n;
        byte[] buf = new byte[4096];
        int total = 0;
        do {
            n = -1;
            try {
                if (in.expectBoundary()) {
                    return total;
                }
                n = in.read(buf, 0, buf.length);
            }
            catch (IOException ioe) {
                this.getSrcInfo().getCon().closeRead();
                throw ioe;
            }
            if (n <= 0) continue;
            if (out != null) {
                out.write(buf, 0, n);
            }
            this.observeBodyPartData(observers, buf, 0, n);
            total += n;
        } while (n > 0);
        this.getSrcInfo().getCon().closeRead();
        throw new EOFException("Premature end of body (couldn't find boundary)");
    }

    public int streamBodyPart(OutputStream pre, OutputStream out, OutputStream suf, Collection observers) throws IOException {
        int total = 0;
        LineInputStream in = this.getSrcInfo().getCon().getInputStream();
        this.observeStartBodyPart(observers, this.nextBodyPartSeq);
        try {
            if (this.headers.chunked) {
                int extStart;
                String line = in.readLine();
                if (line == null) {
                    throw new EOFException("Premature end of chunked header");
                }
                byte[] outp = (line + "\r\n").getBytes();
                this.observeBodyPrefixData(observers, outp, 0, outp.length);
                if (pre != null) {
                    pre.write(outp);
                    total += outp.length;
                }
                if ((extStart = line.indexOf(";")) >= 0) {
                    line = line.substring(0, extStart).trim();
                }
                int partLen = 0;
                try {
                    partLen = Integer.parseInt(line.trim(), 16);
                }
                catch (NumberFormatException e) {
                    throw new ProtocolException("Invalid number format for chunk length: " + String.valueOf(line));
                }
                if (partLen > 0) {
                    this.observeStartBodyPartData(observers, partLen);
                    total += this.streamBytes(in, out, partLen, observers);
                    line = in.readLine();
                    if (line == null) {
                        throw new EOFException("Premature end of chunk body");
                    }
                    if (!line.equals("")) {
                        throw new ProtocolException("Chunk body does not end in empty line");
                    }
                    outp = (line + "\r\n").getBytes();
                    this.observeBodySuffixData(observers, outp, 0, outp.length);
                    if (suf != null) {
                        suf.write(outp);
                        total += outp.length;
                    }
                } else {
                    do {
                        if ((line = in.readLine()) == null) {
                            throw new EOFException("Premature end of chunk trailer");
                        }
                        outp = (line + "\r\n").getBytes();
                        this.observeBodySuffixData(observers, outp, 0, outp.length);
                        if (suf == null) continue;
                        suf.write(outp);
                        total += outp.length;
                    } while (!line.equals(""));
                    this.hasMoreBody = false;
                }
            } else if (this.slowMultipart) {
                byte[] outp;
                String line;
                if (this.nextBodyPartSeq > 0) {
                    do {
                        if ((line = in.readLine()) == null) {
                            throw new EOFException("Premature end of multipart header");
                        }
                        outp = (line + "\r\n").getBytes();
                        this.observeBodyPrefixData(observers, outp, 0, outp.length);
                        if (pre == null) continue;
                        pre.write(outp);
                        total += outp.length;
                    } while (line.length() > 0);
                }
                this.observeStartBodyPartData(observers, -1);
                total += this.streamBytes(in, out, observers);
                in.readLine();
                line = in.readLine();
                outp = ("\r\n" + line + "\r\n").getBytes();
                this.observeBodySuffixData(observers, outp, 0, outp.length);
                if (suf != null) {
                    suf.write(outp);
                    total += outp.length;
                }
                if (line.endsWith("--")) {
                    in.readLine();
                    this.hasMoreBody = false;
                }
            } else {
                this.observeStartBodyPartData(observers, this.headers.contentLength);
                total += this.streamBytes(in, out, this.headers.contentLength, observers);
                this.hasMoreBody = false;
            }
            this.observeEndBodyPart(observers, this.hasMoreBody);
            if (!this.hasMoreBody) {
                this.observeMessageReadDone(this.messageObservers);
            }
            ++this.nextBodyPartSeq;
            if (in.available() == 0 && this.getSrcInfo().getCon().isInputShutdown()) {
                this.getSrcInfo().setLast(true);
            }
            return total;
        }
        catch (IOException ioe) {
            this.hasMoreBody = false;
            this.getSrcInfo().setLast(true);
            this.observeEndBodyPart(observers, this.hasMoreBody);
            this.observeMessageReadDone(this.messageObservers);
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readBodyPart() throws IOException {
        ByteArrayOutputStream pre = new ByteArrayOutputStream();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream suf = new ByteArrayOutputStream();
        try {
            int retval;
            int n = retval = this.streamBodyPart(pre, out, suf, this.readObservers);
            return n;
        }
        finally {
            if (this.body == null) {
                this.body = new ArrayList();
            }
            this.body.add(new BodyPart(pre.toString(), out.toByteArray(), suf.toString()));
            this.bodyLength += out.size();
        }
    }

    public int readBody() throws IOException {
        int total = 0;
        while (this.hasMoreBody()) {
            total += this.readBodyPart();
        }
        return total;
    }

    public int streamBody(OutputStream pre, OutputStream out, OutputStream suf) throws IOException {
        int total = 0;
        while (this.hasMoreBody()) {
            total += this.streamBodyPart(pre, out, suf, this.allObservers);
        }
        return total;
    }

    public void writeBody(OutputStream pre, OutputStream out, OutputStream suf) throws IOException {
        if (this.body == null) {
            return;
        }
        int i = 0;
        Iterator it = this.body.iterator();
        while (it.hasNext()) {
            BodyPart part = (BodyPart)it.next();
            this.observeStartBodyPart(this.writeObservers, i);
            byte[] buf = part.rawBodyPrefix.getBytes();
            this.observeBodyPrefixData(this.writeObservers, buf, 0, buf.length);
            if (pre != null) {
                pre.write(buf);
            }
            buf = part.rawBodyPart;
            this.observeBodyPartData(this.writeObservers, buf, 0, buf.length);
            out.write(buf);
            buf = part.rawBodySuffix.getBytes();
            this.observeBodySuffixData(this.writeObservers, buf, 0, buf.length);
            if (suf != null) {
                suf.write(buf);
            }
            this.observeEndBodyPart(this.writeObservers, it.hasNext() || this.hasMoreBody());
            ++i;
        }
    }

    protected void writeTo(OutputStream out, OutputStream pre, OutputStream suf) throws IOException {
        boolean reallyUnchunk;
        boolean bl = reallyUnchunk = this.unchunk && !this.hasMoreBody() && !this.slowMultipart;
        if (reallyUnchunk) {
            this.headers.chunked = false;
            this.headers.contentLength = this.bodyLength;
        } else if (!(this.headers.chunked || this.slowMultipart || this.hasMoreBody())) {
            this.headers.contentLength = this.body != null ? this.bodyLength : 0;
        }
        if (!this.useRawHeaders) {
            this.composeHeaders();
        }
        this.observeHeaders(this.writeObservers, this.hasMoreBody() || this.body != null && !this.body.isEmpty());
        out.write(this.rawHeaders.getBytes());
        if (reallyUnchunk) {
            suf = null;
            pre = null;
        }
        this.writeBody(pre, out, suf);
        this.streamBody(pre, out, suf);
    }

    protected void writeTo(OutputStream out) throws IOException {
        this.writeTo(out, out, out);
    }

    public void writeToZip(ZipOutputStream zout) throws IOException {
        this.readBody();
        ZipEntry entry = new ZipEntry("metadata");
        entry.setComment("Serialized metadata about the message");
        zout.putNextEntry(entry);
        ObjectOutputStream metaData = new ObjectOutputStream(zout);
        this.getSrcInfo().getCon().getTargetAddress().getHostFull();
        metaData.writeObject(this.getSrcInfo().getCon().getTargetAddress());
        metaData.writeBoolean(this.getSrcInfo().isSSL());
        metaData.flush();
        zout.closeEntry();
        entry = new ZipEntry("msg.data");
        entry.setComment("Message Data");
        zout.putNextEntry(entry);
        this.writeTo(zout);
        zout.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFromZip(ZipInputStream zin) throws IOException {
        Connection oldSrc;
        boolean isSSL;
        HostPort target;
        zin.getNextEntry();
        try {
            ObjectInputStream oin = new ObjectInputStream(zin);
            target = (HostPort)oin.readObject();
            isSSL = oin.readBoolean();
        }
        catch (ClassNotFoundException cnfe) {
            return;
        }
        Connection src = oldSrc = this.getSrcInfo().getCon();
        src = src == null ? Connection.newPair() : Connection.newSource(oldSrc.getTargetConnection());
        Connection targetCon = src.getTargetConnection();
        if (targetCon.getConnectStatus() == 0) {
            if (target != null) {
                targetCon.setPeerAddress(target);
            }
            if (isSSL) {
                targetCon.setAttribute("SSL", Boolean.TRUE);
            } else {
                targetCon.removeAttribute("SSL");
            }
        }
        ZipEntry entry = zin.getNextEntry();
        src.openStream(zin, oldSrc != null);
        try {
            this.setBody(null);
            this.readFrom(src);
            this.readBody();
        }
        finally {
            if (oldSrc != null) {
                this.getSrcInfo().setCon(oldSrc);
            }
        }
    }

    public void addObserver(MessageObserver observer) {
        this.messageObservers.add(observer);
    }

    public void addReadObserver(HttpMessageObserver hmo) {
        this.readObservers.add(hmo);
        this.allObservers.add(hmo);
    }

    public void addReadObserver(Collection observers) {
        this.readObservers.addAll(observers);
        this.allObservers.addAll(observers);
    }

    public void addWriteObserver(HttpMessageObserver hmo) {
        this.writeObservers.add(hmo);
        this.allObservers.add(hmo);
    }

    public void addWriteObserver(Collection observers) {
        this.writeObservers.addAll(observers);
        this.allObservers.addAll(observers);
    }

    protected void observeMessageReadDone(Collection observers) {
        if (observers != null) {
            Iterator it = observers.iterator();
            while (it.hasNext()) {
                MessageObserver mo = (MessageObserver)it.next();
                mo.messageReadDone(this);
            }
        }
    }

    private final int getStreamingState(Collection observers) {
        int state = 0;
        if (observers == this.readObservers) {
            state = 2;
        } else if (observers == this.writeObservers) {
            state = 1;
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void observeHeaders(Collection observers, boolean hasBody) {
        Collection collection = observers;
        synchronized (collection) {
            int state = this.getStreamingState(observers);
            Iterator it = observers.iterator();
            while (it.hasNext()) {
                HttpMessageObserver hmo = (HttpMessageObserver)it.next();
                hmo.headers(this, hasBody, state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void observeStartBodyPart(Collection observers, int seq) {
        Collection collection = observers;
        synchronized (collection) {
            int state = this.getStreamingState(observers);
            Iterator it = observers.iterator();
            while (it.hasNext()) {
                HttpMessageObserver hmo = (HttpMessageObserver)it.next();
                hmo.startBodyPart(this, seq, state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void observeStartBodyPartData(Collection observers, int len) {
        Collection collection = observers;
        synchronized (collection) {
            int state = this.getStreamingState(observers);
            Iterator it = observers.iterator();
            while (it.hasNext()) {
                HttpMessageObserver hmo = (HttpMessageObserver)it.next();
                hmo.startBodyPartData(this, len, state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void observeBodyPartData(Collection observers, byte[] buf, int off, int len) {
        Collection collection = observers;
        synchronized (collection) {
            int state = this.getStreamingState(observers);
            Iterator it = observers.iterator();
            while (it.hasNext()) {
                HttpMessageObserver hmo = (HttpMessageObserver)it.next();
                hmo.bodyPartData(this, buf, off, len, state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void observeBodyPrefixData(Collection observers, byte[] buf, int off, int len) {
        Collection collection = observers;
        synchronized (collection) {
            int state = this.getStreamingState(observers);
            Iterator it = observers.iterator();
            while (it.hasNext()) {
                HttpMessageObserver hmo = (HttpMessageObserver)it.next();
                hmo.bodyPrefixData(this, buf, off, len, state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void observeBodySuffixData(Collection observers, byte[] buf, int off, int len) {
        Collection collection = observers;
        synchronized (collection) {
            int state = this.getStreamingState(observers);
            Iterator it = observers.iterator();
            while (it.hasNext()) {
                HttpMessageObserver hmo = (HttpMessageObserver)it.next();
                hmo.bodySuffixData(this, buf, off, len, state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void observeEndBodyPart(Collection observers, boolean hasMoreBody) {
        Collection collection = observers;
        synchronized (collection) {
            int state = this.getStreamingState(observers);
            Iterator it = observers.iterator();
            while (it.hasNext()) {
                HttpMessageObserver hmo = (HttpMessageObserver)it.next();
                hmo.endBodyPart(this, hasMoreBody, state);
            }
        }
    }

    public static class BodyPart {
        String rawBodyPrefix;
        byte[] rawBodyPart;
        String rawBodySuffix;

        BodyPart(String prefix, byte[] body, String suffix) {
            this.rawBodyPrefix = prefix;
            this.rawBodyPart = body;
            this.rawBodySuffix = suffix;
        }
    }
}

