/*
 * Decompiled with CFR 0.152.
 */
package webshadow.http;

import java.io.IOException;
import webshadow.comm.Connection;
import webshadow.comm.HostPort;
import webshadow.http.HttpRequest;
import webshadow.http.HttpResponse;
import webshadow.http.RequestParsedHeaders;
import webshadow.http.ResponseParsedHeaders;
import webshadow.util.ActiveModule;
import webshadow.util.Module;

public class ConnectMessageInterceptor
extends ActiveModule {
    Module connectionReader;
    Module connectionWriter;
    Module msgHandler;

    public synchronized void waitForSetHandlers() {
        try {
            while (this.msgHandler == null || this.connectionReader == null || this.connectionWriter == null) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void setHandlers(Module connectionReader, Module connectionWriter, Module msgHandler) {
        this.connectionReader = connectionReader;
        this.connectionWriter = connectionWriter;
        this.msgHandler = msgHandler;
        this.notify();
    }

    public void process(Object in) {
        Connection con = (Connection)in;
        this.waitForSetHandlers();
        Connection targetCon = con.getTargetConnection();
        if (targetCon.getPeerAddress() != null) {
            this.connectionWriter.put(con);
            this.connectionReader.put(con);
            return;
        }
        boolean wasConnect = false;
        HttpRequest req = new HttpRequest();
        try {
            req.readFrom(con);
            RequestParsedHeaders reqHeaders = req.getReqHeaders();
            if (reqHeaders.good && reqHeaders.method.equalsIgnoreCase("CONNECT")) {
                wasConnect = true;
                HttpResponse resp = new HttpResponse();
                ResponseParsedHeaders respHeaders = resp.getRespHeaders();
                respHeaders.protocol = reqHeaders.protocol;
                respHeaders.code = 200;
                respHeaders.codeMsg = "Connection established";
                targetCon.setPeerAddress(new HostPort(req.getHost(), req.getPort()));
                targetCon.setAttribute("SSL", Boolean.TRUE);
                resp.writeTo(con);
                con.doSSL(false);
                con.setAttribute("nextReadSeq", null);
            }
            this.connectionWriter.put(con);
            if (wasConnect || !req.hasMoreBody()) {
                this.connectionReader.put(con);
            }
            if (!wasConnect) {
                this.msgHandler.put(req);
            }
        }
        catch (IOException ioe) {
            con.close();
        }
    }
}

