/*
 * Decompiled with CFR 0.152.
 */
package webshadow.comm;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import webshadow.comm.Acceptor;
import webshadow.comm.Connection;
import webshadow.comm.HostPort;

public class SocksAcceptor
extends Acceptor {
    public SocksAcceptor(int port) throws IOException {
        super(port);
    }

    private int readFull(InputStream in, byte[] buf, int offs, int len) throws IOException {
        int n;
        int res;
        for (n = 0; n < len && (res = in.read(buf, offs + n, len - n)) > 0; n += res) {
        }
        return n;
    }

    protected Connection getConnection(Socket sock) throws IOException {
        InputStream in = sock.getInputStream();
        OutputStream out = sock.getOutputStream();
        HostPort targetAddr = null;
        int ver = in.read();
        switch (ver) {
            case 4: {
                int cmd = in.read();
                int port = in.read();
                port <<= 8;
                port |= in.read();
                byte[] rawAddr = new byte[4];
                this.readFull(in, rawAddr, 0, 4);
                InetAddress addr = null;
                try {
                    addr = InetAddress.getByAddress(rawAddr);
                    targetAddr = new HostPort(addr, port);
                }
                catch (UnknownHostException uhe) {
                    // empty catch block
                }
                int n = 1;
                while (n > 0) {
                    n = in.read();
                }
                byte[] reply = new byte[8];
                reply[0] = 0;
                for (int i = 2; i < reply.length; ++i) {
                    reply[i] = 0;
                }
                if (cmd == 1) {
                    reply[1] = 90;
                    out.write(reply);
                    break;
                }
                reply[1] = 91;
                out.write(reply);
                sock.close();
                return null;
            }
            case 5: {
                int nmethods = in.read();
                if (nmethods < 0) {
                    sock.close();
                    return null;
                }
                byte[] methods = new byte[nmethods];
                this.readFull(in, methods, 0, nmethods);
                out.write(5);
                out.write(0);
                ver = in.read();
                int cmd = in.read();
                in.read();
                int atyp = in.read();
                byte[] rawAddr = null;
                switch (atyp) {
                    case 1: {
                        rawAddr = new byte[4];
                        this.readFull(in, rawAddr, 0, 4);
                        break;
                    }
                    case 3: {
                        int len = in.read();
                        if (len <= 0) {
                            sock.close();
                            return null;
                        }
                        rawAddr = new byte[len];
                        this.readFull(in, rawAddr, 0, len);
                        break;
                    }
                    case 4: {
                        rawAddr = new byte[6];
                        this.readFull(in, rawAddr, 0, 4);
                        break;
                    }
                    default: {
                        sock.close();
                        return null;
                    }
                }
                int port = in.read();
                port <<= 8;
                port |= in.read();
                try {
                    targetAddr = atyp != 3 ? new HostPort(InetAddress.getByAddress(rawAddr), port) : new HostPort(new String(rawAddr, "UTF-8"), port);
                }
                catch (UnknownHostException uhe) {
                    // empty catch block
                }
                byte[] reply = new byte[10];
                reply[0] = 5;
                reply[1] = cmd == 1 ? 0 : 7;
                reply[2] = 0;
                reply[3] = 1;
                HostPort peerAddr = new HostPort(sock.getInetAddress(), sock.getPort());
                System.arraycopy(peerAddr.getAddress().getAddress(), 0, reply, 4, 4);
                reply[8] = (byte)(peerAddr.getPort() >> 8);
                reply[9] = (byte)(peerAddr.getPort() & 0xFF);
                out.write(reply);
                break;
            }
            default: {
                sock.close();
                return null;
            }
        }
        Connection con = Connection.newPair();
        con.setObservers(this.observers);
        con.setTargetAddress(targetAddr);
        con.accept(sock);
        return con;
    }
}

