/*
 * Decompiled with CFR 0.152.
 */
package webshadow.comm;

import java.io.IOException;
import webshadow.comm.Connection;
import webshadow.comm.Message;
import webshadow.comm.MessageObserverModule;
import webshadow.util.ActiveModule;
import webshadow.util.Module;

public abstract class MessageReader
extends ActiveModule
implements MessageObserverModule {
    protected Module msgHandler = null;

    public synchronized void setMessageHandler(Module msgHandler) {
        this.msgHandler = msgHandler;
        this.notify();
    }

    protected abstract Message newMessage();

    public void messageReadDone(Message msg) {
        Connection con = msg.getSrcInfo().getCon();
        if (con != null && !con.isReadClosed()) {
            this.put(con);
        }
    }

    private synchronized void waitForHandlerSet() {
        try {
            while (this.msgHandler == null) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void process(Object in) {
        Connection con = (Connection)in;
        if (con.isReadClosed()) {
            return;
        }
        Message msg = this.newMessage();
        try {
            msg.readFrom(con);
        }
        catch (IOException e) {
            con.closeRead();
        }
        this.waitForHandlerSet();
        if (this.msgHandler != null) {
            this.msgHandler.put(msg);
        }
    }
}

