/*
 * Decompiled with CFR 0.152.
 */
package webshadow.comm;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import javax.net.ssl.SSLSession;
import webshadow.comm.Connection;
import webshadow.comm.MessageObserver;
import webshadow.util.Attributes;

public abstract class Message
extends Attributes {
    Info src = new Info();
    Info dst = new Info();
    boolean hold;
    boolean deleted;

    public void reset() {
        this.localReset();
        super.reset();
    }

    private void localReset() {
        this.src.reset();
        this.dst.reset();
        this.hold = false;
        this.deleted = false;
    }

    private synchronized void waitForRelease() throws InterruptedException {
        while (this.hold) {
            this.wait();
        }
    }

    public synchronized void hold() {
        this.hold = true;
    }

    public synchronized void release() {
        this.hold = false;
        this.notifyAll();
    }

    public synchronized void delete() {
        this.deleted = true;
        this.hold = false;
        this.notifyAll();
    }

    public synchronized boolean isHeld() {
        return this.hold;
    }

    public synchronized boolean isDeleted() {
        return this.deleted;
    }

    public void readFrom(Connection srcCon) throws IOException {
        this.reset();
        this.src.con = srcCon;
        if (srcCon != null) {
            this.src.beginTime = this.src.endTime = System.currentTimeMillis();
            this.src.isSSL = srcCon.isSSL();
            this.src.sslSession = srcCon.getSSLSession();
            Integer seq = (Integer)srcCon.getAttribute("nextReadSeq");
            if (seq == null) {
                seq = new Integer(0);
            }
            this.src.seq = seq;
            srcCon.setAttribute("nextReadSeq", new Integer(this.src.seq + 1));
        }
        if (srcCon.isInputShutdown()) {
            this.src.setLast(true);
            throw new EOFException("Connection closed");
        }
    }

    public Message() {
        this.localReset();
    }

    public Info getSrcInfo() {
        return this.src;
    }

    public Info getDstInfo() {
        return this.dst;
    }

    public abstract void addObserver(MessageObserver var1);

    protected abstract void writeTo(OutputStream var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(Connection dstCon) throws IOException {
        try {
            this.waitForRelease();
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        if (this.isDeleted()) {
            return;
        }
        try {
            dstCon.waitForConnect();
            if (dstCon.getAttribute("SSL") != null) {
                dstCon.waitForSSLConversion();
            }
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        this.dst.con = dstCon;
        if (dstCon != null) {
            this.dst.beginTime = System.currentTimeMillis();
            this.dst.isSSL = dstCon.isSSL();
            this.dst.sslSession = dstCon.getSSLSession();
            Integer seq = (Integer)dstCon.getAttribute("nextWriteSeq");
            if (seq == null) {
                seq = new Integer(0);
            }
            this.dst.seq = seq;
            dstCon.setAttribute("nextWriteSeq", new Integer(this.dst.seq + 1));
            if (dstCon.isOutputShutdown()) {
                throw new IOException("Connection closed for writing");
            }
            try {
                this.writeTo(dstCon.getOutputStream());
            }
            finally {
                this.dst.endTime = System.currentTimeMillis();
                if (this.dst.isLast()) {
                    dstCon.closeWrite();
                }
            }
        }
    }

    public static class Info {
        Connection con;
        boolean isSSL;
        SSLSession sslSession;
        long beginTime;
        long endTime;
        int seq;
        boolean isLast;

        public void reset() {
            this.con = null;
            this.isSSL = false;
            this.sslSession = null;
            this.endTime = 0L;
            this.beginTime = 0L;
            this.seq = -1;
            this.isLast = false;
        }

        Info() {
            this.reset();
        }

        public Connection getCon() {
            return this.con;
        }

        public void setCon(Connection con) {
            this.con = con;
        }

        public long getBeginTime() {
            return this.beginTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public void setEndTime(long endTime) {
            this.endTime = endTime;
        }

        public boolean isSSL() {
            return this.isSSL;
        }

        public SSLSession getSSLSession() {
            return this.sslSession;
        }

        public void setSSL(boolean isSSL) {
            this.isSSL = isSSL;
        }

        public void setSSL() {
            this.setSSL(true);
        }

        public int getSeq() {
            return this.seq;
        }

        public void setSeq(int seq) {
            this.seq = seq;
        }

        public boolean isLast() {
            return this.isLast;
        }

        public void setLast(boolean isLast) {
            this.isLast = isLast;
        }
    }
}

