/*
 * Decompiled with CFR 0.152.
 */
package webshadow.comm;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class HostPort
implements Serializable {
    String host;
    int port;
    InetAddress addr;
    public static boolean autoReverseDNS = true;

    public HostPort(String host, int port) {
        this.host = host;
        this.port = port;
        this.addr = null;
    }

    public HostPort(InetAddress addr, int port) {
        this.host = null;
        this.port = port;
        this.addr = addr;
    }

    public HostPort(HostPort other) {
        this.set(other);
    }

    public HostPort(String hostPort) {
        this.set(hostPort);
    }

    public final void set(HostPort other) {
        this.host = other.host;
        this.port = other.port;
        this.addr = other.addr;
    }

    public final void set(String hostPort) {
        int col = hostPort.indexOf(58);
        if (col < 0) {
            this.setHostName(hostPort);
            this.port = 80;
        } else {
            this.setHostName(hostPort.substring(0, col));
            try {
                this.port = Integer.parseInt(hostPort.substring(col + 1));
            }
            catch (NumberFormatException nfe) {
                this.port = 80;
            }
        }
    }

    public final int getPort() {
        return this.port;
    }

    public final void setPort(int port) {
        this.port = port;
    }

    public final String getHostName() {
        if (autoReverseDNS) {
            return this.getHostFull();
        }
        return this.getHostFast();
    }

    public final void setHostName(String newName) {
        if (newName.matches("\\d+\\.\\d+\\.\\d+\\.\\d+")) {
            try {
                this.addr = InetAddress.getByName(newName);
                this.host = null;
            }
            catch (UnknownHostException uhe) {
                this.addr = null;
                this.host = newName;
            }
        } else {
            this.addr = null;
            this.host = newName;
        }
    }

    public final InetAddress getAddress() throws UnknownHostException {
        if (this.addr == null) {
            this.addr = InetAddress.getByName(this.host);
        }
        return this.addr;
    }

    public final String getHostFast() {
        if (this.host != null) {
            return this.host;
        }
        return this.addr.getHostAddress();
    }

    public final String getHostFull() {
        if (this.host != null) {
            return this.host;
        }
        this.host = this.addr.getHostName();
        return this.host;
    }

    public final String toString() {
        return this.getHostName() + ":" + this.getPort();
    }
}

