/*
 * Decompiled with CFR 0.152.
 */
package webshadow.comm;

import com.sun.crypto.provider.SunJCE;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import webshadow.comm.ConnectionObserver;
import webshadow.comm.HostPort;
import webshadow.util.Attributes;
import webshadow.util.LineInputStream;
import webshadow.util.NullOutputStream;
import webshadow.util.Queue;

public class Connection
extends Attributes {
    private List observers = Collections.synchronizedList(new ArrayList());
    Socket sock;
    HostPort peerAddress;
    HostPort localAddress;
    Connection targetConnection;
    long openTime = 0L;
    LineInputStream in;
    OutputStream out;
    Queue sentQueue;
    Queue outQueue;
    boolean isWriteClosed = false;
    boolean isReadClosed = false;
    boolean isSSL = false;
    public static final int S_NONE = 0;
    public static final int S_CONNECTING = 1;
    public static final int S_OPEN = 2;
    public static final int S_CLOSED = 3;
    public static final int S_REFUSED = -1;
    public static final int S_HOST = -2;
    int connectStatus = 0;
    static SSLSocketFactory sockFactory = null;

    public synchronized Queue getSentQueue() {
        if (this.sentQueue == null) {
            this.sentQueue = new Queue();
        }
        return this.sentQueue;
    }

    public synchronized Queue getOutQueue() {
        if (this.outQueue == null) {
            this.outQueue = new Queue();
        }
        return this.outQueue;
    }

    private Connection() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openExisting(Socket sock) throws IOException {
        try {
            Connection connection = this;
            synchronized (connection) {
                this.sock = sock;
                if (sock != null) {
                    if (this.peerAddress == null) {
                        this.peerAddress = new HostPort(sock.getInetAddress(), sock.getPort());
                    }
                    this.in = new LineInputStream(sock);
                    this.out = sock.getOutputStream();
                    this.localAddress = new HostPort(sock.getLocalAddress(), sock.getLocalPort());
                    this.openTime = System.currentTimeMillis();
                    this.connectStatus = 2;
                    this.notifyAll();
                } else {
                    this.in = null;
                    this.out = null;
                }
            }
        }
        catch (IOException ioe) {
            Connection connection = this;
            synchronized (connection) {
                this.connectStatus = 3;
                this.notifyAll();
            }
            this.fireConnectionClosed();
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openNew(HostPort server) throws IOException, UnknownHostException {
        Socket sock = null;
        try {
            Connection connection = this;
            synchronized (connection) {
                this.peerAddress = server;
                this.connectStatus = 1;
                this.notifyAll();
            }
            ArrayList lobservers = new ArrayList(this.observers);
            Iterator it = lobservers.iterator();
            while (it.hasNext()) {
                ConnectionObserver co = (ConnectionObserver)it.next();
                co.connectingConnection(this);
            }
            sock = new Socket(server.getAddress(), server.getPort());
        }
        catch (UnknownHostException uhe) {
            Connection connection = this;
            synchronized (connection) {
                this.connectStatus = -2;
                this.notifyAll();
            }
            this.fireConnectionClosed();
            throw uhe;
        }
        catch (IOException ioe) {
            Connection connection = this;
            synchronized (connection) {
                this.connectStatus = -1;
                this.notifyAll();
            }
            this.fireConnectionClosed();
            throw ioe;
        }
        this.openExisting(sock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObservers(List observers) {
        this.observers.clear();
        if (observers != null) {
            List list = this.observers;
            synchronized (list) {
                this.observers.addAll(observers);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openStream(InputStream in, boolean temporary) throws IOException {
        Connection connection = this;
        synchronized (connection) {
            this.sock = null;
            this.in = new LineInputStream(in);
            this.out = NullOutputStream.getNullOutputStream();
            this.connectStatus = 2;
            this.isSSL = false;
            this.isReadClosed = false;
            this.isWriteClosed = false;
            this.openTime = System.currentTimeMillis();
        }
        if (!temporary) {
            ArrayList lobservers = new ArrayList(this.observers);
            Iterator it = lobservers.iterator();
            while (it.hasNext()) {
                ConnectionObserver co = (ConnectionObserver)it.next();
                co.acceptedConnection(this);
            }
        }
    }

    public void accept(Socket sock) throws IOException {
        this.openExisting(sock);
        ArrayList lobservers = new ArrayList(this.observers);
        Iterator it = lobservers.iterator();
        while (it.hasNext()) {
            ConnectionObserver co = (ConnectionObserver)it.next();
            co.acceptedConnection(this);
        }
    }

    public synchronized int getConnectStatus() {
        return this.connectStatus;
    }

    public synchronized void setConnectStatus(int connectStatus) {
        this.connectStatus = connectStatus;
    }

    public void connect() throws IOException, UnknownHostException {
        this.openNew(this.peerAddress);
        ArrayList lobservers = new ArrayList(this.observers);
        Iterator it = lobservers.iterator();
        while (it.hasNext()) {
            ConnectionObserver co = (ConnectionObserver)it.next();
            co.createdConnection(this);
        }
    }

    public synchronized boolean isInputShutdown() {
        if (this.isReadClosed || this.connectStatus != 2 && this.connectStatus != 1) {
            return true;
        }
        if (this.sock == null) {
            return false;
        }
        return this.sock.isClosed() || !this.sock.isConnected() || this.sock.isInputShutdown();
    }

    public synchronized boolean isOutputShutdown() {
        if (this.isWriteClosed || this.connectStatus != 2 && this.connectStatus != 1) {
            return true;
        }
        if (this.sock == null) {
            return false;
        }
        return this.sock.isClosed() || !this.sock.isConnected() || this.sock.isOutputShutdown();
    }

    public boolean isClosed() {
        return this.connectStatus != 0 && this.connectStatus != 2 && this.connectStatus != 1;
    }

    public void addObserver(ConnectionObserver co) {
        this.observers.add(co);
    }

    public void removeObserver(ConnectionObserver co) {
        this.observers.remove(co);
    }

    public synchronized boolean isSSL() {
        return this.isSSL;
    }

    public synchronized void setTargetConnection(Connection targetConnection) {
        this.targetConnection = targetConnection;
    }

    public void fireStatusChanged() {
        ArrayList lobservers = new ArrayList(this.observers);
        Iterator it = lobservers.iterator();
        while (it.hasNext()) {
            ConnectionObserver co = (ConnectionObserver)it.next();
            co.statusChanged(this);
        }
    }

    public synchronized Connection getTargetConnection() {
        return this.targetConnection;
    }

    public synchronized HostPort getPeerAddress() {
        return this.peerAddress;
    }

    public synchronized String getPeerHost() {
        if (this.peerAddress == null) {
            return null;
        }
        return this.peerAddress.getHostName();
    }

    public synchronized int getPeerPort() {
        if (this.peerAddress == null) {
            return 0;
        }
        return this.peerAddress.getPort();
    }

    public synchronized void setPeerAddress(HostPort peerAddress) {
        this.peerAddress = peerAddress;
    }

    public synchronized HostPort getLocalAddress() {
        return this.localAddress;
    }

    public synchronized long getOpenTime() {
        return this.openTime;
    }

    public synchronized SSLSession getSSLSession() {
        if (this.isSSL && this.sock != null) {
            return ((SSLSocket)this.sock).getSession();
        }
        return null;
    }

    public synchronized LineInputStream getInputStream() {
        return this.in;
    }

    public synchronized OutputStream getOutputStream() {
        return this.out;
    }

    public synchronized boolean wasConnected() {
        return this.connectStatus != 0;
    }

    public synchronized boolean isReadClosed() {
        return this.isReadClosed;
    }

    public synchronized boolean isWriteClosed() {
        return this.isWriteClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeRead() {
        this.close();
        Connection connection = this;
        synchronized (connection) {
            this.isReadClosed = true;
        }
        ArrayList lobservers = new ArrayList(this.observers);
        Iterator it = lobservers.iterator();
        while (it.hasNext()) {
            ConnectionObserver co = (ConnectionObserver)it.next();
            co.readClosedConnection(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeWrite() {
        this.close();
        Connection connection = this;
        synchronized (connection) {
            this.isWriteClosed = true;
        }
        ArrayList lobservers = new ArrayList(this.observers);
        Iterator it = lobservers.iterator();
        while (it.hasNext()) {
            ConnectionObserver co = (ConnectionObserver)it.next();
            co.writeClosedConnection(this);
        }
    }

    public synchronized void waitForConnect() throws InterruptedException {
        while (this.connectStatus == 0 || this.connectStatus == 1) {
            this.wait();
        }
    }

    public synchronized void waitForSSLConversion() throws InterruptedException {
        while (this.connectStatus == 2 && !this.isSSL) {
            this.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Connection connection = this;
        synchronized (connection) {
            if (this.isClosed()) {
                return;
            }
            this.connectStatus = 3;
            this.notifyAll();
            try {
                if (this.sock != null) {
                    this.in.close();
                    this.out.close();
                    this.sock.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.outQueue != null) {
                this.outQueue.put(null);
            }
        }
        this.fireConnectionClosed();
    }

    private void fireConnectionClosed() {
        ArrayList lobservers = new ArrayList(this.observers);
        Iterator it = lobservers.iterator();
        while (it.hasNext()) {
            ConnectionObserver co = (ConnectionObserver)it.next();
            co.closedConnection(this);
        }
    }

    public synchronized void doSSL(boolean client) throws IOException {
        String hostname = "";
        int port = 0;
        if (this.peerAddress != null) {
            hostname = this.peerAddress.getHostFast();
            port = this.peerAddress.getPort();
        }
        this.doSSL(client, hostname, port);
    }

    public synchronized void doSSL(boolean client, String host, int port) throws IOException {
        if (this.sock == null) {
            return;
        }
        if (!this.sock.isConnected()) {
            return;
        }
        this.sock.setSoTimeout(0);
        SSLSocket S = (SSLSocket)sockFactory.createSocket(this.sock, host, port, true);
        S.setUseClientMode(client);
        S.addHandshakeCompletedListener(new HandshakeCompletedListener(){

            public void handshakeCompleted(HandshakeCompletedEvent event) {
                ArrayList lobservers = new ArrayList(Connection.this.observers);
                Iterator it = lobservers.iterator();
                while (it.hasNext()) {
                    ConnectionObserver co = (ConnectionObserver)it.next();
                    co.sslHandshakeCompleted(Connection.this);
                }
            }
        });
        S.startHandshake();
        this.sock = S;
        this.in = new LineInputStream(this.sock);
        this.out = this.sock.getOutputStream();
        this.isSSL = true;
        this.notifyAll();
    }

    public SSLSocket getSSLSocket() {
        if (this.sock == null || !(this.sock instanceof SSLSocket)) {
            return null;
        }
        return (SSLSocket)this.sock;
    }

    public static void init(InputStream keyStore, String keyPass) {
        if (sockFactory != null) {
            return;
        }
        Security.addProvider((java.security.Provider)new Provider());
        Security.addProvider(new SunJCE());
        sockFactory = Connection.getSSLSocketFactory(keyStore, keyPass);
    }

    public static void init(String keyStore, String keyPass) {
        FileInputStream keyStream = null;
        if (keyStore != null) {
            try {
                keyStream = new FileInputStream(keyStore);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        Connection.init(keyStream, keyPass);
    }

    public static SSLSocketFactory getSSLSocketFactory(InputStream keystore, String pass) {
        SSLSocketFactory ssf = null;
        try {
            char[] passphrase = pass.toCharArray();
            SSLContext ctx = SSLContext.getInstance("TLS");
            TrustManager[] tm = new TrustManager[]{new X509TrustManager(){

                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }
            }};
            if (keystore != null) {
                KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                KeyStore ks = KeyStore.getInstance("JKS");
                ks.load(keystore, passphrase);
                kmf.init(ks, passphrase);
                ctx.init(kmf.getKeyManagers(), tm, null);
            } else {
                ctx.init(null, tm, null);
            }
            ssf = ctx.getSocketFactory();
            return ssf;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public synchronized void setTargetAddress(HostPort addr) {
        if (this.targetConnection == null) {
            return;
        }
        this.targetConnection.setPeerAddress(addr);
    }

    public synchronized HostPort getTargetAddress() {
        if (this.targetConnection == null) {
            return null;
        }
        return this.targetConnection.getPeerAddress();
    }

    public synchronized String toString() {
        String localHost = "<none>";
        int localPort = 0;
        if (this.localAddress != null) {
            localHost = this.localAddress.getHostName();
            localPort = this.localAddress.getPort();
        }
        return localHost + ":" + localPort + "<-" + (this.isSSL() ? "SSL" : "") + "->" + this.getPeerHost() + ":" + this.getPeerPort();
    }

    public static Connection newPair() {
        Connection src = new Connection();
        Connection dst = new Connection();
        src.setTargetConnection(dst);
        dst.setTargetConnection(src);
        return src;
    }

    public static Connection newSource(Connection dst) {
        Connection src = new Connection();
        src.setTargetConnection(dst);
        return src;
    }
}

