/*
 * Decompiled with CFR 0.152.
 */
package webshadow.comm;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.List;
import webshadow.comm.Connection;
import webshadow.util.Module;

public class Acceptor
implements Runnable {
    ServerSocket sock;
    Module connectionHandler = null;
    List observers = null;
    protected volatile boolean stop = false;
    Thread runningThread;

    public Acceptor(int port) throws IOException {
        this.sock = new ServerSocket(port);
        this.runningThread = null;
    }

    public void setObservers(List observers) {
        this.observers = observers;
    }

    public synchronized void setConnectionHandler(Module connectionHandler) {
        this.connectionHandler = connectionHandler;
        this.notify();
    }

    public synchronized void quit() {
        this.stop = true;
        if (this.runningThread != null) {
            this.runningThread.interrupt();
        }
    }

    protected Connection getConnection(Socket sock) throws IOException {
        Connection src = Connection.newPair();
        src.setObservers(this.observers);
        src.accept(sock);
        return src;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Acceptor acceptor = this;
        synchronized (acceptor) {
            this.runningThread = Thread.currentThread();
        }
        try {
            while (!this.stop) {
                try {
                    Socket newClient = this.sock.accept();
                    Connection con = null;
                    try {
                        con = this.getConnection(newClient);
                    }
                    catch (IOException e) {
                        try {
                            newClient.close();
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                    }
                    if (con == null) continue;
                    Acceptor acceptor2 = this;
                    synchronized (acceptor2) {
                        try {
                            while (!this.stop && this.connectionHandler == null) {
                                this.wait();
                            }
                            this.connectionHandler.put(con);
                        }
                        catch (InterruptedException ie) {
                            con.close();
                        }
                    }
                }
                catch (InterruptedIOException e) {
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

