/*
 * Decompiled with CFR 0.152.
 */
package webshadow;

import java.io.IOException;
import webshadow.comm.Acceptor;
import webshadow.comm.Connection;
import webshadow.comm.MessageWriter;
import webshadow.http.ConnectMessageInterceptor;
import webshadow.http.HttpRequestReader;
import webshadow.http.HttpRequestWriter;
import webshadow.http.HttpResponseReader;
import webshadow.http.RequestConnector;
import webshadow.http.ResponseMessageSender;
import webshadow.util.Queue;

public class TestProxy {
    public static void main(String[] args) {
        Acceptor acceptor;
        int port = 8080;
        int numThreads = 5;
        try {
            Connection.init(Class.forName("webshadow.TestProxy").getResourceAsStream("/webshadow/sslkeys"), "passphrase");
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        Queue reqReadQueue = new Queue();
        Queue reqWriteQueue = new Queue();
        Queue resReadQueue = new Queue();
        Queue resWriteQueue = new Queue();
        Queue reqQueue = new Queue();
        try {
            acceptor = new Acceptor(port);
        }
        catch (IOException ioe) {
            System.err.println("Error creating acceptor:" + ioe);
            return;
        }
        new Thread((Runnable)acceptor, "Acceptor (" + port + ")").start();
        ResponseMessageSender responseMessageSender = new ResponseMessageSender();
        HttpRequestReader[] reqReaders = new HttpRequestReader[numThreads];
        for (int i = 0; i < reqReaders.length; ++i) {
            reqReaders[i] = new HttpRequestReader();
            reqReaders[i].setModuleQueue(reqReadQueue);
            reqReaders[i].setMessageHandler(reqQueue);
            new Thread((Runnable)reqReaders[i], "Request Reader " + i).start();
        }
        HttpResponseReader[] resReaders = new HttpResponseReader[numThreads];
        for (int i = 0; i < reqReaders.length; ++i) {
            resReaders[i] = new HttpResponseReader();
            resReaders[i].setModuleQueue(resReadQueue);
            resReaders[i].setMessageHandler(responseMessageSender);
            new Thread((Runnable)resReaders[i], "Response Reader " + i).start();
        }
        HttpRequestWriter[] reqWriters = new HttpRequestWriter[numThreads];
        for (int i = 0; i < reqWriters.length; ++i) {
            reqWriters[i] = new HttpRequestWriter();
            reqWriters[i].setModuleQueue(reqWriteQueue);
            new Thread((Runnable)reqWriters[i], "Request Writer " + i).start();
        }
        MessageWriter[] resWriters = new MessageWriter[numThreads];
        for (int i = 0; i < resWriters.length; ++i) {
            resWriters[i] = new MessageWriter();
            resWriters[i].setModuleQueue(resWriteQueue);
            new Thread((Runnable)resWriters[i], "Response Writer " + i).start();
        }
        ConnectMessageInterceptor sslIntercept = new ConnectMessageInterceptor();
        acceptor.setConnectionHandler(sslIntercept);
        RequestConnector connector = new RequestConnector();
        connector.setModuleQueue(reqQueue);
        connector.setConnectionHandlers(reqWriteQueue, resReadQueue);
        new Thread((Runnable)connector, "Connector").start();
        System.out.println("Serving on port 8080");
    }
}

